/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.PreparedQuery;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableTreeNode;
import oracle.dbtools.raptor.utils.DBObject;

class CachableQuery
extends PreparedQuery {
    static String q = " select  (select count(1) from sys.all_constraints  where      owner      = :v1  and        table_name = :v2  and constraint_type in ('P', 'U'))  +  (select count(1) from sys.all_indexes  where      table_owner = :v1  and table_name  = :v2  and uniqueness = 'UNIQUE'  ) a  from dual";

    public CachableQuery(DBObject dBObject) {
        super(dBObject, q);
    }

    public boolean executeQuery(CGCTableTreeNode cGCTableTreeNode) {
        int n = cGCTableTreeNode.getNumIndices();
        if (n > -1) {
            return n > 0;
        }
        boolean bl = false;
        try {
            this._p3m.setup();
            this._stmt.setString(1, cGCTableTreeNode.getRealOwnerName());
            this._stmt.setString(2, cGCTableTreeNode.getRealTableName());
            ResultSet resultSet = this._stmt.executeQuery();
            resultSet.next();
            n = resultSet.getInt(1);
            resultSet.close();
            cGCTableTreeNode.setNumIndices(n);
            bl = n > 0;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        try {
            this._p3m.restore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }
}

