/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.awt.Component;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.NumberFormatter;
import oracle.dbtools.raptor.timesten.CacheInfo;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.timesten.dialogs.TTDialog;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;

public final class CGWherePanel
extends DialogBase {
    private JFormattedTextField gui_nRows;
    private JFormattedTextField gui_nThreads;
    private JTextArea gui_where;
    private JTextField _hidden_action;
    private String _actionVerb;
    private boolean _whereOnly;
    private boolean _noWhere;
    private int _cacheAgentIsRunning = -1;
    private static final String[] actionSql = new String[]{"#0# cache group \"#OBJECT_OWNER#\".\"#OBJECT_NAME#\"\n where #3#\n commit every #1# rows\n parallel #2#", "#0# cache group \"#OBJECT_OWNER#\".\"#OBJECT_NAME#\"\n where #3#\n commit every #1# rows", "#0# cache group \"#OBJECT_OWNER#\".\"#OBJECT_NAME#\"\n commit every #1# rows\n parallel #2#", "#0# cache group \"#OBJECT_OWNER#\".\"#OBJECT_NAME#\"\n commit every #1# rows", "#0# cache group \"#OBJECT_OWNER#\".\"#OBJECT_NAME#\"", "#0# cache group \"#OBJECT_OWNER#\".\"#OBJECT_NAME#\"\n where #1#"};

    @Override
    public boolean applicable(DBObject dBObject) {
        if (CGCPanel.isNonCacheConnection(dBObject)) {
            TTDialog.showError(Messages.getString("CGCPanel.creatingACacheGroupRequiresACacheConnection"));
            return false;
        }
        if (this._model != null) {
            String string = (String)this._model.get("CACHE GROUP TYPEv");
            this._cacheAgentIsRunning = CacheInfo.cacheAgentIsRunning(dBObject);
            String string2 = this._actionVerb.toUpperCase();
            if (this._actionVerb.equals("refresh") && string.indexOf("Dynamic") != -1) {
                TTDialog.showError(Messages.getString("CGWherePanel.refreshDynamicCGNotAllowed"));
                return false;
            }
            if (this._actionVerb.equals("load") || this._actionVerb.equals("refresh")) {
                if (this._cacheAgentIsRunning == 0) {
                    TTDialog.showError(MessageFormat.format(Messages.getString("CGWherePanel.pleaseStartTheCacheAgentBeforePerforming"), string2));
                    return false;
                }
                if (this._cacheAgentIsRunning == -1) {
                    TTDialog.showError(MessageFormat.format(Messages.getString("CGWherePanel.unknownCacheAgentStatus"), string2));
                    return false;
                }
                if (string.indexOf("Readonly") != -1 && !((String)this._model.get("AUTOREFRESH STATEv")).equals("Paused")) {
                    TTDialog.showError(MessageFormat.format(Messages.getString("CGWherePanel.onACacheGroupRequiresThat"), string2));
                    return false;
                }
            }
            if (this._actionVerb.equals("flush") && !string.startsWith("User")) {
                TTDialog.showError(Messages.getString("CGWherePanel.manualFlushOperationsAreNotAllowed"));
                return false;
            }
        }
        return true;
    }

    @Override
    protected void otherInit(String string) {
        this._actionVerb = string.toLowerCase();
        this._whereOnly = this._actionVerb.equals("unload") || this._actionVerb.equals("flush");
        String string2 = (String)this._model.get("CACHE GROUP TYPEv");
        boolean bl = string2.indexOf("Dynamic") == -1;
        boolean bl2 = string2.indexOf("Readonly") != -1;
        this._noWhere = bl2 && bl && (this._actionVerb.equals("load") || this._actionVerb.equals("unload") || this._actionVerb.equals("refresh"));
    }

    public CGWherePanel(DBObject dBObject, String string) {
        super(dBObject, string, "CGWherePanel", "cache");
    }

    @Override
    protected void initGUI() {
        Serializable serializable;
        this.addOwnerAndName(this._dict);
        this._hidden_action = new JTextField(this._actionVerb.toString().toLowerCase());
        this._textValues.add(this._hidden_action);
        if (!this._whereOnly) {
            this.addRow(Messages.getString("CGWherePanel.commitEveryNRows"));
            serializable = new DecimalFormat("#0");
            this.gui_nRows = new JFormattedTextField(new NumberFormatter((NumberFormat)serializable));
            this.gui_nRows.setValue(256);
            this._textValues.add(this.gui_nRows);
            this.addRow(Messages.getString("CGWherePanel.example256"), (Component)this.gui_nRows);
            this.addRow(Messages.getString("CGWherePanel.numThreads"));
            this.gui_nThreads = new JFormattedTextField(new NumberFormatter((NumberFormat)serializable));
            this.gui_nThreads.setValue(1);
            this._textValues.add(this.gui_nThreads);
            this.addRow((Component)null, (Component)this.gui_nThreads);
        }
        this.gui_where = new JTextArea(10, 20);
        this._textValues.add(this.gui_where);
        serializable = new JScrollPane(this.gui_where, 20, 30);
        if (!this._noWhere) {
            this.addRow(Messages.getString("CGWherePanel.whereClause"));
            this.c.new_row(1);
            this.c.anchor = 15;
            this.c.weighty = 1.0;
            this.gridbag.setConstraints((Component)serializable, this.c);
            this.add((Component)serializable);
        }
        this.setSize(this.getPreferredSize());
        this.setBackground(UIManager.getColor("EWTDialog.background"));
    }

    @Override
    public String getSql() {
        String string;
        boolean bl;
        int n = 0;
        boolean bl2 = bl = this.gui_where.getText().trim().length() > 0;
        if (this._whereOnly) {
            n = bl ? 5 : 4;
        } else {
            boolean bl3;
            string = this.gui_nThreads.getText().trim();
            boolean bl4 = bl3 = string.length() > 0;
            if (string.equals("1")) {
                bl3 = false;
            }
            n = bl ? (bl3 ? 0 : 1) : (bl3 ? 2 : 3);
        }
        string = actionSql[n];
        string.replace("#OBJECT_OWNER#", this.getUserName());
        string.replace("#OBJECT_NAME#", this.getObjectName());
        string.replace("#0#", this._hidden_action.getText().trim());
        if (!this._whereOnly) {
            string.replace("#1#", this.gui_nRows.getText().trim());
            string.replace("#2#", this.gui_nThreads.getText().trim());
        }
        string.replace("#3#", this.gui_where.getText().trim());
        return string;
    }

    @Override
    public boolean validateValues() {
        Integer n;
        boolean bl;
        if (this._whereOnly) {
            return true;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        boolean bl2 = bl = this.gui_nThreads.getText().trim().length() > 0;
        if (this.gui_nRows.getText().trim().length() <= 0) {
            stringBuffer.append(Messages.getString("CGWherePanel.errorNumRowsIsEmpty"));
            this.gui_nRows.selectAll();
        }
        if (stringBuffer.length() == 0 && bl && (n = new Integer(this.gui_nThreads.getText().trim())) <= 0) {
            stringBuffer.append(Messages.getString("CGWherePanel.errorNumThreadsPosInt"));
            this.gui_nThreads.selectAll();
        }
        if (stringBuffer.length() > 0) {
            MessageDialog.error((Component)this, (Object)stringBuffer.toString(), (String)Messages.getString("TimesTen.common.error"), null);
            return false;
        }
        return true;
    }
}

