/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.timesten.Feedback;
import oracle.dbtools.raptor.timesten.FeedbackHandler;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.PopupMenuListener;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.timesten.dialogs.TTJPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCFKQuery;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCJTree;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCOraTablesDialog;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableTreeNode;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTreeNodeSelectionListener;
import oracle.dbtools.raptor.timesten.dialogs.cache.CachableQuery;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.dialogs.MessageDialog;

public class CGCTableTreePanel
extends DialogBase
implements ActionListener,
TreeSelectionListener,
Comparator<CGCTableTreeNode>,
FeedbackHandler {
    private CGCFKQuery _qFK = null;
    private CachableQuery _qCachable = null;
    private CGCOraTablesDialog _dialog = null;
    CGCTableTreeNode _treeRootNode;
    CGCTableTreeNode _rootTableNode;
    CGCTableTreeNode _cachedNode;
    CGCTableTreeNode _uncachableNode;
    CGCTableTreeNode _noIndexNode;
    CGCTableTreeNode _notCachedNode;
    CGCTableTreeNode _noParentNode;
    CGCTableTreeNode _manuallyRemovedNode;
    CGCTableTreeNode _alreadyCachedNode;
    CGCTableTreeNode _currentSelection;
    boolean _rootJustAdded;
    JPopupMenu _popup;
    JMenuItem _rootMenu;
    JMenuItem _childMenu;
    JMenuItem _removeMenu;
    CGCJTree _tree;
    String _rootTable;
    TTJPanel _beef;
    DefaultTreeModel _treeModel;
    CGCTreeNodeSelectionListener[] _nodeSelectionListeners;
    Logger Log = Logger.getLogger(this.getClass().getName());
    private CGCTableTreeNode _firstNodeAdded;
    private CGCTableTreeNode _nodeLater = null;
    private boolean _onlyMakeVisibleLater;

    public CGCTableTreeNode getCurrentSelection() {
        return this._currentSelection;
    }

    public boolean treeIsEmpty() {
        return this._rootTableNode == null;
    }

    public CGCTableTreeNode getRootTable() {
        return this._rootTableNode;
    }

    public CGCTableTreePanel(DBObject dBObject, String string, List<JComponent> list, CGCTreeNodeSelectionListener[] cGCTreeNodeSelectionListenerArray) {
        super(dBObject, string, "CGCTableTreePanel", list);
        CGCTableTreePanel.LOUD("1 > left ");
        this._nodeSelectionListeners = cGCTreeNodeSelectionListenerArray;
    }

    private synchronized void init_qCachable() {
        if (this._qCachable != null) {
            return;
        }
        CGCTableTreePanel.LOUD("    CachableQuery: RegistryGet");
        this._qCachable = (CachableQuery)CGCPanel.RegistryGet(this._dbObject, "_qCachable");
        CGCTableTreePanel.LOUD("    ...done CachableQuery: RegistryGet");
        if (this._qCachable != null) {
            return;
        }
        CGCTableTreePanel.LOUD("    CachableQuery");
        this._qCachable = new CachableQuery(this._dbObject);
        this._qCachable.executeQuery(new CGCTableTreeNode("foo.bar", false));
    }

    private synchronized void init_qFK() {
        if (this._qFK != null) {
            return;
        }
        this._qFK = (CGCFKQuery)CGCPanel.RegistryGet(this._dbObject, "_qFK");
        if (this._qFK != null) {
            return;
        }
        CGCTableTreePanel.LOUD("    CGCFKQuery");
        this._qFK = new CGCFKQuery(this._dbObject);
        this._qFK.executeQuery(new CGCTableTreeNode("foo.bar", false), new CGCTableTreeNode("bar.foo", false));
    }

    @Override
    public void idleInit() {
        try {
            this.checkIsCancelled();
            this.init_qCachable();
            this.checkIsCancelled();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initTree() {
        this._cachedNode = new CGCTableTreeNode(Messages.getString("CGCTableTreePanel.tablesCached"));
        this._treeRootNode.add(this._cachedNode);
        this._notCachedNode = null;
        this._noParentNode = null;
        this._rootTableNode = null;
        this._manuallyRemovedNode = null;
        this._tree.scrollPathToVisible(new TreePath(this._cachedNode.getPath()));
    }

    @Override
    protected void initGUI() {
        this._beef = new TTJPanel();
        this._tree = new CGCJTree(this);
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        this._treeRootNode = new CGCTableTreeNode(Messages.getString("CGCTableTreePanel.tables"));
        this._treeModel = new DefaultTreeModel(this._treeRootNode);
        this._tree.setModel(this._treeModel);
        this._tree.setEditable(false);
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.setShowsRootHandles(true);
        this._tree.setRootVisible(false);
        this._tree.addTreeSelectionListener(this);
        Object object = (DefaultTreeCellRenderer)this._tree.getCellRenderer();
        ((DefaultTreeCellRenderer)object).setLeafIcon(null);
        ((DefaultTreeCellRenderer)object).setClosedIcon(null);
        ((DefaultTreeCellRenderer)object).setOpenIcon(null);
        Serializable serializable = new JScrollPane(this._tree);
        this._beef.addFull((Component)serializable);
        this.initTree();
        object = BorderFactory.createTitledBorder(Messages.getString("CGCTableTreePanel.tables"));
        this._beef.setBorder((Border)object);
        this._popup = new JPopupMenu();
        this._rootMenu = new JMenuItem(StringUtils.stripMnemonic((String)Messages.getString("CGCTableTreePanel.addRootTable")));
        this._childMenu = new JMenuItem(StringUtils.stripMnemonic((String)Messages.getString("CGCTableTreePanel.addChildTables")));
        this._removeMenu = new JMenuItem(StringUtils.stripMnemonic((String)Messages.getString("CGCTableTreePanel.removeTable")));
        this._rootMenu.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("CGCTableTreePanel.addRootTable")));
        this._childMenu.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("CGCTableTreePanel.addChildTables")));
        this._removeMenu.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("CGCTableTreePanel.removeTable")));
        this._childMenu.setEnabled(false);
        this._removeMenu.setEnabled(false);
        this._rootMenu.addActionListener(this);
        this._childMenu.addActionListener(this);
        this._removeMenu.addActionListener(this);
        this._popup.add(this._rootMenu);
        this._popup.add(this._childMenu);
        this._popup.add(new JSeparator());
        this._popup.add(this._removeMenu);
        object = new PopupMenuListener(this._popup);
        this._beef.addMouseListener((MouseListener)object);
        this._tree.addMouseListener((MouseListener)object);
        this._tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TreePath treePath = CGCTableTreePanel.this._tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                CGCTableTreePanel.this._tree.setSelectionPath(treePath);
            }
        });
        serializable = KeyStroke.getKeyStroke(121, 1, true);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(525, 0);
        this._beef.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CGCTableTreePanel.this.popMenu(actionEvent);
            }
        }, (KeyStroke)serializable, 0);
        this._beef.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CGCTableTreePanel.this.popMenu(actionEvent);
            }
        }, keyStroke, 0);
        this._tree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CGCTableTreePanel.this.popMenu(actionEvent);
            }
        }, (KeyStroke)serializable, 0);
        this._tree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CGCTableTreePanel.this.popMenu(actionEvent);
            }
        }, keyStroke, 0);
        this.addFull(this._beef);
    }

    public void popMenu(ActionEvent actionEvent) {
        this._popup.show(this._beef, 10, 10);
    }

    protected String getClassName(Object object) {
        String string = object.getClass().getName();
        return string.substring(1 + string.lastIndexOf("."));
    }

    protected CGCOraTablesDialog getDialog() {
        if (this._dialog == null) {
            Dialog dialog = DialogUtil.getAncestorDialog((Component)this);
            this._dialog = new CGCOraTablesDialog(dialog, "", this._dbObject);
        }
        return this._dialog;
    }

    protected void addTables(String[] stringArray, boolean bl) {
        if (stringArray != null) {
            if (bl) {
                this._rootTableNode = this.addNode(this._cachedNode, stringArray[stringArray.length - 1], true, true);
            } else {
                Object object;
                Object object2;
                Object object3;
                this._firstNodeAdded = null;
                ArrayList<CGCTableTreeNode[]> arrayList = new ArrayList<CGCTableTreeNode[]>();
                String string = CGCPanel.theDialog.getDefaultOwner();
                for (int i = 0; i < stringArray.length; ++i) {
                    object3 = stringArray[i].toString();
                    object2 = ((String)object3).indexOf(".") == -1 ? new CGCTableTreeNode((String)object3, string) : new CGCTableTreeNode((String)object3, false);
                    ((CGCTableTreeNode)object2).handleSynonym(this._dbObject);
                    arrayList.add((CGCTableTreeNode[])object2);
                }
                Object object4 = arrayList.iterator();
                while (object4.hasNext()) {
                    object3 = (CGCTableTreeNode)object4.next();
                    object2 = CGCPanel.theDialog.getTablesCacheGroup(((CGCTableTreeNode)object3).getRealName());
                    if (object2 == null) continue;
                    CGCTableTreePanel.LOUD("node already cached: " + object3);
                    this.addNode(this.getAlreadyCachedNode(), (CGCTableTreeNode)object3, false);
                    ((CGCTableTreeNode)object3).setInCG(true);
                    object4.remove();
                    CGCTableTreePanel.LOUD("..done node already cached: " + object3);
                }
                object4 = new HashSet();
                ((HashSet)object4).add(this._rootTableNode);
                object3 = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
                object2 = new TreePath(((DefaultMutableTreeNode)object3).getPath());
                Serializable serializable = new TreePath(this._rootTableNode.getPath());
                if (((TreePath)serializable).isDescendant((TreePath)object2)) {
                    ((HashSet)object4).add((CGCTableTreeNode)object3);
                }
                object3 = new ArrayList<Serializable>();
                while (!((HashSet)object4).isEmpty()) {
                    CGCTableTreeNode cGCTableTreeNode;
                    CGCTableTreePanel.LOUD("looking to add child to parents");
                    object2 = ((HashSet)object4).iterator();
                    while (object2.hasNext()) {
                        serializable = (CGCTableTreeNode)object2.next();
                        object = arrayList.iterator();
                        while (object.hasNext()) {
                            cGCTableTreeNode = (CGCTableTreeNode)object.next();
                            if (this.canBeParentChild((CGCTableTreeNode)serializable, cGCTableTreeNode)) {
                                object.remove();
                                CGCTableTreePanel.LOUD("node " + cGCTableTreeNode + " found parent: " + serializable);
                                this.addNode((CGCTableTreeNode)serializable, cGCTableTreeNode, false);
                                cGCTableTreeNode.setParentTable((CGCTableTreeNode)serializable);
                                CGCTableTreePanel.LOUD("..done node " + cGCTableTreeNode + " found parent: " + serializable);
                                if (this._firstNodeAdded != null) continue;
                                this._firstNodeAdded = cGCTableTreeNode;
                                CGCTableTreePanel.LOUD("firstNodeAdded is " + this._firstNodeAdded);
                                continue;
                            }
                            ((ArrayList)object3).add(serializable);
                        }
                        object2.remove();
                    }
                    CGCTableTreePanel.LOUD("..done looking to add child to parents");
                    CGCTableTreePanel.LOUD("recruiting parents");
                    object2 = ((ArrayList)object3).iterator();
                    while (object2.hasNext()) {
                        serializable = (CGCTableTreeNode)object2.next();
                        object = ((DefaultMutableTreeNode)serializable).children();
                        while (object.hasMoreElements()) {
                            cGCTableTreeNode = (CGCTableTreeNode)object.nextElement();
                            if (((HashSet)object4).contains(cGCTableTreeNode)) continue;
                            ((HashSet)object4).add(cGCTableTreeNode);
                            CGCTableTreePanel.LOUD("New parent candidate: " + cGCTableTreeNode);
                        }
                        object2.remove();
                    }
                }
                CGCTableTreePanel.LOUD("..done recruiting parents");
                this.getManuallyRemovedNode();
                if (!arrayList.isEmpty()) {
                    object2 = arrayList.toArray(new CGCTableTreeNode[arrayList.size()]);
                    Arrays.sort(object2, this);
                    this.getNoParentNode();
                    this.getNoIndexNode();
                    for (int i = 0; i < ((CGCTableTreeNode[])object2).length; ++i) {
                        object = object2[i];
                        ((CGCTableTreeNode)object).setOrphan(true);
                        if (this.isCachable((CGCTableTreeNode)object)) {
                            CGCTableTreePanel.LOUD(object + " now under no parent branch");
                            this.addNode(this._noParentNode, (CGCTableTreeNode)object, false);
                            ((CGCTableTreeNode)object).setParentTable(null);
                            continue;
                        }
                        CGCTableTreePanel.LOUD(object + " now under no index branch");
                        this.addNode(this._noIndexNode, (CGCTableTreeNode)object, false);
                        ((CGCTableTreeNode)object).setNoIndex(true);
                    }
                }
                if (this._uncachableNode != null && this._noParentNode != null) {
                    this._notCachedNode.insert(this._noParentNode, 0);
                    this._notCachedNode.insert(this._uncachableNode, 1);
                    this._treeModel.nodeStructureChanged(this._notCachedNode);
                    object2 = (CGCTableTreeNode)this._noParentNode.getChildAt(0);
                    this._tree.makeVisible(new TreePath(((DefaultMutableTreeNode)object2).getPath()));
                    object2 = (CGCTableTreeNode)this._uncachableNode.getChildAt(0);
                    object2 = (CGCTableTreeNode)((DefaultMutableTreeNode)object2).getChildAt(0);
                    this._tree.makeVisible(new TreePath(((DefaultMutableTreeNode)object2).getPath()));
                    object2 = (CGCTableTreeNode)this._uncachableNode.getChildAt(1);
                    object2 = (CGCTableTreeNode)((DefaultMutableTreeNode)object2).getChildAt(0);
                    this._tree.makeVisible(new TreePath(((DefaultMutableTreeNode)object2).getPath()));
                }
                CGCTableTreePanel.LOUD("making subtree visible");
                this.makeSubtreeVisible(this._cachedNode);
                CGCTableTreePanel.LOUD("..done making subtree visible");
                if (this._firstNodeAdded != null) {
                    CGCTableTreePanel.LOUD("selectedNode _firstNodeAdded: " + this._firstNodeAdded);
                    this.selectNode(this._firstNodeAdded);
                    CGCTableTreePanel.LOUD("..done selectedNode _firstNodeAdded: " + this._firstNodeAdded);
                }
            }
        }
    }

    void makeSubtreeVisible(CGCTableTreeNode cGCTableTreeNode) {
        int n = cGCTableTreeNode.getChildCount();
        if (n == 0) {
            this._tree.makeVisible(new TreePath(cGCTableTreeNode.getLastLeaf().getPath()));
        } else {
            for (int i = 0; i < n; ++i) {
                this.makeSubtreeVisible((CGCTableTreeNode)cGCTableTreeNode.getChildAt(i));
            }
        }
    }

    CGCTableTreeNode getNotCachedNode() {
        if (this._notCachedNode == null) {
            this._notCachedNode = this.addNode(Messages.getString("CGCTableTreePanel.tablesNotCached"));
            this.getManuallyRemovedNode(this._notCachedNode);
        }
        return this._notCachedNode;
    }

    CGCTableTreeNode getNoParentNode() {
        if (this._noParentNode == null) {
            this._noParentNode = new CGCTableTreeNode(Messages.getString("CGCTableTreePanel.parentsUnkown"), false);
            this.addNode(this.getNotCachedNode(), this._noParentNode, false);
        }
        return this._noParentNode;
    }

    CGCTableTreeNode getManuallyRemovedNode() {
        return this.getManuallyRemovedNode(null);
    }

    CGCTableTreeNode getManuallyRemovedNode(CGCTableTreeNode cGCTableTreeNode) {
        if (this._manuallyRemovedNode == null) {
            this._manuallyRemovedNode = new CGCTableTreeNode(Messages.getString("CGCTableTreePanel.manuallyRemovedByUser"), false);
            if (cGCTableTreeNode == null) {
                cGCTableTreeNode = this.getNotCachedNode();
            }
            this.addNode(cGCTableTreeNode, this._manuallyRemovedNode, true);
            this._manuallyRemovedNode.setRefuseDrop(false);
        }
        return this._manuallyRemovedNode;
    }

    CGCTableTreeNode getUncachableNode() {
        if (this._uncachableNode == null) {
            this._uncachableNode = new CGCTableTreeNode(Messages.getString("CGCTableTreePanel.uncacheable"), false);
            this.addNode(this.getNotCachedNode(), this._uncachableNode, false);
        }
        return this._uncachableNode;
    }

    CGCTableTreeNode getNoIndexNode() {
        if (this._noIndexNode == null) {
            this._noIndexNode = new CGCTableTreeNode(Messages.getString("CGCTableTreePanel.noIndexOrPK"), false);
            this.addNode(this.getUncachableNode(), this._noIndexNode, true);
        }
        return this._noIndexNode;
    }

    CGCTableTreeNode getAlreadyCachedNode() {
        if (this._alreadyCachedNode == null) {
            this._alreadyCachedNode = new CGCTableTreeNode(Messages.getString("CGCTableTreePanel.tablesAlreadyInACacheGroup"), false);
            this.addNode(this.getUncachableNode(), this._alreadyCachedNode, true);
        }
        return this._alreadyCachedNode;
    }

    boolean canBeParentChild(CGCTableTreeNode cGCTableTreeNode, CGCTableTreeNode cGCTableTreeNode2) {
        new Feedback(this, "init_qFK");
        this.init_qFK();
        this._qFK.executeQuery(cGCTableTreeNode, cGCTableTreeNode2);
        return this._qFK.isRelated();
    }

    boolean isCachable(CGCTableTreeNode cGCTableTreeNode) {
        new Feedback(this, "init_qCachable");
        if (cGCTableTreeNode == null) {
            return false;
        }
        int n = cGCTableTreeNode.getCachable();
        if (n != 0) {
            return n > 0;
        }
        CGCTableTreePanel.LOUD("isCachable");
        if (this._qCachable == null) {
            this.init_qCachable();
        }
        CGCTableTreePanel.LOUD("   isCachable executeQuery");
        boolean bl = this._qCachable.executeQuery(cGCTableTreeNode);
        CGCTableTreePanel.LOUD("..done isCachable");
        return bl;
    }

    CGCTableTreeNode getParentTableCandidate() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
        return defaultMutableTreeNode == null ? this._rootTableNode : (CGCTableTreeNode)defaultMutableTreeNode;
    }

    protected CGCTableTreeNode addNode(Object object) {
        return this.addNode(null, object, false, false);
    }

    protected CGCTableTreeNode addNode(CGCTableTreeNode cGCTableTreeNode, Object object, boolean bl, boolean bl2) {
        if (cGCTableTreeNode == null) {
            cGCTableTreeNode = this._treeRootNode;
        }
        CGCTableTreeNode cGCTableTreeNode2 = new CGCTableTreeNode(object.toString(), bl2);
        cGCTableTreeNode2.handleSynonym(this._dbObject);
        return this.addNode(cGCTableTreeNode, cGCTableTreeNode2, bl);
    }

    protected CGCTableTreeNode addNode(CGCTableTreeNode cGCTableTreeNode, CGCTableTreeNode cGCTableTreeNode2, boolean bl) {
        if (cGCTableTreeNode == null) {
            cGCTableTreeNode = this._treeRootNode;
        }
        CGCTableTreePanel.LOUD("inserting node under parent");
        this._treeModel.insertNodeInto(cGCTableTreeNode2, cGCTableTreeNode, cGCTableTreeNode.getChildCount());
        CGCTableTreePanel.LOUD("..done inserting node under parent");
        if (bl) {
            CGCTableTreePanel.LOUD("selectNode(childNode): " + cGCTableTreeNode2);
            this.selectNode(cGCTableTreeNode2);
            CGCTableTreePanel.LOUD("..done selectNode(childNode) " + cGCTableTreeNode2);
        }
        return cGCTableTreeNode2;
    }

    protected boolean selectNode() {
        return this.selectNode(null, false);
    }

    protected boolean selectNode(CGCTableTreeNode cGCTableTreeNode) {
        return this.selectNode(cGCTableTreeNode, false);
    }

    protected synchronized boolean selectNode(CGCTableTreeNode cGCTableTreeNode, boolean bl) {
        if (cGCTableTreeNode != null && !cGCTableTreeNode.isTable()) {
            return false;
        }
        String string = "";
        try {
            string = Thread.currentThread().getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CGCTableTreePanel.LOUD("selectNode(" + cGCTableTreeNode + "," + bl + ") in \"" + string + "\"");
        if (!string.startsWith("AWT-EventQueue")) {
            this._nodeLater = cGCTableTreeNode;
            this._onlyMakeVisibleLater = bl;
            CGCTableTreePanel.LOUD("selection of " + cGCTableTreeNode + " deferred");
        } else {
            if (cGCTableTreeNode == null) {
                if (this._nodeLater == null) {
                    return false;
                }
                cGCTableTreeNode = this._nodeLater;
                bl = this._onlyMakeVisibleLater;
                CGCTableTreePanel.LOUD("Performming deferred selection of " + cGCTableTreeNode + "");
            }
            this._nodeLater = null;
            TreePath treePath = new TreePath(cGCTableTreeNode.getPath());
            CGCTableTreePanel.LOUD("making visible, path = " + treePath);
            this._tree.makeVisible(treePath);
            CGCTableTreePanel.LOUD("..done making visible, path = " + treePath);
            if (!bl) {
                CGCTableTreePanel.LOUD("getParentPath");
                TreePath treePath2 = treePath.getParentPath().pathByAddingChild(cGCTableTreeNode);
                CGCTableTreePanel.LOUD("..done getParentPath");
                CGCTableTreePanel.LOUD("setSelectionPath");
                this._tree.setSelectionPath(treePath2);
                CGCTableTreePanel.LOUD("..done setSelectionPath");
            }
        }
        return true;
    }

    protected void removeWholeTree() {
        this._treeRootNode.removeAllChildren();
        this._treeModel.reload();
        this._rootTableNode = null;
        this._uncachableNode = null;
        this._noIndexNode = null;
        this._notCachedNode = null;
        this._noParentNode = null;
        this._manuallyRemovedNode = null;
        this._alreadyCachedNode = null;
        this._currentSelection = null;
    }

    private void removeNode(CGCTableTreeNode cGCTableTreeNode) {
        if (cGCTableTreeNode == this._cachedNode) {
            return;
        }
        if (cGCTableTreeNode == this._treeRootNode) {
            return;
        }
        if (cGCTableTreeNode == this._uncachableNode) {
            this._uncachableNode = null;
        } else if (cGCTableTreeNode == this._noIndexNode) {
            this._noIndexNode = null;
        } else if (cGCTableTreeNode == this._notCachedNode) {
            this._notCachedNode = null;
        } else if (cGCTableTreeNode == this._noParentNode) {
            this._noParentNode = null;
        } else if (cGCTableTreeNode == this._alreadyCachedNode) {
            this._alreadyCachedNode = null;
        }
        CGCTableTreeNode cGCTableTreeNode2 = (CGCTableTreeNode)cGCTableTreeNode.getParent();
        if (cGCTableTreeNode2 != null) {
            int n = cGCTableTreeNode2.getLeafCount();
            Enumeration<TreeNode> enumeration = cGCTableTreeNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                CGCTableTreeNode cGCTableTreeNode3 = (CGCTableTreeNode)enumeration.nextElement();
                if (!cGCTableTreeNode3.isTable()) continue;
                String string = cGCTableTreeNode3.getRealName();
                CGCTableTreePanel.LOUD("Adding back to ora table list: " + string);
                this.getDialog().putTable(string);
            }
            this._treeModel.removeNodeFromParent(cGCTableTreeNode);
            if (n == 1) {
                if (cGCTableTreeNode2 == this._uncachableNode || cGCTableTreeNode2 == this._noIndexNode || cGCTableTreeNode2 == this._notCachedNode || cGCTableTreeNode2 == this._noParentNode || cGCTableTreeNode2 == this._alreadyCachedNode) {
                    this.removeNode(cGCTableTreeNode2);
                }
                cGCTableTreeNode2 = null;
            }
        }
        CGCTableTreeNode cGCTableTreeNode4 = cGCTableTreeNode2 != null ? cGCTableTreeNode2 : this._rootTableNode;
        CGCTableTreePanel.LOUD("selectNode(whoToSelect) " + cGCTableTreeNode4);
        this.selectNode(cGCTableTreeNode4);
        CGCTableTreePanel.LOUD("..done selectNode(whoToSelect) " + cGCTableTreeNode4);
    }

    public void startOver() {
        this.removeWholeTree();
        this.initTree();
        CGCPanel.theDialog.nodeSelected(null);
    }

    @Override
    public int compare(CGCTableTreeNode cGCTableTreeNode, CGCTableTreeNode cGCTableTreeNode2) {
        return cGCTableTreeNode.toString().compareTo(cGCTableTreeNode2.toString());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = "Action event detected.\n    Event source: " + jMenuItem.getText() + " (an instance of " + this.getClassName(jMenuItem) + ")";
        CGCOraTablesDialog cGCOraTablesDialog = this.getDialog();
        Dialog dialog = DialogUtil.getAncestorDialog((Component)this);
        CGCPanel cGCPanel = CGCPanel.theDialog;
        boolean bl = false;
        if (this.getClassName(jMenuItem).equals("JMenuItem")) {
            boolean bl2 = true;
            if (jMenuItem == this._removeMenu) {
                bl2 = false;
                CGCTableTreeNode cGCTableTreeNode = (CGCTableTreeNode)this._tree.getLastSelectedPathComponent();
                if (cGCTableTreeNode != this._rootTableNode) {
                    this.removeNode(cGCTableTreeNode);
                } else {
                    bl = MessageDialog.confirm((Component)dialog, (Object)Messages.getString("CGCTableTreePanel.removingTheRootTableImpliesStartingOver"), (String)Messages.getString("TimesTen.common.confirmation"), null, (boolean)true);
                }
            }
            boolean bl3 = true;
            while (bl3) {
                Object object;
                bl3 = false;
                this._firstNodeAdded = null;
                if (bl || jMenuItem == this._rootMenu) {
                    cGCPanel.startOver();
                    bl = true;
                    bl2 = true;
                    cGCOraTablesDialog.setTitle(Messages.getString("CGCOraTablesDialog.showTheRootTable"));
                    cGCOraTablesDialog.reInitTableList();
                } else if (jMenuItem == this._childMenu) {
                    cGCOraTablesDialog._rootTable = this._rootTableNode.toString();
                    cGCOraTablesDialog.setTitle(Messages.getString("CGCTableTreePanel.selectOneOrMoreChildTables"));
                }
                if (!bl2) continue;
                cGCOraTablesDialog.setLocationRelativeTo(dialog);
                cGCOraTablesDialog.show();
                if (cGCOraTablesDialog.isCancelled()) {
                    if (this._rootTableNode == null) {
                        this._rootMenu.setEnabled(true);
                        this._childMenu.setEnabled(false);
                        this._removeMenu.setEnabled(false);
                    }
                    return;
                }
                final String[] stringArray = cGCOraTablesDialog.getTables();
                this._rootJustAdded = bl;
                if (bl) {
                    Object object2;
                    object = stringArray[stringArray.length - 1];
                    CGCTableTreePanel.LOUD("creating node");
                    CGCTableTreeNode cGCTableTreeNode = new CGCTableTreeNode((String)object, true);
                    cGCTableTreeNode.handleSynonym(this._dbObject);
                    this._rootTableNode = cGCTableTreeNode;
                    CGCTableTreePanel.LOUD("..done creating node");
                    String string2 = null;
                    CGCTableTreePanel.LOUD("check if cachable");
                    if (!this.isCachable(cGCTableTreeNode)) {
                        CGCTableTreePanel.LOUD("..done check if cachable");
                        string2 = MessageFormat.format(Messages.getString("CGCTableTreePanel.containsNoPKOrIndices"), object);
                    } else {
                        CGCTableTreePanel.LOUD("..done check if cachable");
                        CGCTableTreePanel.LOUD("check if already in cache group");
                        object2 = cGCPanel.getTablesCacheGroup(cGCTableTreeNode.getRealName());
                        CGCTableTreePanel.LOUD("..done check if already in cache group");
                        if (object2 != null) {
                            string2 = MessageFormat.format(Messages.getString("CGCTableTreePanel.alreadyBelongsToCacheGroup"), object, object2);
                        }
                    }
                    if (string2 != null) {
                        MessageDialog.error((Component)this, (Object)string2, (String)"Error", null);
                        bl3 = true;
                        cGCTableTreeNode.unsetIsRootTable();
                        continue;
                    }
                    object2 = cGCTableTreeNode;
                    CGCTableTreePanel.LOUD("feedback starting");
                    ProgressRunnable progressRunnable = new ProgressRunnable((CGCTableTreeNode)object2){
                        final /* synthetic */ CGCTableTreeNode val$fnode;
                        {
                            this.val$fnode = cGCTableTreeNode;
                        }

                        protected Object doWork() throws Exception {
                            DialogBase.LOUD("adding node to tree");
                            CGCTableTreePanel.this.addNode(CGCTableTreePanel.this._cachedNode, this.val$fnode, true);
                            DialogBase.LOUD("..done adding node to tree");
                            return null;
                        }
                    };
                    progressRunnable.setTitle(Messages.getString("CGCTableTreePanel.addingRootTable"));
                    progressRunnable.setCancelable(false);
                    try {
                        progressRunnable.start(true);
                    }
                    catch (ProgressException progressException) {
                        // empty catch block
                    }
                    CGCTableTreePanel.LOUD("..done feedback starting");
                } else {
                    object = new ProgressRunnable(){

                        protected Object doWork() throws Exception {
                            CGCTableTreePanel.this.addTables(stringArray, false);
                            return null;
                        }
                    };
                    object.setTitle(Messages.getString("CGCTableTreePanel.addingChildTables"));
                    object.setCancelable(false);
                    try {
                        object.start(true);
                    }
                    catch (ProgressException progressException) {
                        // empty catch block
                    }
                }
                if (bl) {
                    this._rootMenu.setEnabled(false);
                    this._childMenu.setEnabled(true);
                } else {
                    this._childMenu.setLabel(Messages.getString("CGCTableTreePanel.addMoreChildTables"));
                    this._tree.expandTree(true);
                }
                this.selectNode(this._firstNodeAdded);
            }
            CGCTableTreeNode cGCTableTreeNode = (CGCTableTreeNode)this._tree.getLastSelectedPathComponent();
            if (cGCTableTreeNode != null) {
                cGCPanel.nodeSelected(cGCTableTreeNode);
            }
        }
    }

    @Override
    public String getSql() {
        StringBuffer stringBuffer = new StringBuffer(2000);
        if (this._rootTableNode == null) {
            return CGCPanel.theDialog.getAgingPanel().getSql();
        }
        this.getSql(this._rootTableNode, stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    public boolean validateValues() {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this._rootTableNode == null) {
            stringBuffer.append(Messages.getString("CGCTableTreePanel.noTablesSelectedForCaching"));
        }
        if (stringBuffer.length() > 0) {
            MessageDialog.error((Component)this, (Object)stringBuffer.toString(), (String)Messages.getString("TimesTen.common.error"), null);
            return false;
        }
        return true;
    }

    private void qq(String string, StringBuffer stringBuffer) {
        stringBuffer.append("\"");
        stringBuffer.append(string);
        stringBuffer.append("\"");
    }

    public void getSql(CGCTableTreeNode cGCTableTreeNode, StringBuffer stringBuffer) {
        if (cGCTableTreeNode == null) {
            return;
        }
        int n = cGCTableTreeNode.getLeafCount();
        stringBuffer.append(cGCTableTreeNode == this._rootTableNode ? "\n  " : ",\n  ");
        this.qq(cGCTableTreeNode.getOwnerName(), stringBuffer);
        stringBuffer.append(".");
        this.qq(cGCTableTreeNode.getTableName(), stringBuffer);
        cGCTableTreeNode.getSql(stringBuffer);
        if (cGCTableTreeNode == this._rootTableNode) {
            stringBuffer.append(CGCPanel.theDialog.getAgingPanel().getSql());
        }
        if (cGCTableTreeNode.getChildCount() >= 0) {
            Enumeration<TreeNode> enumeration = cGCTableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                CGCTableTreeNode cGCTableTreeNode2 = (CGCTableTreeNode)enumeration.nextElement();
                this.getSql(cGCTableTreeNode2, stringBuffer);
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        CGCTableTreeNode cGCTableTreeNode = (CGCTableTreeNode)this._tree.getLastSelectedPathComponent();
        if (cGCTableTreeNode == null) {
            return;
        }
        this._currentSelection = cGCTableTreeNode;
        this._removeMenu.setEnabled(cGCTableTreeNode != null);
        for (int i = 0; i < this._nodeSelectionListeners.length; ++i) {
            this._nodeSelectionListeners[i].nodeSelected(cGCTableTreeNode);
        }
    }

    @Override
    public void doWork(Object object) {
        String string = (String)object;
        if (string.equals("init_qCachable()")) {
            this.init_qCachable();
        } else if (string.equals("init_qFK()")) {
            this.init_qFK();
        }
    }
}

