/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.timesten.DataSheet;
import oracle.dbtools.raptor.timesten.Feedback;
import oracle.dbtools.raptor.timesten.FeedbackHandler;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.SimpleQuery;
import oracle.dbtools.raptor.timesten.connection.X10ConnectionProperties;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.timesten.dialogs.TTDialog;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCAgingPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCCGPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCColInfo;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableColsTableModel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableTreeNode;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTablesPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

public class CGCPanel
extends DialogBase
implements Runnable,
FeedbackHandler {
    public static CGCPanel theDialog;
    public static final boolean inhibitIdleInit;
    private static Hashtable<Connection, Hashtable<String, Object>> registries;
    ArrayList _timestampCols;
    Object[] _tables;
    Hashtable<String, String> _tblsingroups = null;
    private CGCCGPanel _cgPanel;
    private CGCTablesPanel _tablesPanel;
    private CGCAgingPanel _agingPanel;
    private JTextField _gui_dummy;
    Thread _t = null;

    private static Hashtable<String, Object> getMap(DBObject dBObject) {
        Connection connection = dBObject.getConnection();
        Hashtable<String, Object> hashtable = registries.get(connection);
        if (hashtable != null) {
            boolean bl = false;
            try {
                bl = connection.isClosed();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                registries.remove(connection);
                hashtable = null;
            }
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
            registries.put(connection, hashtable);
        }
        return hashtable;
    }

    public static synchronized Object RegistryGet(DBObject dBObject, String string) {
        Hashtable<String, Object> hashtable = CGCPanel.getMap(dBObject);
        return hashtable.get(string);
    }

    public static synchronized void RegistryPut(DBObject dBObject, String string, Object object) {
        Hashtable<String, Object> hashtable = CGCPanel.getMap(dBObject);
        hashtable.put(string, object);
    }

    public static boolean isNonCacheConnection(DBObject dBObject) {
        String string = dBObject.getConnectionName();
        Connections connections = Connections.getInstance();
        String string2 = X10ConnectionProperties.getTheInstance().getProperty(Connections.getConnectionName((String)string), "sys2");
        boolean bl = string2 == null || string2.length() == 0;
        return bl;
    }

    public static boolean allowTypeMapLOB(DBObject dBObject) {
        DataSheet dataSheet = DataSheet.getInstance();
        boolean bl = dataSheet.isCapable(dBObject, DataSheet.FeatureType.TypeMapLOB);
        return bl;
    }

    public static boolean allowDynamicCG(DBObject dBObject) {
        DataSheet dataSheet = DataSheet.getInstance();
        boolean bl = dataSheet.isCapable(dBObject, DataSheet.FeatureType.GlobalDynamicCG);
        return bl;
    }

    public static boolean allowSecondsLevelTBAging(DBObject dBObject) {
        DataSheet dataSheet = DataSheet.getInstance();
        boolean bl = dataSheet.isCapable(dBObject, DataSheet.FeatureType.SecondsPrecisionTimeBasedAging);
        return bl;
    }

    public static boolean allowNonDynamicGlobalCG(DBObject dBObject) {
        DataSheet dataSheet = DataSheet.getInstance();
        boolean bl = dataSheet.isCapable(dBObject, DataSheet.FeatureType.NonDynamicGlobalCG);
        return bl;
    }

    public static String getGridName(DBObject dBObject) {
        return (String)CGCPanel.RegistryGet(dBObject, "gridName");
    }

    public void cgTypeChanged() {
        this._tablesPanel.cgTypeChanged();
    }

    public boolean isRO() {
        int n = this._cgPanel.getCGType();
        return n == 1 || n == 4;
    }

    public boolean isDynamicCG() {
        return this._cgPanel.isCGTypeDynamic();
    }

    public boolean isGlobalCG() {
        return this._cgPanel.isCGTypeGlobal();
    }

    public boolean isAWT() {
        return this._cgPanel.getCGType() == 2;
    }

    public boolean isSWT() {
        return this._cgPanel.getCGType() == 3;
    }

    public int getCGType() {
        return this._cgPanel.getCGType();
    }

    public boolean isAutorefresh() {
        return this._cgPanel.isAutorefresh();
    }

    public boolean isAgingTB() {
        return this._agingPanel.getAgingType() == 2;
    }

    public CGCTableTreeNode getRootTable() {
        return this._tablesPanel.getRootTable();
    }

    public boolean isRootColCached(String string) {
        CGCTableTreeNode cGCTableTreeNode = this.getRootTable();
        CGCColInfo cGCColInfo = cGCTableTreeNode.getCol(string);
        return cGCColInfo.getCached();
    }

    public boolean hasTimestampCols() {
        Iterator iterator = theDialog.getTimestampCols();
        if (iterator != null) {
            try {
                while (iterator.hasNext()) {
                    String string = iterator.next().toString();
                    if (!this.isRootColCached(string)) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void nudgeTheDialog() {
        this.fixupAgingOptions();
        this.fixupWhereBox();
    }

    public void fixMenuAgingTB() {
        this._agingPanel.fixMenuAgingTB();
    }

    public void fixupAgingOptions() {
        this._agingPanel.fixupAgingOptions();
    }

    public void fixupWhereBox() {
        this._tablesPanel.fixupWhereBox();
    }

    public void nodeSelected(CGCTableTreeNode cGCTableTreeNode) {
        this._tablesPanel.nodeSelected(cGCTableTreeNode);
    }

    public String getDefaultOwner() {
        return this.getUserName();
    }

    CGCAgingPanel getAgingPanel() {
        return this._agingPanel;
    }

    CGCTablesPanel getTablePanel() {
        return this._tablesPanel;
    }

    public void startOver() {
        this.clearTimestampCols();
        this._tablesPanel.startOver();
        this._agingPanel.startOver();
    }

    public CGCTableColsTableModel getTableModel(CGCTableTreeNode cGCTableTreeNode) {
        return this._tablesPanel.getTableModel(cGCTableTreeNode);
    }

    public void clearTimestampCols() {
        this._timestampCols.clear();
    }

    public void saveTimestampCol(CGCColInfo cGCColInfo) {
        this._timestampCols.add(cGCColInfo);
    }

    public Iterator getTimestampCols() {
        return this._timestampCols.iterator();
    }

    public Object[] getTableList() {
        new Feedback(this, "init_tables()");
        return this._tables;
    }

    public CGCTableTreeNode getCurrentSelection() {
        return this._tablesPanel.getCurrentSelection();
    }

    public boolean isVanillaCG() {
        int n = this._cgPanel.getCGType();
        if (n == 1) {
            return false;
        }
        if (n == 2) {
            return false;
        }
        if (n == 3) {
            return false;
        }
        if (n >= 4) {
            return false;
        }
        if (n >= 5) {
            return false;
        }
        return !this._cgPanel.isAutorefresh();
    }

    public String getTablesCacheGroup(String string) {
        new Feedback(this, "init_tblsingroups()");
        CGCPanel.LOUD("looking up table's CG: " + string);
        String string2 = this._tblsingroups.get(string);
        CGCPanel.LOUD("..done looking up table's CG: " + string + " -> " + string2);
        return string2;
    }

    public String getTablesCG(String string) {
        this.init_tblsingroups();
        return this._tblsingroups.get(string);
    }

    public void setThingsChanged() {
        this._gui_dummy.setText(this._gui_dummy.getText().length() > 0 ? "" : "x");
    }

    synchronized void setIdleThreadID(Thread thread) {
        this._t = thread;
    }

    synchronized Thread getIdleThreadID() {
        return this._t;
    }

    public CGCPanel(DBObject dBObject, String string) {
        super(dBObject, string, "CGCPanel");
        theDialog = this;
    }

    @Override
    public boolean applicable(DBObject dBObject) {
        String[] stringArray = SimpleQuery.nStringColQuery(dBObject, "call ttCacheUidGet()", 1);
        if (CGCPanel.isNonCacheConnection(dBObject)) {
            TTDialog.showError(Messages.getString("CGCPanel.creatingACacheGroupRequiresACacheConnection"));
            return false;
        }
        if (stringArray == null || stringArray.length > 0 && stringArray[0] == null) {
            TTDialog.showError(Messages.getString("CGCPanel.creatingACacheGroupRequiresThatThe"));
            return false;
        }
        return true;
    }

    @Override
    protected void initGUI() {
        Object object;
        if (!inhibitIdleInit) {
            object = this.getIdleThreadID();
            if (object != null) {
                return;
            }
            object = new Thread((Runnable)this, "Idle Init");
            ((Thread)object).setDaemon(true);
            ((Thread)object).setPriority(10);
            ((Thread)object).start();
            this.setIdleThreadID((Thread)object);
        } else {
            this.idleInit();
        }
        object = "";
        try {
            if (CGCPanel.allowDynamicCG(this._dbObject)) {
                object = SimpleQuery.ttGridNameGet(this._dbObject);
            }
            CGCPanel.RegistryPut(this._dbObject, "gridName", object);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "failed to get grid name");
        }
        this._cgPanel = new CGCCGPanel(this._dbObject, null, this._textValues);
        this._tablesPanel = new CGCTablesPanel(this._dbObject, null, this._textValues);
        this._agingPanel = new CGCAgingPanel(this._dbObject, null, this._textValues);
        this._gui_dummy = new JTextField("x");
        this._textValues.add(this._gui_dummy);
        this._timestampCols = new ArrayList();
        this.fixupAgingOptions();
    }

    @Override
    public final String[] getTabTitles() {
        return new String[]{Messages.getString("CGCPanel.cacheGroupAttributes"), Messages.getString("CGCPanel.tables"), Messages.getString("CGCPanel.aging"), Messages.getString("CGCPanel.DDL")};
    }

    @Override
    public JPanel[] getPanels(JPanel jPanel) {
        return new JPanel[]{this._cgPanel, this._tablesPanel, this._agingPanel, jPanel};
    }

    @Override
    public String getConfirmMessage() {
        return MessageFormat.format(Messages.getString("CGCPanel.cacheGroupHasBeenCreated"), this._cgPanel.getName());
    }

    @Override
    public String getSql() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("CREATE " + this._cgPanel.getCGTypeDynamic());
        switch (this._cgPanel.getCGType()) {
            case 1: {
                stringBuffer.append("READONLY ");
                break;
            }
            case 2: {
                stringBuffer.append("ASYNCHRONOUS WRITETHROUGH ");
                break;
            }
            case 3: {
                stringBuffer.append("SYNCHRONOUS WRITETHROUGH ");
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                stringBuffer.append("USERMANAGED ");
                break;
            }
        }
        stringBuffer.append(this._cgPanel.getCGTypeGlobal());
        stringBuffer.append("CACHE GROUP");
        stringBuffer.append(" \"");
        stringBuffer.append(this._cgPanel.getName());
        stringBuffer.append("\" \n");
        stringBuffer.append(this._cgPanel.getSql());
        stringBuffer.append(" FROM");
        stringBuffer.append(this._tablesPanel.getSql());
        return stringBuffer.toString();
    }

    @Override
    public boolean validateValues() {
        return this._cgPanel.validateValues() && this._tablesPanel.validateValues() && this._agingPanel.validateValues();
    }

    @Override
    public void run() {
        this.idleInit();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "idle init done");
        this.setIdleThreadID(null);
    }

    private synchronized void init_tblsingroups() {
        if (this._tblsingroups != null) {
            return;
        }
        CGCPanel.LOUD("tblsingroups");
        this._tblsingroups = SimpleQuery.tblsingroups(this._dbObject);
        CGCPanel.LOUD(".. done tblsingroups");
    }

    private synchronized void init_tables() {
        if (this._tables != null) {
            return;
        }
        CGCPanel.LOUD("getOraTblsNames");
        this._tables = SimpleQuery.getOraTblsNames_gen(this._dbObject);
        CGCPanel.LOUD(".. done getOraTblsNames");
    }

    @Override
    public void idleInit() {
        CGCPanel.LOUD("idleInit");
        try {
            this.init_tblsingroups();
            this.checkIsCancelled();
            this.init_tables();
            CGCPanel.LOUD("CGCCGPanel");
            this._cgPanel.idleInit();
            CGCPanel.LOUD("CGCTablesPanel");
            this._tablesPanel.idleInit();
            CGCPanel.LOUD("CGCAgingPanel");
            this._agingPanel.idleInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CGCPanel.LOUD(".. done idleInit");
    }

    @Override
    public void doCancel() {
        CGCPanel.LOUD("user cancelled");
    }

    @Override
    public void doWork(Object object) {
        String string = (String)object;
        if (string.equals("init_tblsingroups()")) {
            this.init_tblsingroups();
        } else if (string.equals("init_tables()")) {
            this.init_tables();
        }
    }

    static {
        inhibitIdleInit = Boolean.getBoolean("timesten.inhibitIdleInit");
        registries = new Hashtable();
    }
}

