/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.PreparedQuery;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCColInfo;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableTreeNode;
import oracle.dbtools.raptor.utils.DBObject;

public final class CGCColInfoQuery
extends PreparedQuery {
    protected static String q = "select COLUMN_NAME, DATA_TYPE, DATA_LENGTH, DATA_PRECISION, DATA_SCALE, DEFAULT_LENGTH, DATA_DEFAULT, NULLABLE, CHAR_USED, CHAR_LENGTH, COLUMN_ID from sys.all_tab_columns  where owner = upper(:v1) and  table_name = upper(:v2) order by column_id ";
    CGCColInfo[] _cols;

    public CGCColInfo[] getCols() {
        return this._cols;
    }

    public CGCColInfoQuery(DBObject dBObject) {
        super(dBObject, q);
    }

    public void executeQuery(CGCTableTreeNode cGCTableTreeNode) {
        try {
            this._p3m.setup();
            this._stmt.setString(1, cGCTableTreeNode.getRealOwnerName());
            this._stmt.setString(2, cGCTableTreeNode.getRealTableName());
            DialogBase.LOUD("CGCColInfoQuery executeQuery");
            ResultSet resultSet = this._stmt.executeQuery();
            DialogBase.LOUD("CGCColInfoQuery fetching results");
            ArrayList<CGCColInfo> arrayList = new ArrayList<CGCColInfo>();
            while (resultSet.next()) {
                arrayList.add(new CGCColInfo(resultSet, this._dbObject));
            }
            resultSet.close();
            this._cols = arrayList.toArray(new CGCColInfo[arrayList.size()]);
            cGCTableTreeNode.setCols(this._cols);
            if (cGCTableTreeNode.isRootTable()) {
                CGCPanel cGCPanel = CGCPanel.theDialog;
                cGCPanel.fixMenuAgingTB();
                DialogBase.LOUD("CGCColInfoQuery fixMenuAgingTB done");
                cGCPanel.fixupAgingOptions();
                DialogBase.LOUD("CGCColInfoQuery fixupAgingOptions done");
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        try {
            this._p3m.restore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dump() {
        for (int i = 0; i < this._cols.length; ++i) {
            System.out.println("-- " + i + " --");
            this._cols[i].dump();
        }
    }
}

