/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.commands.TTInstanceInformation;
import oracle.dbtools.raptor.timesten.connection.X10ConnectionProperties;
import oracle.jdeveloper.db.adapter.AbstractConnectionCreator;

public class TimesTenConnectionCreator
extends AbstractConnectionCreator {
    public static final String SUBTYPE_THIRD_PARTY = "TimesTen";
    private static final Logger LOGGER = Logger.getLogger(TimesTenConnectionCreator.class.getPackage().getName());
    public static final String ORACLE_PWD_KEY = "sys2";
    public static final String ORACLE_NSN_KEY = "ORANETSERVICENAME";
    public static final String ORACLE_USER_KEY = "user";
    private static final String MAJOR1 = "major1";
    private static final String MAJOR2 = "major2";
    private static final int MIN_SUPPORTED_MAJOR1 = 12;
    private static final int MIN_SUPPORTED_MAJOR2 = 1;
    public static final String ACADIA_PROP = "isAcadia";
    public static boolean IS_TIMESTEN = false;

    protected void setCustomProperties(Properties properties, Properties properties2) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (properties2.getProperty(string) != null) continue;
            properties2.setProperty(string, properties.getProperty(string));
        }
    }

    protected boolean allowNullPassword() {
        return true;
    }

    public boolean shouldEncrypt(String string) {
        if (string.equals("oraclePassword")) {
            return true;
        }
        return super.shouldEncrypt(string);
    }

    public boolean shouldPromptForPassword(Properties properties) {
        boolean bl = TimesTenConnectionCreator.shouldPromptForPasswordImpl(properties);
        return bl;
    }

    public static boolean shouldPromptForPasswordImpl(Properties properties) {
        String string = properties.getProperty(ORACLE_USER_KEY);
        String string2 = properties.getProperty("password");
        TTInstanceInformation tTInstanceInformation = TTInstanceInformation.getInstance();
        boolean bl = tTInstanceInformation.accessControlEnabled();
        if (bl) {
            if (string == null) {
                return false;
            }
            if (string.length() == 0 || string.equals(TimesTenConnectionCreator.getCurrentUserName())) {
                return false;
            }
            if (string2 == null) {
                return true;
            }
        }
        return false;
    }

    private static String getCurrentUserName() {
        String string = "";
        try {
            string = System.getProperty("user.name");
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string;
    }

    public Connection getConnection(Properties properties) throws SQLException {
        X10ConnectionProperties x10ConnectionProperties = X10ConnectionProperties.getTheInstance();
        IS_TIMESTEN = true;
        String string = properties.getProperty("ConnName");
        String string2 = properties.getProperty("password");
        String string3 = properties.getProperty(ORACLE_USER_KEY);
        if (string2 != null) {
            x10ConnectionProperties.addProperty(string, "sys1", string2);
        }
        if ((string2 = properties.getProperty("oraclePassword")) != null) {
            x10ConnectionProperties.addProperty(string, ORACLE_PWD_KEY, string2);
            properties.setProperty("oraclePassword", string2);
            x10ConnectionProperties.addProperty(string, ORACLE_NSN_KEY, properties.getProperty(ORACLE_NSN_KEY));
            x10ConnectionProperties.addProperty(string, ORACLE_USER_KEY, string3);
        } else if (x10ConnectionProperties.getProperty(string, ORACLE_PWD_KEY) != null) {
            x10ConnectionProperties.removeProperty(string, ORACLE_PWD_KEY);
            x10ConnectionProperties.removeProperty(string, ORACLE_NSN_KEY);
            x10ConnectionProperties.removeProperty(string, ORACLE_USER_KEY);
        }
        String string4 = properties.getProperty("AUTOCOMMIT");
        if (string4 != null) {
            x10ConnectionProperties.addProperty(string, "AUTOCOMMIT", string4);
        }
        Connection connection = super.getConnection(properties);
        if (string3.isEmpty() && string2 != null) {
            x10ConnectionProperties.addProperty(string, ORACLE_USER_KEY, connection.getMetaData().getUserName());
        }
        boolean bl = false;
        Properties properties2 = TTInstanceInformation.getInstance().getInstanceProperties();
        if (properties2.containsKey(MAJOR1) && properties2.containsKey(MAJOR2)) {
            int n = Integer.parseInt((String)properties2.get(MAJOR1));
            int n2 = Integer.parseInt((String)properties2.get(MAJOR2));
            if (n >= 12 && n2 >= 1) {
                bl = true;
            }
        }
        x10ConnectionProperties.addProperty(string, ACADIA_PROP, String.valueOf(bl));
        return connection;
    }
}

