/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.advisor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.advisor.WorksheetIndexAdvisorPanel;
import oracle.dbtools.raptor.timesten.dialogs.connection.IndexAdvisorHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public class StatisticsPanel
extends JPanel {
    private static Logger LOGGER = Logger.getLogger(StatisticsPanel.class.getPackage().getName());
    private BasicEditorPane theStatisticsPane;
    private static final String EXPORT_SQL = "CALL ttOptStatsExport(?)";
    private final String[] theTableStatisticsRegEx = new String[]{IndexAdvisorHelper._tableStatisticsBounds[0], "<\\s+(CALL\\s+.*?;)\\s+>", IndexAdvisorHelper._tableStatisticsBounds[1]};
    private static final String theLineTerminator = TimesTenUtil.getLineSeparator();
    private String theTableName;

    public StatisticsPanel() {
        this((String)null);
    }

    public StatisticsPanel(String string) {
        this.theTableName = string;
        this.theStatisticsPane = WorksheetIndexAdvisorPanel.createEditorPane();
        JScrollPane jScrollPane = new JScrollPane((Component)this.theStatisticsPane, 22, 32);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(0, 10, 10, 10), 0, 0);
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file, String[] stringArray) {
        BufferedWriter bufferedWriter = null;
        try {
            String string;
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (String string2 : stringArray) {
                bufferedWriter.write(string2);
                bufferedWriter.write(theLineTerminator);
            }
            Document document = this.theStatisticsPane.getDocument();
            int n = 0;
            int n2 = 80;
            for (int i = document.getLength(); i > 0; i -= string.length()) {
                if (n2 > i) {
                    n2 = i;
                }
                string = document.getText(n, n2);
                bufferedWriter.write(string);
                n += string.length();
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Can't write to file", iOException);
        }
        catch (BadLocationException badLocationException) {
            LOGGER.log(Level.SEVERE, "Can't write to file", badLocationException);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.SEVERE, "Can't close file", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateStatistics(String string) {
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        boolean bl = false;
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(this.theTableStatisticsRegEx[1], 2);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Can't compile pattern", exception);
        }
        Document document = this.theStatisticsPane.getDocument();
        String string2 = TimesTenUtil.getLineSeparator();
        try {
            String string3;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!bl) {
                    if (!string3.matches(this.theTableStatisticsRegEx[0])) continue;
                    bl = true;
                    continue;
                }
                if (string3.matches(this.theTableStatisticsRegEx[2])) {
                    break;
                }
                Matcher matcher = pattern.matcher(string3);
                if (!matcher.matches()) continue;
                document.insertString(document.getLength(), matcher.group(1) + string2, null);
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Can't write to field", iOException);
        }
        catch (BadLocationException badLocationException) {
            LOGGER.log(Level.SEVERE, "Can't write to field", badLocationException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Can't close stream", iOException);
            }
            stringReader.close();
        }
    }

    public boolean hasStatistics() {
        return this.theStatisticsPane.getText().length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateStatistics(Connection connection) {
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall(EXPORT_SQL);
            callableStatement.setString(1, this.theTableName);
            ResultSet resultSet = callableStatement.executeQuery();
            Document document = this.theStatisticsPane.getDocument();
            while (resultSet.next()) {
                String string = TimesTenUtil.getLineSeparator();
                try {
                    document.insertString(document.getLength(), resultSet.getString(1) + string, null);
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.log(Level.SEVERE, "Can't write to field", badLocationException);
                }
            }
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.SEVERE, "Error while generating statistics", sQLException);
            MessageDialog.error((Component)this, (Object)TTSQLExceptionScrubber.getInstance().getMessage(Connections.getInstance().getConnectionName(connection), sQLException), (String)Messages.getString("TimesTen.common.error"), null);
        }
        finally {
            if (callableStatement != null) {
                try {
                    callableStatement.close();
                }
                catch (SQLException sQLException) {
                    LOGGER.log(Level.SEVERE, "Can't close statement", sQLException);
                }
            }
        }
    }
}

