/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.advisor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.advisor.IndexAdvisorProvider;
import oracle.dbtools.raptor.timesten.dialogs.connection.ConnectionCapturePanels;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;

public class IndexAdvisorConfiguration {
    private JEWTDialog theDialog;
    private final IndexAdvisorProvider theProvider;
    private int _captureLevel;
    private int _captureMode;
    public final String[] _captureModes = new String[]{Messages.getString("IndexAdvisor.executeSQL"), Messages.getString("IndexAdvisor.prepareSQL")};

    public IndexAdvisorConfiguration(IndexAdvisorProvider indexAdvisorProvider) {
        this.theProvider = indexAdvisorProvider;
    }

    public boolean launch() {
        int n = 3;
        this.theDialog = new JEWTDialog((Frame)Ide.getMainWindow(), Messages.getString("IndexAdvisor.indexAdvisorConfiguration"), n);
        this.theDialog.setOKButtonText(StringUtils.stripMnemonic((String)Messages.getString("IndexAdvisor.start")));
        this.theDialog.setOKButtonMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("IndexAdvisor.start")));
        this.theDialog.setCancelButtonText(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.cancelButton")));
        this.theDialog.setCancelButtonMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.cancelButton")));
        ConfigurationPanel configurationPanel = new ConfigurationPanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)configurationPanel, "f1_ott_index_advisor_conn_capture_worksheet_html");
        this.theDialog.setContent((Component)configurationPanel);
        this.theDialog.setPreferredSize(new Dimension(600, 400));
        boolean bl = this.theDialog.runDialog();
        if (bl) {
            this.theProvider.setCaptureLevel(this._captureLevel);
            this.theProvider.setCaptureMode(this._captureMode);
        }
        return bl;
    }

    private class ConfigurationPanel
    extends JPanel {
        private JComboBox _captureLevelMenu;
        private int _captureLevelIndex = 0;
        private JComboBox _captureModeMenu;
        private JCheckBox _olapOptimizerHints;
        private ConnectionCapturePanels.BIServerOptimizerHints _hintsUI;
        private JScrollPane _hintsUIPane;

        private ConfigurationPanel() {
            this.initGUI();
        }

        private void initGUI() {
            Insets insets = new Insets(10, 5, 0, 0);
            JPanel jPanel = new JPanel(new FlowLayout(0));
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel.add(jPanel2);
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "North");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            JLabel jLabel = new JLabel(Messages.getString("IndexAdvisor.captureMode"));
            this._captureModeMenu = new JComboBox<String>(IndexAdvisorConfiguration.this._captureModes);
            this._captureModeMenu.setSelectedIndex(1);
            jPanel2.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)this._captureModeMenu, gridBagConstraints);
            this._captureModeMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ConfigurationPanel.this._captureModeMenu.getSelectedItem().equals(IndexAdvisorConfiguration.this._captureModes[0])) {
                        IndexAdvisorConfiguration.this._captureMode = 0;
                    } else {
                        IndexAdvisorConfiguration.this._captureMode = 31;
                    }
                }
            });
            if (this._captureModeMenu.getSelectedItem().equals(IndexAdvisorConfiguration.this._captureModes[0])) {
                IndexAdvisorConfiguration.this._captureMode = 0;
            } else {
                IndexAdvisorConfiguration.this._captureMode = 31;
            }
            IndexAdvisorConfiguration.this._captureLevel = 0;
            IndexAdvisorConfiguration.this.theProvider.setCaptureLevel(IndexAdvisorConfiguration.this._captureLevel);
            IndexAdvisorConfiguration.this.theProvider.setCaptureMode(IndexAdvisorConfiguration.this._captureMode);
            IndexAdvisorConfiguration.this.theProvider.setTheIncludeOlapOptimizerHintsFlag(false);
            this._olapOptimizerHints = new JCheckBox(Messages.getString("IndexAdvisor.includeBIOptimizers"));
            this._olapOptimizerHints.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ConfigurationPanel.this._olapOptimizerHints.isSelected()) {
                        IndexAdvisorConfiguration.this.theProvider.setTheIncludeOlapOptimizerHintsFlag(true);
                        IndexAdvisorConfiguration.this.theProvider.setHints(ConfigurationPanel.this._hintsUI.getHints());
                        ConfigurationPanel.this._hintsUIPane.setVisible(true);
                        ConfigurationPanel.this.invalidate();
                        ConfigurationPanel.this.validate();
                    } else {
                        IndexAdvisorConfiguration.this.theProvider.setTheIncludeOlapOptimizerHintsFlag(false);
                        ConfigurationPanel.this._hintsUIPane.setVisible(false);
                        IndexAdvisorConfiguration.this.theProvider.setHints(ConfigurationPanel.this._hintsUI.getHints());
                        ConfigurationPanel.this.invalidate();
                        ConfigurationPanel.this.validate();
                    }
                }
            });
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            jPanel2.add((Component)this._olapOptimizerHints, gridBagConstraints);
            this._hintsUI = new ConnectionCapturePanels.BIServerOptimizerHints();
            Component component = this._hintsUI.getGUI();
            this._hintsUIPane = new JScrollPane(component);
            this._hintsUIPane.setVisible(false);
            this.add((Component)this._hintsUIPane, "Center");
        }
    }
}

