/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.advisor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.StyledDocument;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.dialogs.connection.IndexAdvisorHelper;
import oracle.dbtools.raptor.timesten.dialogs.connection.MessageIndeterminateProgressMonitor;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.dialogs.MessageDialog;

public class IndexAdvicePanel
extends JPanel
implements ActionListener {
    private static final String HOME_DIR;
    private static Logger LOGGER;
    private static String[] COLUMNS_NAME;
    private JTable theAdviceTable;
    private MyTableModel theAdviceTableModel;
    private final String theAdviceSql = "call ttIndexAdviceCaptureOutput(?)";
    private int theCaptureLevel;
    private MessageIndeterminateProgressMonitor _progressMonitor;
    private JTextPane _pane = new JTextPane();
    private JScrollPane _scrollPane = new JScrollPane(this._pane);
    private Connection theConnection;
    private static final String theLineTerminator;
    private JCheckBox _selectAll;
    private List<Object> _dataModel = new ArrayList<Object>(32);
    private JButton _createIndexes;
    private JButton _saveIndexes;
    private static final int SQL_RECOMENDATION_INDEX = 1;
    private static final int CREATE_INDEX = 3;
    private static final String YES;
    private static final String NO;
    private static boolean _isWorsheet;
    private final String PROGRESS = "progress";
    private JEWTDialog _dialog;
    private String _connectionName;

    public IndexAdvicePanel(String string, Connection connection, JEWTDialog jEWTDialog, boolean bl) {
        this(0, bl);
        this._connectionName = string;
        this.theConnection = connection;
        this._dialog = jEWTDialog;
    }

    private IndexAdvicePanel(int n, boolean bl) {
        this.theCaptureLevel = n;
        _isWorsheet = bl;
        this.initGUI();
    }

    public void generateAdvice() {
        this.theAdviceTableModel.populate(this.theConnection);
    }

    public void generateAdvice(String string) {
        this.theAdviceTableModel.populate(string);
    }

    public void setCaptureLevel(int n) {
        this.theCaptureLevel = n;
    }

    public boolean isRecommendationAvailable() {
        return this.theAdviceTableModel.getRowCount() != 0;
    }

    public void displayFeedback(Component component) {
        if (!this.isRecommendationAvailable()) {
            MessageDialog.information((Component)component, (Object)Messages.getString("IndexAdvisor.noIndexRecommendation"), (String)Messages.getString("IndexAdvisor.noIndexRecommendationTitle"), null);
        }
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this._selectAll = new JCheckBox(Messages.getString("IndexAdvisor.selectAll"));
        this._selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                if (jCheckBox.isSelected()) {
                    IndexAdvicePanel.this.theAdviceTableModel.setAllCheckBox(true);
                } else {
                    IndexAdvicePanel.this.theAdviceTableModel.setAllCheckBox(false);
                }
            }
        });
        jPanel.add(this._selectAll);
        this.add((Component)jPanel, "North");
        this.theAdviceTableModel = new MyTableModel();
        this.theAdviceTable = new JTable();
        this.theAdviceTable.setModel(this.theAdviceTableModel);
        this.theAdviceTable.setAutoResizeMode(4);
        this.theAdviceTable.setAutoCreateRowSorter(true);
        this.theAdviceTable.setFillsViewportHeight(true);
        TableColumnSizer.setColumnsWidthToFit(this.theAdviceTable, true, false);
        JScrollPane jScrollPane = new JScrollPane(this.theAdviceTable, 22, 32);
        this.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        this._createIndexes = new JButton(Messages.getString("IndexAdvisor.createSelectedIndices"));
        this._createIndexes.addActionListener(this);
        jPanel2.add(this._createIndexes);
        this._createIndexes.setEnabled(false);
        this._saveIndexes = new JButton(Messages.getString("IndexAdvisor.saveIndices"));
        this._saveIndexes.addActionListener(this);
        this._saveIndexes.setEnabled(false);
        if (!_isWorsheet) {
            jPanel2.add(this._saveIndexes);
        }
        this.add((Component)jPanel2, "South");
        this._progressMonitor = new MessageIndeterminateProgressMonitor(this, Messages.getString("IndexAdvisor.creatingSelectedIndexes"), Messages.getString("IndexAdvisor.creatingSelectedIndexes"), null);
        this._progressMonitor.addCancellationListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                IndexAdvicePanel.this._progressMonitor.close();
            }
        });
    }

    public void save(File file, String[] stringArray) {
        this.theAdviceTableModel.save(file, stringArray);
    }

    private void save() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setDialogTitle(Messages.getString("IndexAdvisor.saveIndices"));
        String string = Connections.getDisplayName((String)this._connectionName);
        File file = IndexAdvisorHelper.getFileName(string, HOME_DIR);
        jFileChooser.setSelectedFile(file);
        int n = jFileChooser.showSaveDialog((Component)this._dialog);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            this.save(file2);
        }
    }

    private void save(File file) {
        String string = Connections.getDisplayName((String)this._connectionName);
        String[] stringArray = IndexAdvisorHelper.getHeaders(this.theConnection, string);
        this.save(file, stringArray);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._saveIndexes) {
            this.save();
            return;
        }
        if (actionEvent.getSource() == this._createIndexes) {
            final CreateIndexTask createIndexTask = new CreateIndexTask();
            createIndexTask.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    StyledDocument styledDocument = IndexAdvicePanel.this._pane.getStyledDocument();
                    if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                        int n = (Integer)propertyChangeEvent.getNewValue();
                        String string = String.format(Messages.getString("IndexAdvisor.pertentageComplete") + "\n", n);
                        IndexAdvicePanel.this._progressMonitor.updateMessage(string);
                        IndexAdvicePanel.this._progressMonitor.updateTextArea(string);
                        if (IndexAdvicePanel.this._progressMonitor.isCanceled() || createIndexTask.isDone()) {
                            Toolkit.getDefaultToolkit().beep();
                            if (IndexAdvicePanel.this._progressMonitor.isCanceled()) {
                                createIndexTask.cancel(true);
                            } else {
                                IndexAdvicePanel.this._progressMonitor.finish();
                            }
                        }
                    }
                }
            });
            createIndexTask.execute();
            this._progressMonitor.start();
            return;
        }
    }

    private List<Object[]> getSelectedIndexes() {
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        for (Object object : this._dataModel) {
            Object[] objectArray = (Object[])object;
            if (!((Boolean)objectArray[0]).booleanValue() || !objectArray[3].toString().equals(NO)) continue;
            linkedList.add(objectArray);
        }
        return linkedList;
    }

    static {
        LOGGER = Logger.getLogger(IndexAdvicePanel.class.getPackage().getName());
        COLUMNS_NAME = new String[]{Messages.getString("IndexAdvisor.selector"), Messages.getString("IndexAdvisor.indexRecommendation"), Messages.getString("IndexAdvisor.affectedStatementCount"), Messages.getString("IndexAdvisor.created")};
        HOME_DIR = System.getProperty("user.home");
        theLineTerminator = TimesTenUtil.getLineSeparator();
        YES = Messages.getString("IndexAdvisor.indexCreatedYes");
        NO = Messages.getString("IndexAdvisor.indexCreatedNo");
    }

    private class MyTableModel
    extends AbstractTableModel {
        private final Class<?>[] _columnClasses = new Class[]{Boolean.class, String.class, Integer.class, String.class};
        private boolean selectingAll = false;
        private final String[] theIndexAdviceRegEx = new String[]{IndexAdvisorHelper._indexAdviceBounds[0], "<\\s+(\\d+),\\s+(.*?;)\\s+>", IndexAdvisorHelper._indexAdviceBounds[1]};

        private MyTableModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void save(File file, String[] stringArray) {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                for (String string : stringArray) {
                    bufferedWriter.write(string);
                    bufferedWriter.write(theLineTerminator);
                }
                Object[] objectArray = null;
                for (int i = 0; i < IndexAdvicePanel.this._dataModel.size(); ++i) {
                    objectArray = (Object[])IndexAdvicePanel.this._dataModel.get(i);
                    bufferedWriter.write((String)objectArray[1]);
                    bufferedWriter.write(theLineTerminator);
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Error while saving file", iOException);
                MessageDialog.error((Component)IndexAdvicePanel.this, (Object)Messages.getString("IndexAdvisor.errorSavingIndexes"), (String)Messages.getString("TimesTen.common.error"), null);
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.SEVERE, "Error while closing buffer", iOException);
                    }
                }
            }
        }

        private void populate(String string) {
            this.initModel(string);
            this.fireTableDataChanged();
        }

        private void populate(Connection connection) {
            this.initModel(connection);
            this.fireTableDataChanged();
        }

        private void setAllCheckBox(boolean bl) {
            Object[] objectArray = null;
            this.selectingAll = true;
            for (int i = 0; i < IndexAdvicePanel.this._dataModel.size(); ++i) {
                objectArray = (Object[])IndexAdvicePanel.this._dataModel.get(i);
                this.setValueAt(bl ? Boolean.TRUE : Boolean.FALSE, i, 0);
            }
            this.selectingAll = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initModel(String string) {
            StringReader stringReader = new StringReader(string);
            BufferedReader bufferedReader = new BufferedReader(stringReader);
            boolean bl = false;
            Pattern pattern = null;
            try {
                pattern = Pattern.compile(this.theIndexAdviceRegEx[1], 2);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Can't create pattern", exception);
            }
            Object[] objectArray = null;
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!bl) {
                        if (!string2.matches(this.theIndexAdviceRegEx[0])) continue;
                        bl = true;
                        continue;
                    }
                    if (string2.matches(this.theIndexAdviceRegEx[2])) break;
                    Matcher matcher = pattern.matcher(string2);
                    if (!matcher.matches()) continue;
                    objectArray = new Object[4];
                    for (int i = 1; i <= matcher.groupCount(); ++i) {
                    }
                    objectArray[0] = Boolean.FALSE;
                    objectArray[1] = matcher.group(2);
                    objectArray[2] = matcher.group(1);
                    objectArray[3] = NO;
                    IndexAdvicePanel.this._dataModel.add(objectArray);
                }
                if (IndexAdvicePanel.this._dataModel.size() > 0) {
                    IndexAdvicePanel.this._saveIndexes.setEnabled(true);
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Error while parsing text", iOException);
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.SEVERE, "Error while closing stream", iOException);
                }
                stringReader.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initModel(Connection connection) {
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement("call ttIndexAdviceCaptureOutput(?)");
                preparedStatement.setInt(1, IndexAdvicePanel.this.theCaptureLevel);
                ResultSet resultSet = preparedStatement.executeQuery();
                Object[] objectArray = null;
                while (resultSet.next()) {
                    objectArray = new Object[]{Boolean.FALSE, resultSet.getString(2), resultSet.getInt(1), NO};
                    IndexAdvicePanel.this._dataModel.add(objectArray);
                }
                if (IndexAdvicePanel.this._dataModel.size() > 0) {
                    IndexAdvicePanel.this._saveIndexes.setEnabled(true);
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
            }
        }

        @Override
        public int getColumnCount() {
            return COLUMNS_NAME.length;
        }

        @Override
        public int getRowCount() {
            return IndexAdvicePanel.this._dataModel.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object[] objectArray = (Object[])IndexAdvicePanel.this._dataModel.get(n);
            return objectArray[n2];
        }

        public boolean areAllRowsSelected() {
            for (Object e : IndexAdvicePanel.this._dataModel) {
                Object[] objectArray = (Object[])e;
                if (((Boolean)objectArray[0]).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public boolean isAtLeastOneSelected() {
            for (Object e : IndexAdvicePanel.this._dataModel) {
                Object[] objectArray = (Object[])e;
                if (!((Boolean)objectArray[0]).booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this._columnClasses[n];
        }

        @Override
        public String getColumnName(int n) {
            return COLUMNS_NAME[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Object[] objectArray = (Object[])IndexAdvicePanel.this._dataModel.get(n);
            objectArray[n2] = object;
            this.fireTableCellUpdated(n, n2);
            if (!((Boolean)object).booleanValue()) {
                IndexAdvicePanel.this._selectAll.setSelected(false);
                if (this.isAtLeastOneSelected()) {
                    IndexAdvicePanel.this._createIndexes.setEnabled(true);
                } else {
                    IndexAdvicePanel.this._createIndexes.setEnabled(false);
                }
            } else {
                IndexAdvicePanel.this._createIndexes.setEnabled(true);
                if (!this.selectingAll && this.areAllRowsSelected()) {
                    IndexAdvicePanel.this._selectAll.setSelected(true);
                }
            }
        }
    }

    private class CreateIndexTask
    extends SwingWorker<Boolean, Void> {
        private CreateIndexTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Boolean doInBackground() throws Exception {
            Statement statement = null;
            try {
                statement = IndexAdvicePanel.this.theConnection.createStatement();
                List list = IndexAdvicePanel.this.getSelectedIndexes();
                int n = 0;
                for (Object[] objectArray : list) {
                    if (this.isCancelled()) {
                        break;
                    }
                    try {
                        statement.execute(objectArray[1].toString());
                        objectArray[3] = YES;
                    }
                    catch (SQLException sQLException) {
                        LOGGER.log(Level.SEVERE, "Error while creating index", sQLException);
                    }
                    this.setProgress((n + 1) * 100 / list.size());
                    ++n;
                }
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.SEVERE, "Error while creating indexes", sQLException);
                MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(Connections.getInstance().getConnectionName(IndexAdvicePanel.this.theConnection), sQLException), (String)Messages.getString("TimesTen.common.error"), null);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.log(Level.SEVERE, "Error while closing statement", sQLException);
                    }
                }
            }
            return Boolean.TRUE;
        }

        @Override
        protected void done() {
            super.done();
            IndexAdvicePanel.this.theAdviceTableModel.fireTableDataChanged();
            IndexAdvicePanel.this._progressMonitor.finish();
        }
    }
}

