/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.PassThrough3Manager;
import oracle.dbtools.raptor.timesten.SimpleQuery;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.utils.DBObject;

public class PreparedQuery {
    protected PreparedStatement _stmt = null;
    protected DBObject _dbObject;
    protected PassThrough3Manager _p3m;

    public PreparedQuery(DBObject dBObject, String string) {
        this._dbObject = dBObject;
        this._p3m = new PassThrough3Manager(dBObject);
        Connection connection = dBObject.getConnection();
        if (!CGCPanel.inhibitIdleInit) {
            connection = SimpleQuery.getOracleConnection(dBObject);
        }
        try {
            this._p3m.setup();
            this._stmt = connection.prepareStatement(string);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        try {
            this._p3m.restore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void dump(ResultSet resultSet) throws SQLException {
        int n = resultSet.getMetaData().getColumnCount();
        System.out.println(n + " columns");
        for (int i = 1; i <= n; ++i) {
            Object object = resultSet.getObject(i);
            System.out.println(i + ": " + object.toString());
        }
        System.out.println("---------------------------------");
    }
}

