/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetSQLPlusCompatability
extends CommandListener
implements IShowCommand {
    String[] aliases = new String[]{"SQLPLUSCOMPAT", "SQLPLUSCOMPATIBILITY", "sqlpluscompati", "sqlpluscompatib", "sqlpluscompatibi", "sqlpluscompatibil", "sqlpluscompatibili", "sqlpluscompatibilit"};
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    @Override
    public String[] getShowAliases() {
        return this.aliases;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getProperty("script.runner.set_sqlpluscompat") != null) {
            String x = (String)ctx.getProperty("script.runner.set_sqlpluscompat");
            int numberofDots = x.split("\\.").length - 1;
            if (numberofDots == 1) {
                x = x + ".0";
            }
            if (numberofDots == 0 || numberofDots > 2) {
                ctx.write(Messages.getString("SetSQLPlusCompatability.1") + LINE_SEPARATOR);
            } else {
                ctx.write(MessageFormat.format(Messages.getString("SetSQLPlusCompatability.2") + LINE_SEPARATOR, x));
            }
        } else {
            String[] ver = VersionTracker.getDbVersion(DefaultConnectionIdentifier.createIdentifier(conn)).toString().split("\\.");
            ctx.write(MessageFormat.format("sqlpluscompatibility {0}" + LINE_SEPARATOR, ver[0] + "." + ver[1] + "." + ver[2]));
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String sql = cmd.getSql();
        String[] tokens = sql.split("\\s+");
        if (tokens.length != 3) {
            ctx.write(Messages.getString("SetSQLPlusCompatability.6"));
            return true;
        }
        String token = tokens[2];
        if (token.startsWith("\"") && !token.endsWith("\"")) {
            ctx.write(MessageFormat.format(Messages.getString("SetSQLPlusCompatability.9"), token, "\""));
            return true;
        }
        if (token.startsWith("'") && !token.endsWith("'")) {
            ctx.write(MessageFormat.format(Messages.getString("SetSQLPlusCompatability.12"), token, "'"));
            return true;
        }
        if (!token.startsWith("\"") && token.endsWith("\"") || !token.startsWith("'") && token.endsWith("'")) {
            ctx.write(Messages.getString("SetSQLPlusCompatability.17") + LINE_SEPARATOR);
            return true;
        }
        String input = token;
        if (token.length() > 2 && (token.startsWith("\"") && token.endsWith("\"") || token.startsWith("'") && token.endsWith("'"))) {
            input = input.substring(1, input.length() - 1);
        }
        int bits = input.split("\\.").length;
        String regex = "^(\\d+\\.)?(\\d+\\.)?(\\*|\\d+)$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        if (bits > 1 && matcher.matches()) {
            if (this.checkVersion(input, conn)) {
                ctx.putProperty("script.runner.set_sqlpluscompat", input);
            } else {
                ctx.write(Messages.getString("SetSQLPlusCompatability.0"));
            }
        } else {
            ctx.write(Messages.getString("SetSQLPlusCompatability.21") + LINE_SEPARATOR);
        }
        return true;
    }

    private boolean checkVersion(String input, Connection conn) {
        String[] bits = input.split("\\.");
        int major = 0;
        int minor = 0;
        int patch = 0;
        if (bits.length >= 2) {
            major = Integer.parseInt(bits[0]);
            minor = Integer.parseInt(bits[1]);
            if (bits.length > 2) {
                patch = Integer.parseInt(bits[2]);
            }
            try {
                Version lowest = new Version("7.3.4");
                Version v = new Version("12.2.0");
                if (conn != null) {
                    int dbMajor = conn.getMetaData().getDatabaseMajorVersion();
                    int dbMinor = conn.getMetaData().getDatabaseMinorVersion();
                    v = new Version(dbMajor + "." + dbMinor + ".0");
                }
                Version v2 = new Version(major + "." + minor + ".0");
                if (patch > 0) {
                    v2 = new Version(major + "." + minor + "." + patch);
                }
                return v2.compareTo(v) <= 0 && v2.compareTo(lowest) >= 0;
            }
            catch (SQLException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

