/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.cmdline;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.console.UserInterruptException;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import oracle.dbtools.app.SqlclCompleter;
import oracle.dbtools.common.utils.StringUtils;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.parser.plsql.ParsedSql;
import oracle.dbtools.raptor.console.ConsoleListener;
import oracle.dbtools.raptor.console.FileNameCompleter;
import oracle.dbtools.raptor.console.MultiLineHistory;
import oracle.dbtools.raptor.console.SQLPlusConsoleReader;
import oracle.dbtools.raptor.console.clone.DbtoolsNonBlockingInputStream;
import oracle.dbtools.raptor.console.clone.IAcceptTypeHandler;
import oracle.dbtools.raptor.format.ANSIConsoleFormatter;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.SQLPlusProviderForSQLPATH;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.SqlParserProvider;
import oracle.dbtools.raptor.newscriptrunner.commands.ApexCmd;
import oracle.dbtools.raptor.newscriptrunner.commands.Info;
import oracle.dbtools.raptor.newscriptrunner.commands.SetAppinfo;
import oracle.dbtools.raptor.newscriptrunner.commands.SetExitCommit;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Aliases;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowLogin;
import oracle.dbtools.raptor.scriptrunner.cmdline.SQLCliHelper;
import oracle.dbtools.raptor.scriptrunner.cmdline.SQLCliOptions;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.Buffer;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.EditCommand;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.Messages;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.SetColorCommand;
import oracle.dbtools.raptor.scriptrunner.commands.HelpCmd;
import oracle.dbtools.raptor.scriptrunner.commands.HistoryCommand;
import oracle.dbtools.raptor.scriptrunner.commands.InfoCmd;
import oracle.dbtools.raptor.scriptrunner.commands.NLSLANGListener;
import oracle.dbtools.raptor.scriptrunner.commands.OraDebug;
import oracle.dbtools.raptor.scriptrunner.commands.PromptCmd;
import oracle.dbtools.raptor.scriptrunner.commands.RepeatSQLBufferCmd;
import oracle.dbtools.raptor.scriptrunner.commands.SODACmd;
import oracle.dbtools.raptor.scriptrunner.commands.ScriptCommand;
import oracle.dbtools.raptor.scriptrunner.commands.Set121LongIdentifier;
import oracle.dbtools.raptor.scriptrunner.commands.SetClassicMode;
import oracle.dbtools.raptor.scriptrunner.commands.SetClearScreen;
import oracle.dbtools.raptor.scriptrunner.commands.SetEditFile;
import oracle.dbtools.raptor.scriptrunner.commands.SetEmbedded;
import oracle.dbtools.raptor.scriptrunner.commands.SetEncoding;
import oracle.dbtools.raptor.scriptrunner.commands.SetHistory;
import oracle.dbtools.raptor.scriptrunner.commands.SetSQLPlusCompatability;
import oracle.dbtools.raptor.scriptrunner.commands.SetSQLPrompt;
import oracle.dbtools.raptor.scriptrunner.commands.SetTime;
import oracle.dbtools.raptor.scriptrunner.commands.ShowVersion;
import oracle.dbtools.raptor.scriptrunner.commands.Shutdown;
import oracle.dbtools.raptor.scriptrunner.commands.SshTunnelCommand;
import oracle.dbtools.raptor.scriptrunner.commands.Startup;
import oracle.dbtools.raptor.scriptrunner.commands.editor.AppendCommand;
import oracle.dbtools.raptor.scriptrunner.commands.editor.ChangeCommand;
import oracle.dbtools.raptor.scriptrunner.commands.editor.DelCommand;
import oracle.dbtools.raptor.scriptrunner.commands.editor.GetCommand;
import oracle.dbtools.raptor.scriptrunner.commands.editor.InputCommand;
import oracle.dbtools.raptor.scriptrunner.commands.editor.ListCommand;
import oracle.dbtools.raptor.scriptrunner.commands.editor.Pwd;
import oracle.dbtools.raptor.scriptrunner.commands.editor.SaveCommand;
import oracle.dbtools.raptor.scriptrunner.commands.editor.SetSuffix;
import oracle.dbtools.raptor.scriptrunner.commands.editor.StoreCommand;
import oracle.dbtools.raptor.scriptrunner.commands.rest.RESTCommand;
import oracle.dbtools.raptor.utils.AnsiColorListPrinter;
import oracle.dbtools.raptor.utils.BasicExceptionHandler;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.dbtools.versions.CheckForUpdates;
import oracle.dbtools.versions.SQLclVersion;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class SqlCli
implements ConsoleListener {
    public static String productName = "SQLcl";
    private Connection _conn;
    private ScriptExecutor _runner;
    private ScriptRunnerContext _ctx;
    private SQLPlusConsoleReader reader;
    private Buffer _buffer;
    private boolean processed = false;
    boolean RUNNING = false;
    private static boolean logging = false;
    private static boolean _isCmdLine = false;
    private static boolean isPromptBold = false;
    private ExitThread _exitThread = null;
    private String prompt = "SQL>";

    public static boolean isCmdLine() {
        return _isCmdLine;
    }

    public SQLPlusConsoleReader getReader() {
        return this.reader;
    }

    protected ScriptRunnerContext getScriptRunnerContext() {
        return this._ctx;
    }

    public SqlCli() throws Exception {
        ExceptionHandler.setHandler(new BasicExceptionHandler());
        FormatRegistry.setLineTerminator(System.getProperty("line.separator"));
        SQLCliHelper.setDefaultScriptRunnerProperies();
        ResultSetFormatter.setMaxLines(Integer.MAX_VALUE);
        CommandRegistry.addListener(SetEditFile.class, SQLCommand.StmtSubType.G_S_SET_EDITFILE);
        CommandRegistry.addListener(HistoryCommand.class, SQLCommand.StmtSubType.G_S_HISTORY);
        CommandRegistry.addListener(GetCommand.class, SQLCommand.StmtSubType.G_S_GET);
        CommandRegistry.addListener(SaveCommand.class, SQLCommand.StmtSubType.G_S_SAVE);
        CommandRegistry.addListener(StoreCommand.class, SQLCommand.StmtSubType.G_S_STORE);
        CommandRegistry.addListener(ListCommand.class, SQLCommand.StmtSubType.G_S_LIST);
        CommandRegistry.addListener(AppendCommand.class, SQLCommand.StmtSubType.G_S_APPEND);
        CommandRegistry.addListener(ChangeCommand.class, SQLCommand.StmtSubType.G_S_CHANGE);
        CommandRegistry.addListener(DelCommand.class, SQLCommand.StmtSubType.G_S_DEL_PLUS);
        CommandRegistry.addListener(SetEmbedded.class, SQLCommand.StmtSubType.G_S_SET_EMBEDDED);
        CommandRegistry.addListener(SetSuffix.class, SQLCommand.StmtSubType.G_S_SET_SUFFIX);
        CommandRegistry.addListener(SetTime.class, SQLCommand.StmtSubType.G_S_SET_TIME);
        CommandRegistry.addListener(SetClearScreen.class, SQLCommand.StmtSubType.G_S_SET_CLEARSCREEN);
        CommandRegistry.addListener(SetEncoding.class, SQLCommand.StmtSubType.G_S_SET_ENCODING);
        CommandRegistry.addListener(EditCommand.class, SQLCommand.StmtSubType.G_S_EDIT);
        CommandRegistry.addListener(InputCommand.class, SQLCommand.StmtSubType.G_S_INPUT);
        CommandRegistry.addListener(SshTunnelCommand.class, SQLCommand.StmtSubType.G_S_SSHTUNNEL);
        CommandRegistry.addListener(Startup.class, SQLCommand.StmtSubType.G_S_STARTUP);
        CommandRegistry.addListener(Shutdown.class, SQLCommand.StmtSubType.G_S_SHUTDOWN);
        CommandRegistry.addListener(ScriptCommand.class, SQLCommand.StmtSubType.G_S_SCRIPT);
        CommandRegistry.addListener(SetColorCommand.class, SQLCommand.StmtSubType.G_S_SET_UNKNOWN);
        CommandRegistry.addListener(SetSQLPlusCompatability.class, SQLCommand.StmtSubType.G_S_SET_SQLCOMPATABILITY);
        CommandRegistry.addListener(SetHistory.class, SQLCommand.StmtSubType.G_S_SET_HISTORY);
        CommandRegistry.addListener(OraDebug.class, SQLCommand.StmtSubType.G_S_ORADEBUG);
        CommandRegistry.addForAllStmtsListener(SetSQLPrompt.class);
        CommandRegistry.addForAllStmtsListener(RepeatSQLBufferCmd.class);
        CommandRegistry.addForAllStmtsListener(RESTCommand.class);
        CommandRegistry.addForAllStmtsListener(Pwd.class);
        CommandRegistry.addListener(SetExitCommit.class, SQLCommand.StmtSubType.G_S_SET_EXITCOMMIT);
        CommandRegistry.addListener(SetClassicMode.class, SQLCommand.StmtSubType.G_S_SET_SQLPLUS_CLASSIC_MODE);
        CommandRegistry.addListener(Set121LongIdentifier.class, SQLCommand.StmtSubType.G_S_SET_IGNORE_SETTING_MODE);
        CommandRegistry.addListener(ShowVersion.class, SQLCommand.StmtSubType.G_S_VERSION);
        CommandRegistry.addForAllStmtsListener(NLSLANGListener.class);
        this.setupJLineInCommon();
        SQLPLUS.setProductName(productName);
        this.startConsole();
    }

    private void setupJLineInCommon() {
        CommandRegistry.addListener(HelpCmd.class, SQLCommand.StmtSubType.G_S_HELP);
        CommandRegistry.removeListener(SQLCommand.StmtSubType.G_S_PROMPT);
        CommandRegistry.addListener(PromptCmd.class, SQLCommand.StmtSubType.G_S_PROMPT);
        CommandRegistry.addForAllStmtsListener(InfoCmd.class);
        CommandRegistry.addForAllStmtsListener(SODACmd.class);
        ANSIConsoleFormatter.setListPrinter(new AnsiColorListPrinter());
        ApexCmd.setListPrinter(new AnsiColorListPrinter());
        Info.setListPrinter(new AnsiColorListPrinter());
    }

    private void startConsole() throws IOException {
        this.reader = new SQLPlusConsoleReader();
        this.reader.setBellEnabled(false);
        this.reader.setAcceptHandler(new IAcceptTypeHandler(){

            @Override
            public String getSQLType(String input) {
                if (input.length() > 0) {
                    ParsedSql.Language type = ParsedSql.partialRecognize(input);
                    return type.toString();
                }
                return "unknown";
            }
        });
        this._buffer = new Buffer();
        this.reader.setMultilineBuffer(this._buffer);
        this.reader.setHistory(MultiLineHistory.getInstance());
        MultiLineHistory.getInstance().setTermWidth(this.reader.getWidth());
        MultiLineHistory.getInstance().setBaseBlackList(SQLCliOptions.getBaseHistoryBlacklist());
        MultiLineHistory.getInstance().setBlackList(SQLCliOptions.getBaseHistoryBlacklist());
        ScriptExecutor.setHistory(MultiLineHistory.getInstance());
        this.reader.setExpandEvents(false);
    }

    public ScriptRunnerContext processArgs(String[] args) throws Exception {
        ScriptRunnerContext context = SQLCliHelper.getCliScriptRunnerContext(this.reader);
        this.setLoggingState(context);
        SQLCliOptions.setArgs(args);
        SQLCliOptions.processOptions(args);
        context = SQLCliOptions.populateContextWithOptions(context);
        context.setSQLPlusBuffer(this._buffer);
        context.putProperty("sqlcl.clear.screen", "top");
        context.setOutputStreamWrapper(new BufferedOutputStream(System.out));
        if (System.getenv("SQLPLUS_CLASSIC") != null) {
            context.putProperty("sqlplus.classic.mode", Boolean.TRUE);
        }
        return context;
    }

    private void banner() {
        String version = SQLclVersion.getSQLclShortVersion();
        String banner = Messages.getString("SqlCli.18");
        banner = MessageFormat.format(banner, productName, version, SQLclVersion.getSQLclState(), SQLCliHelper.getBannerTime());
        this.getScriptRunnerContext().write("\n" + banner + "\n");
        banner = Messages.getString("SqlCli.19");
        banner = MessageFormat.format(banner, SQLCliHelper.getBannerYear());
        this.getScriptRunnerContext().write("\n" + banner + "\n");
        try {
            this.getScriptRunnerContext().getOutputStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Boolean process(String line) {
        try {
            if (this.reader.justDidHistory()) {
                this.reader.println();
            }
            this.reader.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        line = line.replaceAll("\\xA0+", "");
        if (this._runner == null) {
            this._runner = new ScriptExecutor(this._ctx.getCurrentConnection());
            this._runner.setScriptRunnerContext(this._ctx);
        }
        if (this._ctx.getCurrentConnection() != null) {
            this._runner.setConn(this._ctx.getCurrentConnection());
        }
        this._buffer.stopEditing();
        this._runner.setInterrupted(false);
        this._runner.setStmt(line);
        Iterator<ISQLCommand> parser = SqlParserProvider.getScriptParserIterator(this.getScriptRunnerContext(), new StringReader(line));
        while (parser.hasNext()) {
            ISQLCommand cmd = parser.next();
            if (cmd.getStmtType() == SQLCommand.StmtType.G_C_SQLPLUS && cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_ACCEPT) {
                SqlCli sqlCli = this;
                sqlCli._exitThread.stopListening();
            } else {
                this._exitThread.listen();
            }
            if (cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_PLSQL) || cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQL)) {
                if (!((cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_RUN) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SLASH) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_DEL_PLUS) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CHANGE) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SAVE) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_STORE) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_GET) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_LIST) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_APPEND) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_EDIT) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_FORMAT) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_INSERT)) && !cmd.getSql().toLowerCase().startsWith("repeat"))) {
                    this.reader.getMultilineBuffer().setBufferSafe(this.reader.getMultilineBuffer().getBufferList());
                }
            } else if (cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQLPLUS)) {
                // empty if block
            }
            this.reader.getMultilineBuffer().clear();
            this.reader.maxBufferDrawn = 0;
        }
        this._runner.run();
        SqlCli sqlCli = this;
        sqlCli._exitThread.stopListening();
        return true;
    }

    private void processLine(String line) {
        this.reader.resetEditor();
        this.process(line);
        this.prompt = this.getPrompt(isPromptBold);
        this.reader.setBasePrompt(this.prompt);
        this.reader.resetRedraw(line);
    }

    public void usage() {
        this.getScriptRunnerContext().write(MessageFormat.format(Messages.getString("SqlCli.3"), "-verbose"));
        try {
            this.getScriptRunnerContext().getOutputStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            SqlCli.addShutdownHooks();
            _isCmdLine = true;
            AnsiConsole.systemInstall();
            if (System.getenv("STARTUP_SQLCL") != null && !System.getenv("STARTUP_SQLCL").equals("")) {
                System.setProperty("user.dir", System.getenv("STARTUP_SQLCL"));
            }
            SqlCli cli = new SqlCli();
            cli.setScriptRunnerContext(cli.processArgs(args));
            if (SQLCliOptions.isBadOption()) {
                if (!cli.getScriptRunnerContext().isSQLPlusClassic()) {
                    cli.getScriptRunnerContext().write(SQLCliOptions.getBadOption() + "\n");
                }
                cli.getScriptRunnerContext().setExited(true);
                cli.getScriptRunnerContext().putProperty("script.runner.exit_int", 1);
                cli.handleHelp();
                SqlCli.handleExit(cli);
            }
            cli.setLoggingState(cli.getScriptRunnerContext());
            if (SQLCliOptions.isOptionUsed("-version")) {
                cli.handleVersion();
            } else if (SQLCliOptions.isOptionUsed("-help")) {
                cli.handleVersion();
                cli.handleHelp();
            } else {
                if (!SQLCliOptions.isOptionUsed("-silent")) {
                    try {
                        cli.handleBanner();
                        cli.handleUpdates();
                        cli.getScriptRunnerContext().getOutputStream().flush();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                cli.getScriptRunnerContext().setSQLPlusConsoleReader(cli.getReader());
                if (!cli.getScriptRunnerContext().isSQLPlusClassic()) {
                    SqlCli.setTerminalConstraints(cli);
                }
                SQLPLUS.setSqlpathProvider(new SQLPlusProviderForSQLPATH());
                cli.getScriptRunnerContext().putProperty("script.runner.oraclehomemainthread", TNSHelper.getOracleHome());
                cli.getScriptRunnerContext().putProperty("script.runner.sqlpathprovidermainthread", SQLPLUS.getSqlpathProvider().getSQLPATHsetting());
                cli.handleLoginSql(cli.getScriptRunnerContext());
                cli.handleAtFiles(cli.getScriptRunnerContext());
                cli.handleExitInAtFiles();
                try {
                    cli.getScriptRunnerContext().getOutputStream().flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                cli.startSQLPlus();
            }
            SqlCli.handleCloseDown(cli);
            SqlCli.handleExit(cli);
        }
        catch (FileNotFoundException fnfe) {
            SqlCli.log(Level.SEVERE, fnfe.getMessage());
        }
        catch (Exception e) {
            SqlCli.log(Level.SEVERE, e.getMessage());
            e.printStackTrace();
            ExceptionHandler.handleException(e);
        }
    }

    private void handleUpdates() {
        if (SQLCliOptions.isOptionUsed("-noupdates")) {
            return;
        }
        String banner = CheckForUpdates.getBanner();
        if (banner != null && banner.trim().length() > 0) {
            this.getScriptRunnerContext().write(banner);
        }
        Thread t = new Thread("Checkforupdates"){

            @Override
            public void run() {
                StringBuilder updateString = new StringBuilder();
                CheckForUpdates cfu = CheckForUpdates.check();
                if (cfu.isLoaded()) {
                    if (SQLclVersion.getSQLclOracleVersion().compareTo(cfu.getLatestOracleVersion()) < 0 && cfu.getBroadcastMessage() != null && cfu.getBroadcastMessage().length() > 0 && cfu.isMessageShowable(new Date())) {
                        updateString.append("\t" + cfu.getBroadcastMessage() + "\n\n");
                    }
                    if (SQLclVersion.getSQLclOracleVersion().compareTo(cfu.getLatestOracleVersion()) < 0) {
                        String version = MessageFormat.format(Messages.getString("SqlCli.13"), cfu.getLatestVersion());
                        updateString.append("\n" + version + "\n\n");
                    }
                    if (updateString.length() > 0) {
                        cfu.save(updateString.toString());
                    } else {
                        cfu.save("");
                    }
                } else {
                    cfu.save("");
                }
            }
        };
        t.start();
    }

    private static void setTerminalConstraints(SqlCli cli) {
        if (!System.getProperty("os.name").toLowerCase().contains("win")) {
            String val;
            byte[] buf;
            Process p2;
            try {
                p2 = Runtime.getRuntime().exec(new String[]{"/bin/bash", "-c", "tput cols 2> /dev/tty"});
                buf = new byte[200];
                p2.getInputStream().read(buf);
                val = new String(buf).trim();
                int cols = Integer.parseInt(val);
                cli.getScriptRunnerContext();
                cli.getScriptRunnerContext().putProperty("script.runner.setlinesize", cols);
            }
            catch (Exception p2) {
                // empty catch block
            }
            try {
                p2 = Runtime.getRuntime().exec(new String[]{"/bin/bash", "-c", "tput lines 2> /dev/tty"});
                buf = new byte[200];
                p2.getInputStream().read(buf);
                val = new String(buf).trim();
                int lines = Integer.parseInt(val);
                cli.getScriptRunnerContext();
                cli.getScriptRunnerContext().putProperty("script.runner.setpagesize", lines);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void addShutdownHooks() {
        Runtime.getRuntime().addShutdownHook(new Thread("cleanup"){

            @Override
            public void run() {
                MultiLineHistory.getInstance().save();
                Aliases.getInstance().save();
            }
        });
    }

    private void handleHelp() {
        try {
            String line;
            InputStream is = this.getClass().getResourceAsStream("/oracle/dbtools/raptor/scriptrunner/cmdline/help/help1.txt");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
            while ((line = bufferedReader.readLine()) != null) {
                this.getScriptRunnerContext().write(line + "\n");
            }
            this.getScriptRunnerContext().getOutputStream().flush();
            bufferedReader.close();
        }
        catch (IOException e) {
            SqlCli.log(Level.SEVERE, e.getMessage());
        }
    }

    private static void log(Level level, String message) {
        if (logging) {
            Logger l = Logger.getLogger("oracle.dbtools");
            l.setLevel(Level.parse("SEVERE"));
            l.log(level, message);
        }
    }

    private void handleVersion() {
        String banner = Messages.getString("SqlCli.Version");
        banner = MessageFormat.format(banner, productName, SQLclVersion.getSQLclVersion(), SQLclVersion.getSQLclState());
        this.getScriptRunnerContext().write(banner + "\n");
        try {
            this.getScriptRunnerContext().getOutputStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void handleBanner() {
        if (!(SQLCliOptions.isOptionUsed("-silent") ^ SQLCliOptions.isOptionUsed("-x"))) {
            this.banner();
        }
    }

    private void setLoggingState(ScriptRunnerContext context) {
        Boolean optlCheck = (Boolean)context.getProperty("SqlCli.optlflag");
        if (optlCheck == null || optlCheck.equals(Boolean.FALSE)) {
            logging = true;
            Enumeration<String> list = LogManager.getLogManager().getLoggerNames();
            while (list.hasMoreElements()) {
                Logger.getLogger(list.nextElement()).setLevel(Level.SEVERE);
            }
        } else {
            logging = false;
            Enumeration<String> list = LogManager.getLogManager().getLoggerNames();
            while (list.hasMoreElements()) {
                Logger.getLogger(list.nextElement()).setLevel(Level.INFO);
            }
        }
    }

    private void handleExitInAtFiles() {
        if (this.getScriptRunnerContext().getProperty("script.runner.exit_int") != null) {
            SqlCli.handleCloseDown(this);
            SqlCli.handleExit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAtFiles(ScriptRunnerContext context) throws Exception {
        boolean runFile = true;
        if (SQLCliOptions.getFileName() != null && SQLCliOptions.getFileName().length() > 0) {
            String inputFile;
            ArrayList<String> parserArgs = SQLCliOptions.getFileArguments();
            if (parserArgs != null) {
                for (int argCount = 0; argCount < parserArgs.size(); ++argCount) {
                    Map<String, String> m = context.getMap();
                    String preArg = parserArgs.get(argCount);
                    if ((preArg.startsWith("'") && preArg.endsWith("'") || preArg.startsWith("\"") && preArg.endsWith("\"")) && preArg.length() > 1) {
                        preArg = preArg.substring(1, preArg.length() - 1);
                    }
                    m.put(Integer.toString(argCount + 1), preArg);
                }
            }
            String toRun = null;
            String pathGiven = null;
            if (SQLPLUS.getSqlpathProvider() != null) {
                pathGiven = SQLPLUS.getSqlpathProvider().getSQLPATHsetting();
            }
            if (!(SQLCliOptions.startsWithHttpOrFtp(inputFile = SQLCliOptions.getFileName()) && SQLCliOptions.haveIBytes(inputFile) || SQLCliOptions.haveIBytesRaw(inputFile))) {
                boolean prependDirectory = this.getPrependDirectory(inputFile);
                toRun = this.getTheCompleteFilename(inputFile, pathGiven);
                if (pathGiven != null && prependDirectory) {
                    for (String possible : pathGiven.split(File.pathSeparator)) {
                        if (possible == null) continue;
                        possible = possible.endsWith("/") || possible.endsWith("\\") ? possible + inputFile : possible + File.separator + inputFile;
                        possible = System.getProperty("os.name").startsWith("Windows") ? possible.replace("/", "\\") : possible.replace("\\", "/");
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, MessageFormat.format(Messages.getString("SqlCli.FILECHECK"), possible));
                        if (!new File(possible).exists() || !new File(possible).canRead()) continue;
                        toRun = possible;
                        break;
                    }
                }
            }
            if (toRun == null) {
                toRun = SQLCliOptions.getFileName();
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, MessageFormat.format(Messages.getString("SqlCli.FILECHECK"), toRun));
            }
            if (SQLCliOptions.startsWithHttpOrFtp(inputFile) && SQLCliOptions.haveIBytes(inputFile) || SQLCliOptions.haveIBytesRaw(inputFile)) {
                URLConnection u = new URL(inputFile.replaceAll("\\\\", "/")).openConnection();
                this._runner = new ScriptExecutor(u.getInputStream(), this._conn);
            } else if (new File(toRun).exists() && new File(toRun).canRead()) {
                this._runner = new ScriptExecutor(new FileInputStream(toRun), this._conn);
            } else {
                runFile = false;
                context.write(MessageFormat.format("SP2-0310: unable to open file \"{0}\"\n", toRun));
                this._runner = new ScriptExecutor(this._conn);
                this._runner.setScriptRunnerContext(context);
            }
            if (runFile) {
                this._runner.setScriptRunnerContext(context);
                SQLPLUS.setExecutorPath(this._runner, inputFile, context);
                try {
                    this.runFile(this._runner, "runner", context, inputFile);
                }
                finally {
                    context.setSourceRef("");
                }
            }
        } else {
            this._runner = new ScriptExecutor(this._conn);
            this._runner.setScriptRunnerContext(context);
        }
        context.putProperty("runner", this._runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFile(ScriptExecutor runner, String name, ScriptRunnerContext context, String inputFile) {
        context.putProperty(name, runner);
        context.setTopLevel(false);
        ArrayList scrArrayList = (ArrayList)this.getScriptRunnerContext().getProperty("script.runner.appinfo.arraylist");
        scrArrayList.add(inputFile);
        this.getScriptRunnerContext().putProperty("script.runner.appinfo.arraylist", scrArrayList);
        this._runner.setScriptRunnerContext(context);
        try {
            this._runner.run();
        }
        finally {
            this.setScriptRunnerContext(this._runner.getScriptRunnerContext());
            scrArrayList = (ArrayList)this.getScriptRunnerContext().getProperty("script.runner.appinfo.arraylist");
            if (scrArrayList.size() != 0) {
                scrArrayList.remove(scrArrayList.size() - 1);
            }
            this.getScriptRunnerContext().putProperty("script.runner.appinfo.arraylist", scrArrayList);
            if (scrArrayList.size() != 0) {
                SetAppinfo.setAppinfo(this.getScriptRunnerContext(), this.getScriptRunnerContext().getCurrentConnection(), (String)scrArrayList.get(scrArrayList.size() - 1), scrArrayList.size());
            } else {
                SetAppinfo.setAppinfo(this.getScriptRunnerContext(), this.getScriptRunnerContext().getCurrentConnection(), SQLPLUS.PRODUCT_NAME, 0);
            }
        }
        context.setTopLevel(true);
    }

    private boolean getPrependDirectory(String inputFile) {
        return !inputFile.startsWith("/") && !inputFile.startsWith("\\") && (System.getProperty("os.name").startsWith("Windows") ? inputFile.length() <= 3 || (inputFile.charAt(1) != ':' || inputFile.charAt(2) != '/' && inputFile.charAt(2) != '\\') && (inputFile.charAt(0) != '/' || inputFile.charAt(2) != ':' || inputFile.charAt(3) != '/') : !inputFile.startsWith("/") && !inputFile.startsWith("\\"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLoginSql(ScriptRunnerContext context) {
        context.putProperty("DBConfig.GLOGIN_FILE", null);
        if (context.getProperty("script.runner.restrict_level") == null || Integer.parseInt((String)context.getProperty("script.runner.restrict_level")) <= 3) {
            if (!SQLCliOptions.isOptionUsed("/nolog")) {
                context.setSQLPlusCmdLineLogin();
                String connectS = SQLCliOptions.getConnectString();
                if (connectS == null) {
                    if (SQLCliOptions.getConnectString() == null && SQLCliOptions.getFileName() != null && SQLCliOptions.getFileName().length() > 0) {
                        String inputFile;
                        context.putProperty("script.runner.sqlplus.logon", Boolean.TRUE);
                        String file = "";
                        String pathGiven = null;
                        if (SQLPLUS.getSqlpathProvider() != null) {
                            pathGiven = SQLPLUS.getSqlpathProvider().getSQLPATHsetting();
                        }
                        if (!(SQLCliOptions.startsWithHttpOrFtp(inputFile = SQLCliOptions.getFileName()) && SQLCliOptions.haveIBytes(inputFile) || SQLCliOptions.haveIBytesRaw(inputFile) || !new File(file = this.getTheCompleteFilename(inputFile, pathGiven)).exists() || !new File(file).canRead())) {
                            connectS = this.getFirstLineOfFile(file, context);
                        }
                    } else {
                        connectS = "";
                    }
                }
                if (SQLCliOptions.getAsRole() != null && !SQLCliOptions.getAsRole().equals("")) {
                    connectS = connectS + " as " + SQLCliOptions.getAsRole();
                } else if (SQLCliOptions.isAsSysBackup()) {
                    connectS = connectS + " as sysbackup";
                }
                connectS = "connect " + connectS + "\n";
                context.putProperty("DBConfig.GLOGIN", true);
                context.putProperty("script.runner.sqlplus.nolog", Boolean.TRUE);
                ScriptExecutor runner = new ScriptExecutor(connectS, null);
                runner.setScriptRunnerContext(context);
                try {
                    Boolean logon = (Boolean)context.getProperty("script.runner.sqlplus.logon");
                    if (logon == null || logon.equals(Boolean.FALSE)) {
                        runner.getScriptRunnerContext().putProperty("script.runner.threetimes", true);
                    } else {
                        runner.getScriptRunnerContext().putProperty("script.runner.threetimes", false);
                    }
                    runner.getScriptRunnerContext().putProperty("script.runner.commandlineconnect", Boolean.TRUE);
                    runner.getScriptRunnerContext().setEscape(false);
                    runner.getScriptRunnerContext().setSubstitutionOn(false);
                    runner.setOut(new BufferedOutputStream(System.out));
                    runner.run();
                }
                finally {
                    runner.getScriptRunnerContext().putProperty("script.runner.threetimes", false);
                }
                if (runner.getScriptRunnerContext().getCurrentConnection() != null) {
                    this._conn = runner.getScriptRunnerContext().getCurrentConnection();
                    context = runner.getScriptRunnerContext();
                    context.setBaseConnection(this._conn);
                    context.setCloseConnection(false);
                    this.handleEditions(runner);
                } else {
                    SqlCli.handleCloseDown(this);
                    System.exit(1);
                }
            } else {
                String loginFile;
                File f;
                String glogin = ShowLogin.firstOrNull(ShowLogin.getLocations(context, "glogin.sql", false));
                if (glogin != null && (f = new File(glogin)).exists()) {
                    try {
                        this._runner = new ScriptExecutor(new FileInputStream(glogin), this._conn);
                        context.putProperty("runner", this._runner);
                        context.putProperty("sqlcli.glogin.sql", Boolean.TRUE);
                        this.runFile(this._runner, "glogin", context, glogin);
                        context.putProperty("sqlcli.glogin.sql", Boolean.FALSE);
                        this._conn = this._runner.getScriptRunnerContext().getCurrentConnection();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                if ((loginFile = this.getLoginFile(context)) != null) {
                    try {
                        this._runner = new ScriptExecutor(new FileInputStream(loginFile), this._conn);
                        context.putProperty("runner", this._runner);
                        context.putProperty("sqlcli.login.sql", Boolean.TRUE);
                        this.runFile(this._runner, "glogin", context, loginFile);
                        context.putProperty("sqlcli.login.sql", Boolean.FALSE);
                        this._conn = this._runner.getScriptRunnerContext().getCurrentConnection();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void handleEditions(ScriptExecutor runner) {
        if (SQLCliOptions.getEdition() != null) {
            String sql = MessageFormat.format("alter session set edition={0}", SQLCliOptions.getEdition());
            runner.setStmt(sql);
            runner.run();
        }
    }

    private String getLoginFile(ScriptRunnerContext context) {
        return ShowLogin.firstOrNull(ShowLogin.getLocations(context, "login.sql", true));
    }

    private String getTheCompleteFilename(String inputFile, String pathGiven) {
        String file = inputFile;
        boolean prependDirectory = this.getPrependDirectory(inputFile);
        if (pathGiven != null && prependDirectory) {
            for (String possible : pathGiven.split(File.pathSeparator)) {
                if (possible == null) continue;
                possible = possible.endsWith("/") || possible.endsWith("\\") ? possible + inputFile : possible + File.separator + inputFile;
                possible = System.getProperty("os.name").startsWith("Windows") ? possible.replace("/", "\\") : possible.replace("\\", "/");
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, MessageFormat.format(Messages.getString("SqlCli.FILECHECK"), possible));
                if (!new File(possible).exists() || !new File(possible).canRead()) continue;
                file = possible;
                break;
            }
        } else {
            file = inputFile;
        }
        return file;
    }

    private String getFirstLineOfFile(String inputFile, ScriptRunnerContext context) {
        try {
            BufferedReader getLoginFile = null;
            getLoginFile = inputFile.indexOf(46) != -1 && inputFile.lastIndexOf(46) > 0 ? new BufferedReader(new FileReader(new File(inputFile))) : (context.getProperty("script.runner.file.suffix") != null ? new BufferedReader(new FileReader(new File(inputFile + "." + context.getProperty("script.runner.file.suffix")))) : new BufferedReader(new FileReader(new File(inputFile))));
            String connectLine = getLoginFile.readLine();
            String patterns = "(\\w+\\/\\w+@\\w+(\\s+as\\s+(sysdba)|(sysoper))?)|\\w+\\/\\w+@\\w+\\s+as\\s+sysdba|\\w+\\/\\w+@\\w+\\s+as\\s+sysoper|\\w+\\/\\w+\\s+as\\s+sysdba|\\w+\\/\\w+\\s+as\\s+sysoper|\\w+\\/\\w+";
            Pattern pattern = Pattern.compile(patterns, 2);
            Matcher matcher = pattern.matcher(connectLine.trim());
            if (matcher.matches()) {
                context.putProperty("SQLCLI_IGNORE_FIRST_LINE", true);
                context.putProperty("script.runner.threetimes", Boolean.FALSE);
                return connectLine.trim();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getPrompt(boolean bold) {
        if (this.RUNNING || SQLCliOptions.isOptionUsed("-silent")) {
            return "";
        }
        if (bold) {
            return Ansi.ansi().bold().a(this._ctx.getPrompt()).reset().toString();
        }
        return Ansi.ansi().render(this._ctx.getPrompt()).reset().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSQLPlus() throws Exception {
        this.getScriptRunnerContext().removeProperty("SQLCLI_IGNORE_FIRST_LINE");
        this.prompt = this.getPrompt(isPromptBold);
        this.reader.setHandleUserInterrupt(true);
        this.reader.setCopyPasteDetection(true);
        this.reader.setBellEnabled(true);
        this.reader.setBasePrompt(this.prompt);
        String leftOver = "";
        String currentLine = "";
        Pattern pattern = Pattern.compile("^(-?\\d+.*)");
        this.stopEditor();
        this.reader.getMultilineBuffer().clear();
        this._exitThread = this.startExitListener(this.reader);
        try {
            String passedText = this.reader.readNonBlockingText();
            if (passedText.trim().length() > 0) {
                this.getScriptRunnerContext().putProperty("script.runner.sqlcl.stdin.input", Boolean.TRUE);
                this.processLine(passedText);
                this.getScriptRunnerContext().putProperty("script.runner.sqlcl.stdin.input", Boolean.FALSE);
            }
            while (this.startEditing() && (currentLine = this.reader.readLine(this._ctx.getPrompt())) != null) {
                SQLCommand incompleteCmd;
                if (!this.RUNNING) {
                    if (this._buffer.getBuffer().trim().length() == 0 || this.isBlockTermBLankLines(this._buffer.getLine(this._buffer.size()).trim())) {
                        ISQLCommand whatami;
                        Iterator<ISQLCommand> line_parser;
                        boolean carryon = false;
                        if (this._buffer.getBuffer().trim().length() > 0 && (line_parser = SqlParserProvider.getScriptParserIterator(this.getScriptRunnerContext(), new StringReader(StringUtils.rtrim(this._buffer.getBuffer())))).hasNext() && (whatami = line_parser.next()).getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_DOC_PLUS)) {
                            carryon = true;
                        }
                        if (!carryon) {
                            this.stopEditor();
                            this.processLine("");
                        }
                    } else if (this._buffer.getBuffer().trim().replaceFirst(";", "").length() == 0) {
                        this.processLine("l");
                    } else if (this._buffer.size() == 1 && pattern.matcher(currentLine).matches()) {
                        this.gotoOrChangeLine(currentLine);
                    } else if (this.reader.justDidHistory()) {
                        this.reader.resetHistoryFlag();
                        this.processLine(this._buffer.getBuffer());
                    } else if (this.reader.isRunBufferNow()) {
                        this.reader.setRunBufferNow(false);
                        this.processLine(this._buffer.getBuffer());
                    } else if (this.isSQL(this._buffer.getBuffer()) && this.reader.getMultilineBuffer().size() > 1 && this.reader.getMultilineBuffer().getCurrentLine() == this.reader.getMultilineBuffer().size() && this.lastLineSQLBlankLines(this.reader.getMultilineBuffer().getLine(this.reader.getMultilineBuffer().getCurrentLine()).trim())) {
                        String tmp;
                        if (this.lastLineSQLBlankLines(this.reader.getMultilineBuffer().getLine(this.reader.getMultilineBuffer().getCurrentLine()).trim()) && !(tmp = this.reader.getMultilineBuffer().getBuffer().trim().toLowerCase()).startsWith("begin") && !tmp.startsWith("declare")) {
                            this.stopEditor();
                        }
                    } else if (this.reader.getMultilineBuffer().getCurrentLine() >= this.reader.getMultilineBuffer().size() && (this.reader.getMultilineBuffer().getCurrentLine() != this.reader.getMultilineBuffer().size() || this.reader.getCursorBuffer().cursor >= this.reader.getCursorBuffer().length())) {
                        String line = this._buffer.getBuffer();
                        if (line != null) {
                            this._buffer.startEditing(false);
                        }
                        String dummyComment = "";
                        String s = this._buffer.getBuffer();
                        for (int i = 0; i < 1000 && s.indexOf(dummyComment = "/* SQLDevZ " + i + " dummy*/") != -1; ++i) {
                        }
                        ISQLCommand icmd = null;
                        if (s.startsWith("*")) {
                            this.processLine(s + ";\n");
                        } else {
                            String alt = s + dummyComment;
                            Iterator<ISQLCommand> m_parser = SqlParserProvider.getScriptParserIterator(this.getScriptRunnerContext(), new StringReader(alt));
                            int commandCount = 0;
                            while ((commandCount <= 0 || !leftOver.equals("")) && m_parser.hasNext()) {
                                icmd = m_parser.next();
                                String runWith = icmd.getSQLOrig();
                                ++commandCount;
                                if (icmd.getSQLOrig().indexOf(dummyComment) == -1) {
                                    s = s.replaceAll("\\\\r\\\\n", "\n");
                                    if (icmd.getSQLOrig().replaceAll("\\\\r\\\\n", "\n").trim().length() <= s.length()) {
                                        leftOver = StringUtils.rtrim(StringUtils.rtrim(s).substring(icmd.getSQLOrig().replaceAll("\\\\r\\\\n", "\n").length()));
                                    }
                                    if (icmd.getStatementTerminator() != null && !icmd.getStatementTerminator().equals("")) {
                                        String termTrim = icmd.getStatementTerminator().trim();
                                        if (leftOver.startsWith(termTrim)) {
                                            leftOver = leftOver.length() == 1 || leftOver.length() == 0 ? "" : leftOver.substring(1).trim();
                                        }
                                        if (!termTrim.equals("") && !runWith.trim().endsWith(termTrim)) {
                                            if (termTrim.equals("/")) {
                                                runWith = runWith + "\n/\n";
                                            } else if (termTrim.equals(";")) {
                                                runWith = runWith + ";\n";
                                            }
                                        }
                                    }
                                    this.processLine(runWith);
                                    this.prompt = this.getPrompt(isPromptBold);
                                    if (this.getScriptRunnerContext().getProperty("script.runner.exit_int") != null) break;
                                    icmd = null;
                                }
                                String terminator = this.getScriptRunnerContext().getProperty("script.runner.sqlcl.sql.terminator").toString();
                                if (icmd != null && icmd.getProperty("terminator") != null) {
                                    terminator = (String)icmd.getProperty("terminator");
                                }
                                if (icmd == null || !icmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQL) || !s.trim().endsWith(terminator) || icmd.getStmtSubType() == null || icmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_WITH) continue;
                                Pattern p = Pattern.compile("\\/\\*\\s+SQLDevZ\\s+\\d+\\s+dummy\\*\\/", 32);
                                Matcher m = p.matcher(icmd.getSQLOrig());
                                if (m.find()) {
                                    icmd.setSQLOrig(m.replaceFirst(""));
                                }
                                this.processLine(icmd.getSQLOrig());
                                this.prompt = this.getPrompt(isPromptBold);
                            }
                        }
                    }
                    if (this.getScriptRunnerContext().getProperty("script.runner.exit_int") != null) {
                        break;
                    }
                    if (this._buffer.getCurrentLine() > -1 && (this._buffer.getCurrentLine() < this._buffer.size() || this._buffer.isEditing())) {
                        this.prompt = this._buffer.getPrompt();
                    } else if (this._buffer.getCurrentLine() == this._buffer.size() && this._buffer.getLine(this._buffer.getCurrentLine()).trim().equals("") || this.processed) {
                        this.prompt = this.getPrompt(isPromptBold);
                        this._buffer.stopEditing();
                        this._buffer.clear();
                        this.processed = false;
                    } else if (!this.RUNNING && this._buffer.isEditing()) {
                        this.prompt = this._buffer.getPrompt();
                    } else {
                        this.prompt = this.getPrompt(isPromptBold);
                        this._buffer.clear();
                    }
                }
                if ((incompleteCmd = (SQLCommand)this.getScriptRunnerContext().getProperty("incomplete")) == null) continue;
                this.reader.getMultilineBuffer().add(incompleteCmd.getModifiedSQL());
                this.getScriptRunnerContext().removeProperty("incomplete");
            }
        }
        catch (UserInterruptException e) {
            this.getScriptRunnerContext().write("Interupt\n");
            this.reader.fireListeners("ctrlc");
        }
        finally {
            this.stopExitListener(this._exitThread);
        }
    }

    private boolean lastLineSQLBlankLines(String trim) {
        if (!trim.equals("")) {
            return false;
        }
        ScriptRunnerContext ctx = this.getScriptRunnerContext();
        String sqlbl = (String)ctx.getProperty("SQLBLANKLINES");
        boolean on = false;
        on = sqlbl == null ? false : sqlbl.equals("on");
        return !on;
    }

    private boolean isBlockTermBLankLines(String terminator) {
        String defaultBlo;
        String blo = defaultBlo = ".";
        ScriptRunnerContext ctx = this.getScriptRunnerContext();
        blo = (String)ctx.getProperty("BLOCKTERMINATOR");
        if (blo == null) {
            blo = defaultBlo;
        } else if (blo.equals("off")) {
            blo = null;
        } else if (blo.equals("on")) {
            blo = defaultBlo;
        }
        if (blo == null) {
            return false;
        }
        return terminator.equals(blo);
    }

    private boolean isSQL(String buffer) {
        Iterator<ISQLCommand> parser = SqlParserProvider.getScriptParserIterator(this.getScriptRunnerContext(), new StringReader(buffer));
        while (parser.hasNext()) {
            ISQLCommand cmd = parser.next();
            if (!cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQL)) continue;
            return true;
        }
        return false;
    }

    private void stopEditor() throws IOException {
        this.prompt = this.stopEditing();
        this._buffer.deleteLast();
        if (this._buffer.getBuffer().trim().length() > 0) {
            int currentLine = this._buffer.getBufferSafe().getCurrentLine();
            this.getScriptRunnerContext().getSQLPlusBuffer().setBufferSafe(this._buffer.getBufferList());
            this.getScriptRunnerContext().getSQLPlusBuffer().getBufferSafe().setCurrentLine(currentLine);
            this.getScriptRunnerContext().getSQLPlusBuffer().getBufferSafe().setTermLine(this._buffer.getTermLine(), this.reader.getHeight());
        }
        this.reader.println();
        this.reader.flush();
    }

    private ExitThread startExitListener(SQLPlusConsoleReader reader) {
        ExitThread exitThread = new ExitThread("Exit Thread", reader, this._runner);
        exitThread.setPriority(1);
        exitThread.setDaemon(true);
        exitThread.start();
        return exitThread;
    }

    private void stopExitListener(ExitThread exitThread) {
        if (exitThread != null) {
            exitThread.interrupt();
        }
    }

    private boolean startEditing() {
        SQLCommand incompleteCmd = (SQLCommand)this.getScriptRunnerContext().getProperty("incomplete");
        if (incompleteCmd != null) {
            this.reader.getMultilineBuffer().add(incompleteCmd.getModifiedSQL());
            this.getScriptRunnerContext().removeProperty("incomplete");
        }
        return true;
    }

    private String stopEditing() {
        this._buffer.stopEditing();
        String prompt = this.getPrompt(isPromptBold);
        return prompt;
    }

    private void gotoOrChangeLine(String lineNumber) throws IOException {
        try {
            int n = Integer.parseInt(lineNumber.split("\\s+")[0]);
        }
        catch (NumberFormatException e) {
            this.getScriptRunnerContext().write(MessageFormat.format(Messages.getString("SqlCli.39"), lineNumber));
            this.processed = true;
            this.reader.resetEditor();
            this.reader.setBasePrompt(this.getPrompt(isPromptBold));
            this.getScriptRunnerContext().getOutputStream().flush();
            return;
        }
        if (this._buffer.getBufferSafe().size() > 0) {
            String command = "";
            int gotoLineNumber = 0;
            StringTokenizer st = new StringTokenizer(lineNumber);
            if (st.hasMoreTokens()) {
                String s = st.nextToken();
                try {
                    gotoLineNumber = Integer.parseInt(s);
                }
                catch (Exception e) {
                    gotoLineNumber = -1;
                }
            }
            if (st.hasMoreTokens()) {
                while (st.hasMoreTokens()) {
                    command = command + st.nextToken() + " ";
                }
            }
            if (command.trim().endsWith(";")) {
                command = command.trim().substring(0, command.trim().length() - 1);
            }
            if (gotoLineNumber >= 0) {
                if (command.length() > 0) {
                    if (gotoLineNumber == 0) {
                        this._buffer.getBufferSafe().addAtIndex(0, command);
                    } else if (gotoLineNumber > this._buffer.getBufferSafe().linesInBuffer()) {
                        this._buffer.getBufferSafe().add(command);
                    } else {
                        this._buffer.getBufferSafe().replace(gotoLineNumber, command);
                    }
                } else {
                    this.getScriptRunnerContext().write("\n" + this._buffer.getBufferSafe().setCurrentLine(gotoLineNumber));
                }
            }
        } else {
            this.getScriptRunnerContext().write("\n" + Messages.getString("SqlCli.15"));
        }
        this.processed = true;
        this.reader.resetEditor();
        this.reader.setBasePrompt(this.getPrompt(isPromptBold));
        this.getScriptRunnerContext().getOutputStream().flush();
    }

    protected void setScriptRunnerContext(ScriptRunnerContext newContext) {
        this._ctx = newContext;
        this._ctx.setSQLPlusBuffer(this._buffer);
        LinkedList<Completer> completors = new LinkedList<Completer>();
        this.reader.addCompleter(new FileNameCompleter(this._ctx));
        this.reader.addCompleter(new SqlclCompleter(this._ctx));
        this.reader.addCompleter(new ArgumentCompleter(completors));
    }

    private static void handleExit(SqlCli cli) {
        Integer exitInt = (Integer)cli.getScriptRunnerContext().getProperty("script.runner.exit_int");
        cli.getScriptRunnerContext().deferredReInitClear();
        if (exitInt != null && exitInt > 0) {
            System.exit(exitInt);
        }
        System.exit(0);
    }

    private static void handleCloseDown(SqlCli cli) {
        Connection current = cli.getScriptRunnerContext().getCurrentConnection();
        try {
            if (cli.getScriptRunnerContext().getProperty("Spool.out.buffer") != null) {
                cli.getScriptRunnerContext().stopSpool();
            }
            if (current != null && !current.isClosed()) {
                if (cli.getScriptRunnerContext().getProperty("script.runner.sqlplus.nolog") == null || cli.getScriptRunnerContext().getProperty("script.runner.sqlplus.nolog").equals(Boolean.FALSE)) {
                    SQLPLUS.disconnectMessage(current, cli.getScriptRunnerContext(), cli.getScriptRunnerContext().getOutputStream());
                }
                current.close();
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handleException(e);
        }
    }

    @Override
    public void raiseEvent(String event) {
        if (event.equals("ctrlc")) {
            this.getScriptRunnerContext();
        }
    }

    public static class ExitThread
    extends Thread {
        SQLPlusConsoleReader _reader = null;
        ScriptExecutor _runner = null;
        boolean _running = true;
        static boolean _listen = false;
        static boolean _resume = false;

        public ExitThread(String name, SQLPlusConsoleReader reader, ScriptExecutor runner) {
            super(name);
            this._reader = reader;
            this._runner = runner;
        }

        public static void stopListening() {
            _resume = _listen = false;
        }

        public void listen() {
            _resume = _listen = true;
        }

        public static void resumeListening() {
            _listen = _resume;
        }

        @Override
        public void interrupt() {
            super.interrupt();
            this._running = false;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            sameSession = false;
            while (!ExitThread.interrupted()) {
                if (!this._running) {
                    return;
                }
                if (ExitThread._listen) {
                    try {
                        in = this._reader.getInput();
                        if (!(in instanceof DbtoolsNonBlockingInputStream)) ** GOTO lbl33
                        chrs = ((DbtoolsNonBlockingInputStream)in).fullPeek();
                        if (chrs.contains(3)) {
                            if (sameSession) {
                                System.exit(1);
                            }
                            ((DbtoolsNonBlockingInputStream)in).resetBuffer();
                            sameSession = true;
                            if (this._runner == null) ** GOTO lbl33
                            this._runner.interrupt();
                        }
                        if (!chrs.contains(20)) ** GOTO lbl33
                        ((DbtoolsNonBlockingInputStream)in).resetBuffer();
                        threads = Thread.getAllStackTraces();
                        for (Thread key : threads.keySet()) {
                            System.out.println(key.getName());
                            for (StackTraceElement s : stack = threads.get(key)) {
                                System.out.println("\t" + s);
                            }
                            System.out.println("\n");
                        }
                    }
                    catch (Exception e) {
                        return;
                    }
                } else {
                    sameSession = false;
                }
lbl33:
                // 7 sources

                try {
                    ExitThread.sleep(200L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }
}

