/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.raptor.console.HistoryItem;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class HistoryParser {
    private static final String HISTORY = "history";
    private static final String HISTORYITEM = "historyItem";
    public static String ORIGINAL = "original";
    public static String TIMESTAMP = "timestamp";
    public static String TIMESUSED = "timesUsed";
    public static String TIMING = "timing";
    public static String FAILURE = "failure";
    protected static Logger LOGGER = Logger.getLogger(HistoryParser.class.getName());
    private XMLDocument _document;
    private DOMParser parser;
    ArrayList<HistoryItem> history = new ArrayList();

    public static void main(String[] args) {
    }

    public HistoryParser() {
    }

    public HistoryParser(URL u) {
        try {
            this.parser.parse(u.openStream());
            this._document = this.parser.getDocument();
        }
        catch (IOException | SAXException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<HistoryItem> processXML(URL u) throws Exception {
        if (this.parser == null) {
            this.parser = new DOMParser();
        } else {
            this.parser.reset();
        }
        this.parser.setPreserveWhitespace(false);
        this.parser.parse(u.openStream());
        this._document = this.parser.getDocument();
        NodeList rootNodes = this._document.getChildNodes();
        for (int i = 0; i < rootNodes.getLength(); ++i) {
            this.processNodes(rootNodes.item(i));
        }
        return this.history;
    }

    private void processNodes(Node item) {
        NodeList children = item.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (!childName.equalsIgnoreCase(HISTORYITEM)) continue;
            this.newItem(child);
        }
    }

    private void newItem(Node child) {
        String original = "";
        String timeStamp = "";
        long timing = 0L;
        String timesUsed = "";
        boolean failure = false;
        NodeList items = child.getChildNodes();
        for (int i = 0; i < items.getLength(); ++i) {
            String t;
            Node n1;
            Node x = items.item(i);
            if (x.getNodeName().equalsIgnoreCase(ORIGINAL) && (n1 = x.getFirstChild()) instanceof Text) {
                original = ((Text)n1).getTextContent();
            }
            if (x.getNodeName().equalsIgnoreCase(TIMESTAMP) && (n1 = x.getFirstChild()) instanceof Text) {
                timeStamp = ((Text)n1).getTextContent();
            }
            if (x.getNodeName().equalsIgnoreCase(TIMESUSED) && (n1 = x.getFirstChild()) instanceof Text) {
                timesUsed = ((Text)n1).getTextContent();
            }
            if (x.getNodeName().equalsIgnoreCase(TIMING) && (n1 = x.getFirstChild()) instanceof Text) {
                t = ((Text)n1).getTextContent();
                timing = Long.valueOf(t);
            }
            if (!x.getNodeName().equalsIgnoreCase(FAILURE) || !((n1 = x.getFirstChild()) instanceof Text)) continue;
            t = ((Text)n1).getTextContent();
            failure = Boolean.valueOf(t);
        }
        this.history.add(new HistoryItem(original, timeStamp, timesUsed, timing, failure));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putXML(File f, ArrayList<HistoryItem> history) throws Exception {
        f.createNewFile();
        Element e = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.newDocument();
        Element rootEle = dom.createElement(HISTORY);
        for (HistoryItem item : history) {
            e = dom.createElement(HISTORYITEM);
            String original = item.getData();
            int timesUsed = item.getTimesUsed();
            String timing = Long.toString(item.getTiming());
            String timeStamp = item.getTimestamp();
            boolean failure = item.isFail();
            Element tElemt = dom.createElement(ORIGINAL);
            tElemt.appendChild(dom.createCDATASection(original));
            e.appendChild(tElemt);
            tElemt = dom.createElement(TIMESTAMP);
            tElemt.appendChild(dom.createCDATASection(timeStamp));
            e.appendChild(tElemt);
            tElemt = dom.createElement(TIMESUSED);
            tElemt.appendChild(dom.createCDATASection(timesUsed + ""));
            e.appendChild(tElemt);
            tElemt = dom.createElement(TIMING);
            tElemt.appendChild(dom.createCDATASection(timing));
            e.appendChild(tElemt);
            tElemt = dom.createElement(FAILURE);
            tElemt.appendChild(dom.createCDATASection(String.valueOf(failure)));
            e.appendChild(tElemt);
            rootEle.appendChild(e);
        }
        dom.appendChild(rootEle);
        FileOutputStream fos = null;
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("encoding", "UTF-8");
            tr.setOutputProperty("cdata-section-elements", ORIGINAL + " " + TIMESTAMP + " " + TIMESUSED + " " + TIMING);
            tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            fos = new FileOutputStream(f.getAbsolutePath());
            tr.transform(new DOMSource(dom), new StreamResult(fos));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ioe.getLocalizedMessage());
                }
            }
        }
    }
}

