/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.ide.ExtensionRegistry;

public class ListenerUtils {
    private static final String CONFIG_DIR = "config";
    private static final String ORDS = "ords";
    private static final int MAX_BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzip(File file, File file2) throws IOException {
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("Cannot make directory folder: " + file2.getPath());
        }
        String string = file2.getPath().replace('\\', '/');
        FilterOutputStream filterOutputStream = null;
        try (ZipInputStream zipInputStream = null;){
            String string2 = null;
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string3 = zipEntry.getName().replace('\\', '/');
                string2 = string + "/" + string3;
                File file3 = new File(string2);
                if (zipEntry.isDirectory() || string3.endsWith("/")) {
                    file3.mkdirs();
                } else {
                    file3.getParentFile().mkdirs();
                    try {
                        int n;
                        filterOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
                        byte[] byArray = new byte[4096];
                        while ((n = zipInputStream.read(byArray)) != -1) {
                            ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                        }
                    }
                    finally {
                        if (filterOutputStream != null) {
                            filterOutputStream.close();
                        }
                    }
                }
                zipInputStream.closeEntry();
            }
        }
        return true;
    }

    public static File createConfigTempDir() throws IOException {
        String string;
        URL uRL = ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.sqldeveloper.listener");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
        String string2 = simpleDateFormat.format(Calendar.getInstance().getTime());
        String string3 = uRL.getPath().replace('\\', '/');
        File file = new File(string3, string = CONFIG_DIR + File.separator + ORDS + "_" + string2);
        if (file.mkdirs()) {
            return file;
        }
        throw new IOException("Cannot create config directories: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray;
                file2.mkdirs();
                for (File file3 : fileArray = file.listFiles()) {
                    ListenerUtils.copy(file3, new File(file2, file3.getName()));
                }
            } else {
                file2.getParentFile().mkdirs();
                FileInputStream fileInputStream = null;
                FileOutputStream fileOutputStream = null;
                fileInputStream = new FileInputStream(file);
                try {
                    fileOutputStream = new FileOutputStream(file2);
                    try {
                        int n;
                        byte[] byArray = new byte[1024];
                        while ((n = fileInputStream.read(byArray)) > 0) {
                            fileOutputStream.write(byArray, 0, n);
                        }
                    }
                    finally {
                        fileOutputStream.close();
                    }
                }
                finally {
                    fileInputStream.close();
                }
            }
        }
    }

    public static void delete(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray;
                for (File file2 : fileArray = file.listFiles()) {
                    ListenerUtils.delete(file2);
                }
            }
            file.delete();
        }
    }
}

