/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.model.ListenerSecuritySettings;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.util.ResourceUtils;

public class ListenerSecurityPanel
extends ListenerSettings {
    private NumericSpinBox _maxCacheEntries;
    private JCheckBox _verifySSLRequests;

    public ListenerSecurityPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this._verifySSLRequests = new JCheckBox();
        this._maxCacheEntries = new NumericSpinBox(100, 100000);
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._maxCacheEntries, (String)ListenerArb.getString("MAX_CACHE_ENTRIES"));
        ResourceUtils.resButton((AbstractButton)this._verifySSLRequests, (String)ListenerArb.getString("VERIFY_SSL_REQUESTS"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 22, 0, new Insets(8, 8, 0, 6), 0, 0));
        jPanel.add((Component)this._maxCacheEntries, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 0, 0, 8), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 22, 0, new Insets(8, 8, 8, 6), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel, (String)ListenerArb.getString("SECURITY_CACHE_TITLE"));
        n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this._verifySSLRequests, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 0, 8), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 23, 0, new Insets(15, 8, 0, 8), 0, 0));
        jPanel2.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addSettingsPanel(jPanel2);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        this.initSettings(listenerModel, listenerModel2, "Security");
        this.assignSettings(this._model);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel) {
        if (listenerModel != null && listenerModel.getSecuritySettings() != null) {
            ListenerSecuritySettings listenerSecuritySettings = listenerModel.getSecuritySettings();
            this._maxCacheEntries.setIntValue(listenerSecuritySettings.getMaximumCacheEntries());
            this._verifySSLRequests.setSelected(listenerSecuritySettings.isVerifySSLRequests());
            if (this._parentModel != null) {
                this.highlightGlobalValues(this._parentModel);
            }
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._model != null && this._model.getSecuritySettings() != null) {
            ListenerSecuritySettings listenerSecuritySettings = this._model.getSecuritySettings();
            listenerSecuritySettings.setMaximumCacheEntries(this._maxCacheEntries.getIntValue());
            listenerSecuritySettings.setVerifySSLRequests(this._verifySSLRequests.isSelected());
        }
        return this._model;
    }

    @Override
    public void highlightGlobalValues(ListenerModel listenerModel) {
        ListenerSecuritySettings listenerSecuritySettings = listenerModel.getSecuritySettings();
        this.updateNumericSpinBoxHandler(this._maxCacheEntries, listenerSecuritySettings.getMaximumCacheEntries());
        this.updateCheckBoxHandler(this._verifySSLRequests, listenerSecuritySettings.isVerifySSLRequests());
    }

    @Override
    public boolean isGlobalSettingsChange() {
        if (this._parentModel == null) {
            ListenerSecuritySettings listenerSecuritySettings = this._model.getSecuritySettings();
            if (this._maxCacheEntries.getIntValue() != listenerSecuritySettings.getMaximumCacheEntries() || this._verifySSLRequests.isSelected() != listenerSecuritySettings.isVerifySSLRequests()) {
                return true;
            }
        }
        return false;
    }
}

