/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JPanel;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.model.ListenerProcedureSettings;
import oracle.dbtools.listener.ui.ListenerNameTablePanel;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.dbtools.listener.ui.ListenerUIUtils;

public class ListenerProcedureProcessingPanel
extends ListenerSettings {
    private ListenerNameTablePanel _tablePanel;
    private String _type;

    public ListenerProcedureProcessingPanel(String string) {
        this._type = string;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(300, 275));
        String string = null;
        if (this._type.equals("PreProcessing")) {
            string = ListenerArb.getString("PREPROC_DESCRIP");
        } else if (this._type.equals("PostProcessing")) {
            string = ListenerArb.getString("POSTPROC_DESCRIP");
        }
        this._tablePanel = new ListenerNameTablePanel(string, null);
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._tablePanel, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 23, 1, new Insets(8, 8, 8, 8), 0, 0));
        this.addSettingsPanel(jPanel);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        this.initSettings(listenerModel, listenerModel2, this._type);
        this.assignSettings(this._model);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel) {
        if (listenerModel != null && listenerModel.getProcedureSettings() != null && this._type != null) {
            ListenerProcedureSettings listenerProcedureSettings = listenerModel.getProcedureSettings();
            if (this._type.equals("PreProcessing")) {
                this._tablePanel.setNames(listenerProcedureSettings.getPreProcessProcedures());
            } else if (this._type.equals("PostProcessing")) {
                this._tablePanel.setNames(listenerProcedureSettings.getPostProcessProcedures());
            }
            if (this._parentModel != null) {
                this.highlightGlobalValues(this._parentModel);
            }
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._model != null && this._model.getProcedureSettings() != null && this._type != null) {
            if (this._tablePanel.getTable() != null && this._tablePanel.getTable().getCellEditor() != null && this._tablePanel.getTable().isEditing()) {
                this._tablePanel.getTable().getCellEditor().stopCellEditing();
            }
            ListenerProcedureSettings listenerProcedureSettings = this._model.getProcedureSettings();
            if (this._type.equalsIgnoreCase("PreProcessing")) {
                listenerProcedureSettings.setPreProcessProcedures(this._tablePanel.getNames());
            } else if (this._type.equalsIgnoreCase("PostProcessing")) {
                listenerProcedureSettings.setPostProcessProcedures(this._tablePanel.getNames());
            }
        }
        return this._model;
    }

    @Override
    public void highlightGlobalValues(ListenerModel listenerModel) {
        if (listenerModel != null) {
            if (this._tablePanel.getTable() != null && this._tablePanel.getTable().getCellEditor() != null && this._tablePanel.getTable().isEditing()) {
                this._tablePanel.getTable().getCellEditor().stopCellEditing();
            }
            if (this._type.equals("PreProcessing")) {
                this._tablePanel.setParentNames(listenerModel.getProcedureSettings().getPreProcessProcedures());
            } else if (this._type.equals("PostProcessing")) {
                this._tablePanel.setParentNames(listenerModel.getProcedureSettings().getPostProcessProcedures());
            }
        }
    }

    @Override
    public boolean resetSettings() {
        if (this._parentModel != null) {
            this._tablePanel.removeAllRows();
            this.assignSettings(this._parentModel);
            return true;
        }
        return false;
    }

    @Override
    public boolean isGlobalSettingsChange() {
        if (this._parentModel == null) {
            List<String> list = null;
            if (this._type.equalsIgnoreCase("PreProcessing")) {
                list = this._model.getProcedureSettings().getPreProcessProcedures();
            } else if (this._type.equalsIgnoreCase("PostProcessing")) {
                list = this._model.getProcedureSettings().getPostProcessProcedures();
            }
            String string = ListenerUIUtils.getCommaDelimited(list);
            String string2 = ListenerUIUtils.getCommaDelimited(this._tablePanel.getNames());
            if (!string2.equals(string)) {
                return true;
            }
        }
        return false;
    }
}

