/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.model.ListenerReportSettings;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.dbtools.listener.ui.ListenerUIUtils;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.util.ResourceUtils;

public class ListenerExcelPanel
extends ListenerSettings {
    private JTextField _collectionName;
    private JCheckBox _createCollectionFromExcelFile;
    private JRadioButton _putWorkSheetsInOneCollection;
    private JRadioButton _useWorkSheetNameAsCollectionName;
    private boolean _globalWorkSheetOneCollection;
    private Color _globalBGColor;
    private Color _origRadioBGColor;
    private boolean _checkEnabling = false;

    public ListenerExcelPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this._createCollectionFromExcelFile = new JCheckBox();
        this._putWorkSheetsInOneCollection = new JRadioButton();
        this._useWorkSheetNameAsCollectionName = new JRadioButton();
        this._collectionName = new JTextField();
        JLabel jLabel = new JLabel();
        ResourceUtils.resButton((AbstractButton)this._createCollectionFromExcelFile, (String)ListenerArb.getString("EXCEL_COLLECTION"));
        ResourceUtils.resButton((AbstractButton)this._putWorkSheetsInOneCollection, (String)ListenerArb.getString("EXCEL_1_COLLECTION"));
        ResourceUtils.resButton((AbstractButton)this._useWorkSheetNameAsCollectionName, (String)ListenerArb.getString("EXCEL_USE_SHEET_NAME"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._collectionName, (String)ListenerArb.getString("EXCEL_COLLECTION_NAME"));
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 8, 6), 0, 0));
        jPanel.add((Component)this._collectionName, new GridBagConstraints(1, n, 1, 1, 1.0, 1.0, 23, 2, new Insets(8, 0, 8, 8), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._putWorkSheetsInOneCollection);
        buttonGroup.add(this._useWorkSheetNameAsCollectionName);
        n = 0;
        jPanel2.add((Component)this._putWorkSheetsInOneCollection, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 2, new Insets(8, 8, 0, 8), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 2, new Insets(3, 16, 0, 8), 0, 0));
        jPanel2.add((Component)this._useWorkSheetNameAsCollectionName, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 2, new Insets(8, 8, 8, 8), 0, 0));
        n = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)this._createCollectionFromExcelFile, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 2, new Insets(8, 8, 0, 8), 0, 0));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 21, 2, new Insets(8, 8, 0, 8), 0, 0));
        jPanel3.add(Box.createGlue(), new GridBagConstraints(1, n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel3, (String)ListenerArb.getString("EXCEL_APEX_COLLECTION_TITLE"));
        n = 0;
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)jPanel3, new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 21, 2, new Insets(8, 8, 0, 8), 0, 0));
        jPanel4.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addSettingsPanel(jPanel4);
    }

    private void enableDisableCollectionName() {
        if (this._createCollectionFromExcelFile.isSelected()) {
            this._collectionName.setEnabled(this._putWorkSheetsInOneCollection.isSelected());
        }
    }

    private void enableDisableRadioButtons() {
        this._putWorkSheetsInOneCollection.setEnabled(this._createCollectionFromExcelFile.isSelected());
        this._useWorkSheetNameAsCollectionName.setEnabled(this._createCollectionFromExcelFile.isSelected());
        this._collectionName.setEnabled(this._createCollectionFromExcelFile.isSelected() && this._putWorkSheetsInOneCollection.isSelected());
    }

    private void updateRadioButtonBGColor() {
        if (this._globalWorkSheetOneCollection) {
            this._putWorkSheetsInOneCollection.setBackground(this._globalBGColor);
            this._useWorkSheetNameAsCollectionName.setBackground(this._origRadioBGColor);
        } else {
            this._putWorkSheetsInOneCollection.setBackground(this._origRadioBGColor);
            this._useWorkSheetNameAsCollectionName.setBackground(this._globalBGColor);
        }
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        this.initSettings(listenerModel, listenerModel2, "Excel");
        this._checkEnabling = false;
        this.assignSettings(this._model);
        this._globalBGColor = ListenerUIUtils.getHighlightBackgroundColor();
        this._origRadioBGColor = new Color(this._putWorkSheetsInOneCollection.getBackground().getRGB());
        if (listenerModel2 != null) {
            this._putWorkSheetsInOneCollection.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    try {
                        ListenerExcelPanel.this.updateRadioButtonBGColor();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        this._putWorkSheetsInOneCollection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    ListenerExcelPanel.this.enableDisableCollectionName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this._createCollectionFromExcelFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    ListenerExcelPanel.this.enableDisableRadioButtons();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.enableDisableCollectionName();
        this.enableDisableRadioButtons();
        this._checkEnabling = true;
    }

    @Override
    public void assignSettings(ListenerModel listenerModel) {
        if (listenerModel != null && listenerModel.getReportSettings() != null) {
            ListenerReportSettings listenerReportSettings = listenerModel.getReportSettings();
            if (this._checkEnabling) {
                if (!this._createCollectionFromExcelFile.isEnabled()) {
                    this._createCollectionFromExcelFile.setEnabled(true);
                }
                if (!this._putWorkSheetsInOneCollection.isEnabled()) {
                    this._putWorkSheetsInOneCollection.setEnabled(true);
                }
                if (!this._useWorkSheetNameAsCollectionName.isEnabled()) {
                    this._useWorkSheetNameAsCollectionName.setEnabled(true);
                }
                if (!this._collectionName.isEnabled()) {
                    this._collectionName.setEnabled(true);
                }
            }
            this._createCollectionFromExcelFile.setSelected(listenerReportSettings.isCreateCollectionFromExcelFile());
            if (listenerReportSettings.isPutWorkSheetsInOneCollection()) {
                this._putWorkSheetsInOneCollection.setSelected(true);
                this._useWorkSheetNameAsCollectionName.setSelected(false);
            } else {
                this._useWorkSheetNameAsCollectionName.setSelected(true);
                this._putWorkSheetsInOneCollection.setSelected(false);
            }
            this._collectionName.setText(listenerReportSettings.getCollectionName());
            if (this._parentModel != null) {
                this.highlightGlobalValues(this._parentModel);
            }
            if (this._checkEnabling) {
                this.enableDisableCollectionName();
                this.enableDisableRadioButtons();
            }
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._model != null && this._model.getReportSettings() != null) {
            ListenerReportSettings listenerReportSettings = this._model.getReportSettings();
            listenerReportSettings.setCreateCollectionFromExcelFile(this._createCollectionFromExcelFile.isSelected());
            listenerReportSettings.setPutWorkSheetsInOneCollection(this._putWorkSheetsInOneCollection.isSelected());
            listenerReportSettings.setUseWorkSheetNameAsCollectionName(this._useWorkSheetNameAsCollectionName.isSelected());
            listenerReportSettings.setCollectionName(this._collectionName.getText());
        }
        return this._model;
    }

    @Override
    public void highlightGlobalValues(ListenerModel listenerModel) {
        ListenerReportSettings listenerReportSettings = listenerModel.getReportSettings();
        this.updateTextHandler(this._collectionName, listenerReportSettings.getCollectionName());
        this.updateCheckBoxHandler(this._createCollectionFromExcelFile, listenerReportSettings.isCreateCollectionFromExcelFile());
        this._globalWorkSheetOneCollection = listenerReportSettings.isPutWorkSheetsInOneCollection();
        this.updateRadioButtonBGColor();
    }

    @Override
    public boolean isGlobalSettingsChange() {
        if (this._parentModel == null) {
            ListenerReportSettings listenerReportSettings = this._model.getReportSettings();
            if (this._createCollectionFromExcelFile.isSelected() != listenerReportSettings.isCreateCollectionFromExcelFile() || this._putWorkSheetsInOneCollection.isSelected() != listenerReportSettings.isPutWorkSheetsInOneCollection() || this._useWorkSheetNameAsCollectionName.isSelected() != listenerReportSettings.isUseWorkSheetNameAsCollectionName() || this._collectionName.getText() != listenerReportSettings.getCollectionName()) {
                return true;
            }
        }
        return false;
    }
}

