/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import oracle.dbtools.listener.ui.ListenerUIUtils;

public class ListenerComboBoxHandler
implements ItemListener {
    private JComboBox _cb;
    private Color _origBGColor;
    private Color _globalBGColor;
    private int _globalValue;
    private boolean _isGlobalDisplay = true;

    ListenerComboBoxHandler(JComboBox jComboBox, int n) {
        this._cb = jComboBox;
        this._origBGColor = new Color(this._cb.getBackground().getRGB());
        this._globalBGColor = ListenerUIUtils.getHighlightBackgroundColor();
        this._globalValue = n;
        this.updateComboBox(this._cb.getSelectedIndex());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateComboBox(this._cb.getSelectedIndex());
    }

    public void updateGlobalValue(int n) {
        if (this._globalValue != n) {
            this._globalValue = n;
            this.updateComboBox(this._cb.getSelectedIndex());
            this._cb.revalidate();
            this._cb.repaint();
        }
    }

    private void updateComboBox(int n) {
        if (n == this._globalValue) {
            this._cb.setBackground(this._globalBGColor);
            this._isGlobalDisplay = true;
        } else if (this._isGlobalDisplay) {
            this._cb.setBackground(this._origBGColor);
            this._isGlobalDisplay = false;
        }
    }
}

