/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.nosql.ui;

import java.io.File;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.nosql.NoSQLUtils;
import oracle.dbtools.listener.ui.ListenerPanel;
import oracle.dbtools.listener.utils.ListenerUtils;
import oracle.dbtools.listener.xml.ListenerImportAdmin;
import oracle.dbtools.util.Logger;
import oracle.javatools.dialogs.MessageDialog;

public class NoSQLStoreDelete {
    public static final boolean deleteNoSQLStore(String string, String string2, int n) {
        return new NoSQLStoreDelete().deleteStore(string, string2, n);
    }

    private boolean deleteStore(String string, String string2, int n) {
        String string3 = ListenerArb.format("NOSQL_DELETE_CONFIRM", string2);
        boolean bl = MessageDialog.confirm(null, (Object)string3, (String)ListenerArb.getString("NOSQL_DELETE_STORE_TITLE"), null);
        if (bl) {
            File file = NoSQLUtils.getStoreDirFile(string, string2);
            if (file != null && file.exists()) {
                try {
                    ListenerUtils.delete(file);
                }
                catch (Exception exception) {
                    Logger.warn(this.getClass(), (String)exception.getLocalizedMessage());
                    MessageDialog.error(null, (Object)exception.getLocalizedMessage(), (String)ListenerArb.format("ERROR_TITLE", ListenerArb.getString("NOSQL_DELETE_STORE_TITLE")), null);
                }
            } else {
                Logger.warn(this.getClass(), (String)("Store does not exist parentPath: " + string + " storeName: " + string2));
            }
            ListenerPanel.getInstance().deleteNoSQLStore(n);
            ListenerImportAdmin.getInstance().deleteNoSQLStoresProperties(string2);
            return true;
        }
        return false;
    }
}

