/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.conn;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.http.SessionManager;
import oracle.dbtools.http.SessionType;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.connection.listener.ListenerConnectionType;
import oracle.dbtools.raptor.cloud.connection.rest.RestConnectionType;
import oracle.dbtools.raptor.cloud.connection.ui.ConnectionEditor;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.controls.SortedListModel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public abstract class ManageConnectionsPanel
implements ActionListener {
    private static final String ADD_CMD = "Add";
    private static final String EDIT_CMD = "Edit";
    private static final String REMOVE_CMD = "Remove";
    private SessionManager mConnMgr;
    private Component mPanel;
    private DefaultListModel<String> mConns = new SortedListModel();
    private JList<String> mListConns = new JList<String>(this.mConns);
    private JButton mBtnAdd = new JButton();
    private JButton mBtnEdit = new JButton();
    private JButton mBtnRemove = new JButton();

    static ManageConnectionsPanel createAdminPanel() {
        ManageConnectionsPanel manageConnectionsPanel = new ManageConnectionsPanel(){

            @Override
            protected String getTabLabel() {
                return ListenerArb.getString("TAB_MANAGE_ADMIN");
            }

            @Override
            protected SessionType getConnectionType() {
                return ListenerConnectionType.getInstance();
            }
        };
        super.loadConnections();
        return manageConnectionsPanel;
    }

    static ManageConnectionsPanel createDeveloperPanel() {
        ManageConnectionsPanel manageConnectionsPanel = new ManageConnectionsPanel(){

            @Override
            protected String getTabLabel() {
                return ListenerArb.getString("TAB_MANAGE_DEV");
            }

            @Override
            protected SessionType getConnectionType() {
                return RestConnectionType.getInstance();
            }
        };
        super.loadConnections();
        return manageConnectionsPanel;
    }

    public final Component getPanel() {
        if (this.mPanel == null) {
            this.mPanel = LayoutControl.GBC.createTabPanel((Component)this.createPanel());
        }
        return this.mPanel;
    }

    protected Component createPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, this.mListConns, (String)ListenerArb.getString("LABEL_MANAGE_CONNECTIONS"));
        JScrollPane jScrollPane = new JScrollPane(this.mListConns);
        this.mListConns.setVisibleRowCount(5);
        this.mListConns.setSelectionMode(0);
        this.mListConns.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ManageConnectionsPanel.this.checkButtonState();
            }
        });
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel.add((Component)jScrollPane, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)4, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        this.mBtnAdd.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.mBtnAdd.setActionCommand(ADD_CMD);
        this.mBtnAdd.addActionListener(this);
        this.mBtnAdd.setMnemonic(StringUtils.getMnemonicKeyCode((String)ListenerArb.getString("BUTTON_ADD_CONNECTION_LABEL")));
        this.mBtnAdd.setToolTipText(ListenerArb.getString("BUTTON_ADD_CONNECTION_TOOLTIP"));
        jPanel.add((Component)this.mBtnAdd, LayoutControl.GBC.gbc((int)1, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
        this.mBtnEdit.setIcon(OracleIcons.getIcon((String)"edit.png"));
        this.mBtnEdit.setActionCommand(EDIT_CMD);
        this.mBtnEdit.addActionListener(this);
        this.mBtnEdit.setMnemonic(StringUtils.getMnemonicKeyCode((String)ListenerArb.getString("BUTTON_EDIT_CONNECTION_LABEL")));
        this.mBtnEdit.setToolTipText(ListenerArb.getString("BUTTON_EDIT_CONNECTION_TOOLTIP"));
        jPanel.add((Component)this.mBtnEdit, LayoutControl.GBC.gbc((int)1, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
        this.mBtnRemove.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this.mBtnRemove.setActionCommand(REMOVE_CMD);
        this.mBtnRemove.addActionListener(this);
        this.mBtnRemove.setMnemonic(StringUtils.getMnemonicKeyCode((String)ListenerArb.getString("BUTTON_REMOVE_CONNECTION_LABEL")));
        this.mBtnRemove.setToolTipText(ListenerArb.getString("BUTTON_REMOVE_CONNECTION_TOOLTIP"));
        jPanel.add((Component)this.mBtnRemove, LayoutControl.GBC.gbc((int)1, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
        return jPanel;
    }

    protected final SessionManager getConnectionManager() {
        if (this.mConnMgr == null) {
            this.mConnMgr = CConnections.getInstance((SessionType)this.getConnectionType());
        }
        return this.mConnMgr;
    }

    private final void loadConnections() {
        String[] stringArray;
        this.checkButtonState();
        SessionManager sessionManager = this.getConnectionManager();
        for (String string : stringArray = sessionManager.listConnections()) {
            this.mConns.addElement(string);
        }
    }

    private void checkButtonState() {
        boolean bl = !this.mListConns.isSelectionEmpty();
        this.mBtnEdit.setEnabled(bl);
        this.mBtnRemove.setEnabled(bl);
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        String string;
        String string2;
        String string3 = actionEvent.getActionCommand();
        if (ADD_CMD.equals(string3)) {
            String string4 = ConnectionEditor.getInstance().createConnection(this.getConnectionType());
            if (string4 != null) {
                this.mConns.addElement(string4);
                this.mListConns.setSelectedValue(string4, true);
            }
        } else if (EDIT_CMD.equals(string3)) {
            String string5;
            String string6 = this.mListConns.getSelectedValue();
            if (string6 != null && (string5 = ConnectionEditor.getInstance().editConnection(string6, this.getConnectionType())) != null && ModelUtil.areDifferent((Object)string6, (Object)string5)) {
                this.mConns.removeElement(string6);
                this.mConns.addElement(string5);
                this.mListConns.setSelectedValue(string5, true);
            }
        } else if (REMOVE_CMD.equals(string3) && (string2 = this.mListConns.getSelectedValue()) != null && MessageDialog.confirm(null, (Object)(string = DatabaseNavigatorResources.format((String)"MGR_CONFIRM_DEL", (Object[])new Object[]{string2})), (String)DatabaseNavigatorResources.getString((String)"MGR_CONFIRM_TITLE"), null, (boolean)true)) {
            this.mConnMgr.removeConnection(string2);
            this.mConns.removeElement(string2);
        }
    }

    protected abstract String getTabLabel();

    protected abstract SessionType getConnectionType();

    public Component getDefaultComponent() {
        return this.mListConns;
    }
}

