/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator.delete.model;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.model.ApplicationContent;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLPath;
import oracle.ideimpl.navigator.delete.model.FileSystemModelUtils;

public class WorkspaceModel {
    final ApplicationContent m_applicationContent;
    final Workspace m_workspace;
    final List<Project> m_projects;
    final File m_workspaceBaseFile;
    final ContentSet m_allContents;
    final URLPath m_contentRootDirs;

    public WorkspaceModel(Workspace workspace) {
        this.m_workspace = workspace;
        this.m_applicationContent = ApplicationContent.getInstance(workspace);
        this.m_workspaceBaseFile = new File(FileSystemModelUtils.urlToFile(this.m_workspace.getURL()).getParent());
        this.m_projects = new ArrayList<Project>(this.m_workspace.projects());
        this.m_allContents = this.m_applicationContent.getAllContents();
        this.m_contentRootDirs = this.m_allContents.getAllRootDirs();
    }

    public Workspace getWorkspace() {
        return this.m_workspace;
    }

    public List<Project> getProjects() {
        return this.m_projects;
    }

    public File getWorkspaceBaseDirectory() {
        return this.m_workspaceBaseFile;
    }

    public ContentSet getAllContents() {
        return this.m_allContents;
    }

    public URLPath getContentRootDirectories() {
        return this.m_contentRootDirs;
    }

    public List<File> getContentRootsOutsideWorkspaceRoot() {
        ArrayList<File> outsideRoots = new ArrayList<File>();
        for (URL sourceRootDirectoryURL : this.m_contentRootDirs) {
            File f = FileSystemModelUtils.urlToFile(sourceRootDirectoryURL);
            if (this.isFileInWorkspaceRoot(f)) continue;
            outsideRoots.add(f);
        }
        return outsideRoots;
    }

    public boolean isFileInWorkspaceRoot(File file) {
        return WorkspaceModel.isFileInWorkspaceRoot(this.m_workspaceBaseFile, file);
    }

    private static boolean isFileInWorkspaceRoot(File workspaceRoot, File file) {
        return file.getPath().startsWith(workspaceRoot.getPath());
    }
}

