/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198.editor;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ide.editor.spi.EditorHook;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ideimpl.jsr198.editor.EditorAdapter;
import oracle.ideimpl.jsr198.editor.JavaxIdeEditor;
import oracle.ideimpl.jsr198.editor.JavaxIdeEditorAddin;
import oracle.ideimpl.jsr198.model.ContextFactory;

public class OracleEditorManager
extends javax.ide.editor.EditorManager {
    public final javax.ide.editor.Editor getActiveEditor() {
        if (EventQueue.isDispatchThread()) {
            Editor oideEditor = this.getOracleManager().getCurrentEditor();
            return this.getJavaxIdeEditor(oideEditor);
        }
        GetCurrentEditorRunnable r = new GetCurrentEditorRunnable();
        try {
            EventQueue.invokeAndWait(r);
        }
        catch (Exception ie) {
            return null;
        }
        if (r.editor == null) {
            return null;
        }
        return this.getJavaxIdeEditor(r.editor);
    }

    private EditorManager getOracleManager() {
        return EditorManager.getEditorManager();
    }

    private void dispach(Runnable r) {
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (InterruptedException e) {
                return;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public final Set getAllOpenEditors() {
        class GetAllEditors
        implements Runnable {
            List oracleEditors;

            GetAllEditors() {
            }

            @Override
            public void run() {
                this.oracleEditors = OracleEditorManager.this.getOracleManager().getAllEditors();
            }
        }
        GetAllEditors e = new GetAllEditors();
        this.dispach(e);
        List oracleEditors = e.oracleEditors;
        HashSet<javax.ide.editor.Editor> allEditors = new HashSet<javax.ide.editor.Editor>(oracleEditors.size());
        Iterator i = oracleEditors.iterator();
        while (i.hasNext()) {
            allEditors.add(this.getJavaxIdeEditor((Editor)i.next()));
        }
        return Collections.unmodifiableSet(allEditors);
    }

    public final javax.ide.editor.Editor openEditor(final javax.ide.command.Context context, String typeID) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Context ideContext = ContextFactory.createOracleContext(context);
                OracleEditorManager.this.getOracleManager().openDefaultEditorInFrame(ideContext);
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (InterruptedException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return this.getActiveEditor();
    }

    public final void closeEditor(javax.ide.editor.Editor editor) {
        if (editor == null) {
            throw new NullPointerException("editor is null");
        }
        final Editor ideEditor = this.getOracleEditor(editor);
        if (ideEditor == null) {
            throw new IllegalArgumentException("Cannot find editor " + editor);
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                OracleEditorManager.this.getOracleManager().closeEditors(Collections.singletonList(ideEditor));
            }
        };
        this.dispach(r);
    }

    protected final void initialize() {
        super.initialize();
        this.getOracleManager().addEditorListener(new EditorListener(){

            @Override
            public void editorOpened(Editor oideEditor) {
                OracleEditorManager.this.fireEditorOpened(OracleEditorManager.this.getJavaxIdeEditor(oideEditor));
            }

            @Override
            public void editorActivated(Editor oideEditor) {
                OracleEditorManager.this.fireEditorActivated(OracleEditorManager.this.getJavaxIdeEditor(oideEditor));
            }

            @Override
            public void editorDeactivated(Editor oideEditor) {
                OracleEditorManager.this.fireEditorDeactivated(OracleEditorManager.this.getJavaxIdeEditor(oideEditor));
            }

            @Override
            public void editorClosed(Editor oideEditor) {
                OracleEditorManager.this.fireEditorClosed(OracleEditorManager.this.getJavaxIdeEditor(oideEditor));
            }
        });
        EditorHook editorHook = (EditorHook)ExtensionRegistry.getExtensionRegistry().getHook(EditorHook.ELEMENT);
        Collection editors = editorHook.getEditors();
        for (MetaClass editor : editors) {
            this.getOracleManager().registerDynamic(new JavaxIdeEditorAddin(editor));
        }
    }

    protected javax.ide.editor.Editor getJavaxIdeEditor(Editor oideEditor) {
        if (oideEditor instanceof JavaxIdeEditor) {
            return ((JavaxIdeEditor)oideEditor).getJavaxIdeEditor();
        }
        return new EditorAdapter(oideEditor);
    }

    protected Editor getOracleEditor(javax.ide.editor.Editor javaxEditor) {
        if (javaxEditor instanceof EditorAdapter) {
            return ((EditorAdapter)javaxEditor).getOracleEditor();
        }
        return null;
    }

    private class GetCurrentEditorRunnable
    implements Runnable {
        private Editor editor;

        private GetCurrentEditorRunnable() {
        }

        @Override
        public void run() {
            this.editor = OracleEditorManager.this.getOracleManager().getCurrentEditor();
        }
    }
}

