/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.help;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.help.AboutTablePage;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.util.Pair;

public final class AboutVersionPage
extends AboutTablePage {
    private static final String DEPINFO = "oracle/ide/depinfo.txt";
    private static final String PRODUCT_SCHEMA = "product_schema";
    private static final String LABEL = "label";
    private Map<String, String> _scratchMap;

    public AboutVersionPage() {
        this.setName(IdeImplArb.getString(89));
    }

    @Override
    protected TableModel buildTableModel() {
        Vector data = new Vector(10);
        Vector<String> colNames = new Vector<String>(2);
        colNames.add(IdeImplArb.getString(85));
        colNames.add(IdeImplArb.getString(86));
        this.addVersionInfo(data);
        if (Version.DEBUG_BUILD != 0 || Boolean.valueOf(System.getProperty("ide.about.version.showAll")).booleanValue()) {
            this.addDepencencyVersionInfo(data);
        }
        return new GenericBaseTableModel(data, colNames){};
    }

    private void addVersionInfo(Vector data) {
        Vector<Object> row = new Vector<Object>(2);
        row.add(IdeImplArb.getString(87));
        row.add(Version.VER_FULL);
        data.add(row);
        row = new Vector(2);
        row.add(IdeImplArb.getString(88));
        row.add(System.getProperty("java.version"));
        data.add(row);
        Iterator iter = Ide.getVersionInfo().getVersionPairs();
        while (iter.hasNext()) {
            Pair cv = (Pair)iter.next();
            row = new Vector(2);
            row.add(cv.first);
            row.add(cv.second);
            data.add(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDepencencyVersionInfo(Vector data) {
        URL parentOfJewt;
        this._scratchMap = new HashMap<String, String>();
        BufferedReader br = null;
        try {
            InputStream depStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(DEPINFO);
            if (depStream != null) {
                String labels;
                HashMap<String, String> labelsBySchema = new HashMap<String, String>();
                br = new BufferedReader(new InputStreamReader(depStream));
                String line = br.readLine();
                while (line != null) {
                    Map lineMap = this.getLineMap(line);
                    String string = (String)lineMap.get(PRODUCT_SCHEMA);
                    String label = (String)lineMap.get(LABEL);
                    labels = (String)labelsBySchema.get(string);
                    if (labels == null) {
                        labelsBySchema.put(string, label);
                    } else {
                        labelsBySchema.put(string, labels + ", " + label);
                    }
                    line = br.readLine();
                }
                for (Map.Entry entry : labelsBySchema.entrySet()) {
                    String schema = (String)entry.getKey();
                    labels = (String)entry.getValue();
                    if (schema == null || schema.trim().length() <= 0) continue;
                    Vector<String> v = new Vector<String>(2);
                    v.add("Build: " + schema);
                    v.add(labels);
                    data.add(v);
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            this._scratchMap = null;
        }
        URL jewtRes = Thread.currentThread().getContextClassLoader().getResource("oracle/bali/ewt/LookAndFeel.class");
        if (jewtRes != null && (parentOfJewt = URLFileSystem.getParent((URL)jewtRes)) != null) {
            URL[] urls = URLFileSystem.list((URL)parentOfJewt);
            for (int i = 0; i < urls.length; ++i) {
                URL uRL = urls[i];
                String name = URLFileSystem.getName((URL)uRL);
                if (name == null || name.indexOf(95) <= 0) continue;
                Vector<String> v = new Vector<String>();
                v.add("Build: (JEWT)");
                v.add(name.replace('_', '.'));
                data.add(v);
                break;
            }
        }
    }

    private Map getLineMap(String line) {
        String[] tokens;
        if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
            return Collections.EMPTY_MAP;
        }
        this._scratchMap.clear();
        for (String token : tokens = line.split(";")) {
            int eqPos = token.indexOf(61);
            if (eqPos <= 0) continue;
            String name = token.substring(0, eqPos).trim();
            String value = token.substring(eqPos + 1).trim();
            this._scratchMap.put(name, value);
        }
        return this._scratchMap;
    }
}

