/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.rules;

import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import oracle.ide.extension.rules.Rule;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.extension.rules.RuleFunctionParameter;
import oracle.ide.extension.rules.RuleType;
import oracle.ide.extension.rules.RuleTypeParameter;
import oracle.ide.extension.rules.SimpleRule;

public class RuleVisitor
extends ElementVisitor {
    public static final ElementName RULE_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "rule");
    public static final ElementName PARAMETERS_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "parameters");
    public static final ElementName PARAM_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "param");
    public static final String ID_ATTR = "id";
    public static final String NAME_ATTR = "name";
    public static final String VALUE_ATTR = "value";
    public static final String TYPE_ATTR = "type";
    private static final String _KEY_RULE = "key-ide-extension-rule";
    private final ElementVisitor _parametersVisitor = new ParametersVisitor();
    private final ElementVisitor _paramVisitor = new ParamVisitor();

    public void start(ElementStartContext context) {
        String id = this.getAttributeHelper(context, ID_ATTR, true, true);
        String typeId = this.getAttributeHelper(context, TYPE_ATTR, true, true);
        if (id != null && typeId != null) {
            RuleEngine ruleEngine = RuleEngine.getInstance();
            RuleType type = ruleEngine.getRuleType(typeId);
            if (type == null) {
                this.log((ElementContext)context, Level.SEVERE, "'" + typeId + "' is an unknown rule-type.  The value of the type attribute must match the id of a registered rule-type.");
                return;
            }
            Extension extension = (Extension)context.getScopeData().get("extension");
            SimpleRule rule = new SimpleRule(id, extension, type);
            context.getScopeData().put(_KEY_RULE, rule);
            context.registerChildVisitor(PARAMETERS_ELEMENT, this._parametersVisitor);
        }
    }

    public void end(ElementEndContext context) {
        SimpleRule rule = (SimpleRule)context.getScopeData().get(_KEY_RULE);
        if (rule != null) {
            RuleType type = rule.getType();
            for (RuleTypeParameter param : type.getSupportedParameters()) {
                if (!param.isRequired() || rule.hasParameter(param.getName())) continue;
                this.log((ElementContext)context, Level.SEVERE, "Rule '" + rule.getId() + "' is missing required parameter '" + param.getName() + "' and will not be registered");
                return;
            }
            RuleEngine engine = RuleEngine.getInstance();
            boolean registered = engine.registerRule(rule);
            if (!registered) {
                Rule duplicate = engine.getRule(rule.getId());
                this.log((ElementContext)context, Level.SEVERE, "Duplicate rule id encountered.  The id '" + rule.getId() + "' is already registered in extension: " + duplicate.getExtension().getID());
            }
        }
    }

    private class ParamVisitor
    extends ElementVisitor {
        private ParamVisitor() {
        }

        public void start(ElementStartContext context) {
            String name = this.getAttributeHelper(context, RuleVisitor.NAME_ATTR, true, true);
            String value = this.getAttributeHelper(context, RuleVisitor.VALUE_ATTR, true, true);
            if (name != null && value != null) {
                RuleFunctionParameter param = new RuleFunctionParameter(name, value);
                SimpleRule rule = (SimpleRule)context.getScopeData().get(RuleVisitor._KEY_RULE);
                RuleType type = rule.getType();
                if (type.isParameterSupported(name)) {
                    boolean added = rule.addParameter(param);
                    if (!added) {
                        this.log((ElementContext)context, Level.SEVERE, "Duplicate parameter encountered.  A parameter with the name '" + param.getName() + "' is already specified on rule: " + rule.getId());
                    }
                } else {
                    this.log((ElementContext)context, Level.SEVERE, "Unsupported parameter: '" + name + "'. No parameter with that name is defined for rule type: " + type.getId());
                }
            }
        }
    }

    private class ParametersVisitor
    extends ElementVisitor {
        private ParametersVisitor() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(PARAM_ELEMENT, RuleVisitor.this._paramVisitor);
        }
    }
}

