/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.macros;

import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ide.extension.ElementContext;
import javax.ide.extension.spi.ExtensionLogRecord;
import oracle.ide.extension.macros.ExtensionMacroByPrefix;
import org.openide.util.NbBundle;

public class NbBundleExtensionMacro
extends ExtensionMacroByPrefix {
    private static final String NBBUNDLE = "NbBundle:";
    private static final String URL_PATTERN = "([^#]*)#(.*)";
    private static final Pattern pat = Pattern.compile("([^#]*)#(.*)");

    @Override
    public String getPrefix() {
        return NBBUNDLE;
    }

    @Override
    public String expandMacro(String unexpandedMacro, ElementContext elementContext) {
        String bundle = unexpandedMacro.substring(NBBUNDLE.length());
        String result = null;
        try {
            Matcher m = pat.matcher(bundle);
            if (m.matches() && m.groupCount() == 2) {
                String clazz = m.group(1);
                String key = m.group(2);
                result = NbBundle.getBundle((String)clazz).getString(key);
            }
        }
        catch (MissingResourceException e) {
            ExtensionLogRecord record = new ExtensionLogRecord(elementContext, Level.SEVERE, "An exception occurred retrieving NbBundle " + bundle);
            record.setThrown(e);
            elementContext.getLogger().log((LogRecord)record);
        }
        if (result == null) {
            ExtensionLogRecord record = new ExtensionLogRecord(elementContext, Level.SEVERE, "An error occurred retrieving NbBundle " + bundle);
            elementContext.getLogger().log((LogRecord)record);
        }
        return result;
    }
}

