/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import oracle.ide.Addin;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.RoleManager;
import oracle.ide.extension.feature.Feature;
import oracle.ideimpl.extension.DisabledReason;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import oracle.ideimpl.extension.feature.FeatureRegistryImpl;

final class WarnAboutDisabledExtensionsAddin
implements Addin {
    private static final Logger _sLogger = Logger.getLogger(WarnAboutDisabledExtensionsAddin.class.getName());

    WarnAboutDisabledExtensionsAddin() {
    }

    @Override
    public void initialize() {
        RoleManager roleManager = ExtensionRegistry.getExtensionRegistry().getRoleManager();
        if (roleManager.isDefaultRoleActive()) {
            this._logDisabledExtensions();
        }
    }

    private void _logDisabledExtensions() {
        ExtensionManagerImpl registry = (ExtensionManagerImpl)ExtensionRegistry.getExtensionRegistry();
        Collection<String> disabledIds = registry.getDisabledExtensions();
        for (String id : disabledIds) {
            DisabledReason reason;
            if (!this._shouldReportError(registry, id, reason = registry.getDisabledReason(id))) continue;
            StringBuffer message = new StringBuffer();
            message.append("Extension ");
            message.append(id);
            message.append(" is disabled.  Reason: ");
            message.append((Object)reason);
            _sLogger.log(Level.WARNING, message.toString());
        }
    }

    private boolean _shouldReportError(ExtensionRegistry registry, String extensionId, DisabledReason reason) {
        if (DisabledReason.ERROR.equals((Object)reason)) {
            return true;
        }
        if (DisabledReason.MISSING_DEPENDENCIES.equals((Object)reason)) {
            Extension minimalExtension = registry.findMinimalExtension(extensionId);
            FeatureRegistryImpl featureRegistry = (FeatureRegistryImpl)registry.getFeatureRegistry();
            Set<Feature> upstreamFeatures = featureRegistry._getFeaturesInDependencyTree(minimalExtension, registry);
            for (Feature feature : upstreamFeatures) {
                if (feature.isEnabled() || !DisabledReason.USER_DISABLED.equals((Object)feature.getDisabledReason())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

