/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.awt.BorderLayout;
import java.util.ArrayList;
import oracle.ide.ExtensionRegistry;
import oracle.ide.config.IdeSettings;
import oracle.ide.extension.Role;
import oracle.ide.extension.RoleManager;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ideimpl.extension.RoleManagerImpl;
import oracle.ideimpl.extension.RoleSelectionPanel;

public final class RolePreferencePage
extends DefaultTraversablePanel
implements ApplyListener {
    private RoleSelectionPanel _panel = new RoleSelectionPanel();
    private boolean _onEntryCheckbox;
    private String _onEntryRole;
    private boolean _init = false;

    RolePreferencePage() {
        this.setLayout(new BorderLayout());
        this.add(this._panel, "Center");
    }

    public void onEntry(TraversableContext dataContext) {
        super.onEntry(dataContext);
        if (!this._init) {
            this._init = true;
            RoleManagerImpl roleManager = (RoleManagerImpl)ExtensionRegistry.getExtensionRegistry().getRoleManager();
            ArrayList<Role> allRoles = new ArrayList<Role>();
            allRoles.add(RoleManager.NO_ROLE);
            allRoles.addAll(roleManager.getRoles());
            this._panel.setRoles(allRoles);
            this._panel.setSelectedRole(roleManager.getRolePreferences().getSelectedRoleId());
            this._panel.setSelectOnStartupChecked(roleManager.getRolePreferences().isStartupRoleUIEnabled());
            this._onEntryCheckbox = this._panel.isSelectOnStartupChecked();
            this._onEntryRole = this._panel.getSelectedRole().getId();
        }
    }

    public void onExit(TraversableContext context) {
        if (this._onEntryCheckbox != this._panel.isSelectOnStartupChecked() || !this._onEntryRole.equals(this._panel.getSelectedRole().getId())) {
            IdeSettings settings = (IdeSettings)context.find("ide-options");
            settings.setAskExit(true);
        }
    }

    public void apply(ApplyEvent e) {
        RoleManagerImpl roleManager = (RoleManagerImpl)ExtensionRegistry.getExtensionRegistry().getRoleManager();
        roleManager.getRolePreferences().setSelectedRoleId(this._panel.getSelectedRole().getId());
        roleManager.getRolePreferences().setStartupRoleUIEnabled(this._panel.isSelectOnStartupChecked());
        roleManager.saveRolePreferences();
    }

    public void cancel(ApplyEvent e) {
    }

    public String getHelpID() {
        return "f1_idedrolepreferences_html";
    }
}

