/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.SAXManifestParser;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ide.performance.PerformanceLogger;
import oracle.ideimpl.extension.LayerBuilder;
import oracle.ideimpl.extension.LayerCache;
import oracle.ideimpl.extension.LayerVisitorExtensions;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class LayerCacheSupport {
    static final String DEBUG_FOLDER = System.getProperty("oracle.ideimpl.extension.debug.dump");
    private static final Logger LOG = Logger.getLogger(LayerCacheSupport.class.getName());

    LayerCacheSupport() {
    }

    static void initCache(LayerCache layerCache, Collection<ExtensionSource> sources, Logger logger) {
        PerformanceLogger.get().startTiming(LayerCacheSupport.class.getName() + ".XmlProcessing");
        Map<String, byte[]> layers = LayerCacheSupport.getLayers(sources, logger);
        ArrayList<LayerCache.ExtXmlBuffer> buffs = new ArrayList<LayerCache.ExtXmlBuffer>(layers.size());
        for (Map.Entry<String, byte[]> entry : layers.entrySet()) {
            buffs.add(new ExtXmlBufferImpl(entry.getKey(), entry.getValue()));
        }
        PerformanceLogger.get().stopTiming(LayerCacheSupport.class.getName() + ".XmlProcessing", " xml processing");
        PerformanceLogger.get().startTiming(LayerCacheSupport.class.getName() + ".StoreLayers");
        layerCache.init(buffs);
        PerformanceLogger.get().stopTiming(LayerCacheSupport.class.getName() + ".StoreLayers", " storing layers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, byte[]> getLayers(Collection<ExtensionSource> sources, Logger logger) {
        HashMap<String, byte[]> buffs = new HashMap<String, byte[]>();
        LayerCache.TIMERS.reset();
        int position = 0;
        for (ExtensionSource es : sources) {
            PlainElementContext context = new PlainElementContext();
            SAXManifestParser parser = new SAXManifestParser((DefaultElementContext)context);
            LayerVisitorExtensions visitor = new LayerVisitorExtensions(es, position++);
            parser.getContext().registerChildVisitor(LayerVisitorExtensions.ELEMENT, (ElementVisitor)visitor);
            LayerBuilder builder = new LayerBuilder();
            parser.getContext().getScopeData().put("layer-builder", builder);
            if (parser.getContext() instanceof DefaultElementContext) {
                ((DefaultElementContext)parser.getContext()).setMessageReporter(logger);
            }
            InputStream inStream = null;
            try {
                URI uri = es.getManifestURI();
                inStream = es.getInputStream();
                InputSource inSource = new InputSource(inStream);
                inSource.setSystemId(uri.toString());
                parser.parse(inSource);
                byte[] content = builder.getBytes();
                buffs.put(visitor.getExtensionId(), content);
                if (DEBUG_FOLDER == null) continue;
                LayerCacheSupport.dumpLayer(content, visitor.getExtensionId());
            }
            catch (IOException ioe) {
                LOG.log(Level.SEVERE, "Error loading manifest from " + es.getName() + ioe);
            }
            catch (ParserConfigurationException pce) {
                throw new IllegalStateException("Badly configured jaxb");
            }
            catch (SAXException saxe) {
                LOG.log(Level.SEVERE, "Failed to parse manifest from " + es.getName() + saxe);
            }
            catch (RuntimeException re) {
                LOG.log(Level.SEVERE, "RuntimeException parsing manifest from " + es.getName() + ": " + re);
            }
            finally {
                try {
                    if (inStream == null) continue;
                    inStream.close();
                }
                catch (IOException ioe) {
                    LOG.log(Level.SEVERE, "Error closing stream for " + es.getName() + ioe);
                }
            }
        }
        LayerCache.TIMERS.print();
        return buffs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dumpLayer(byte[] content, String name) {
        if (DEBUG_FOLDER != null) {
            File f = new File(new File(DEBUG_FOLDER), name);
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(f);
                ((OutputStream)os).write(content);
                os.flush();
            }
            catch (FileNotFoundException ex) {
                LOG.log(Level.WARNING, "Cannot dump to " + f.getPath(), ex);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Cannot dump to " + f.getPath(), ex);
            }
            finally {
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException ex) {
                        LOG.log(Level.WARNING, "Cannot close stream " + f.getPath(), ex);
                    }
                }
            }
        }
    }

    static class RealTimers
    implements LayerCache.Timers {
        private static Map<String, long[]> nanoMeter = new TreeMap<String, long[]>();
        private static Map<String, long[]> countMeter = new TreeMap<String, long[]>();

        RealTimers() {
        }

        @Override
        public long nanoTime() {
            return System.nanoTime();
        }

        @Override
        public void reset() {
            nanoMeter.clear();
            countMeter.clear();
        }

        @Override
        public void addNanos(String name, long nanos) {
            long[] ar = nanoMeter.get(name);
            if (ar == null) {
                ar = new long[]{0L};
                nanoMeter.put(name, ar);
            }
            ar[0] = ar[0] + nanos;
        }

        @Override
        public void addCurrentNanos(String name, long subtract) {
            this.addNanos(name, this.nanoTime() - subtract);
        }

        @Override
        public void incCount(String name) {
            long[] ar = countMeter.get(name);
            if (ar == null) {
                ar = new long[]{0L};
                countMeter.put(name, ar);
            }
            ar[0] = ar[0] + 1L;
        }

        @Override
        public void print() {
            for (Map.Entry<String, long[]> e : nanoMeter.entrySet()) {
                System.out.println(">> TIME  >> " + e.getKey() + " : " + (double)e.getValue()[0] / 1000000.0 + "[mS]");
            }
            for (Map.Entry<String, long[]> e : countMeter.entrySet()) {
                System.out.println(">> COUNT >> " + e.getKey() + " : " + e.getValue()[0]);
            }
        }
    }

    static class NullTimers
    implements LayerCache.Timers {
        NullTimers() {
        }

        @Override
        public long nanoTime() {
            return 0L;
        }

        @Override
        public void reset() {
        }

        @Override
        public void addNanos(String name, long nanos) {
        }

        @Override
        public void addCurrentNanos(String name, long subtract) {
        }

        @Override
        public void incCount(String name) {
        }

        @Override
        public void print() {
        }
    }

    private static class ExtXmlBufferImpl
    implements LayerCache.ExtXmlBuffer {
        private String id;
        private byte[] content;

        public ExtXmlBufferImpl(String id, byte[] content) {
            this.id = id;
            this.content = content;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public byte[] getContent() {
            return this.content;
        }
    }

    private static class PlainElementContext
    extends DefaultElementContext {
        private PlainElementContext() {
        }

        protected String processText(String text) {
            return text;
        }
    }
}

