/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.BaseExtensionVisitor;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.MinimalExtensionVisitor;
import oracle.ide.extension.ExtensionClassLoaderProvider;
import oracle.ideimpl.extension.TriggerHooksVisitor;
import oracle.ideimpl.extension.feature.FeatureCategoryVisitor;
import oracle.ideimpl.extension.feature.FeatureMemberVisitor;
import oracle.ideimpl.extension.feature.FeatureVisitor;

public class IDEMinimalExtensionVisitor
extends MinimalExtensionVisitor {
    private final FeatureVisitor _featureVisitor = new FeatureVisitor();
    private final FeatureCategoryVisitor _featureCategoryVisitor = new FeatureCategoryVisitor();
    private final FeatureMemberVisitor _featureMemberVisitor = new FeatureMemberVisitor();
    private final InterruptVisitor _interruptVisitor = new InterruptVisitor();
    private final ExtensionClassLoaderProvider _loaderProvider;

    public IDEMinimalExtensionVisitor() {
        this(null);
    }

    public IDEMinimalExtensionVisitor(ExtensionClassLoaderProvider loaderProvider) {
        this._loaderProvider = loaderProvider;
    }

    protected DefaultExtension processExtension(ElementStartContext context) {
        DefaultExtension extension = super.processExtension(context);
        if (extension != null) {
            if (this._loaderProvider != null) {
                context.getScopeData().put("classLoader", this._loaderProvider.findOrCreateLoader((Extension)extension));
                String rsbundleClass = this.getAttributeHelper(context, "rsbundle-class", true, false);
                if (rsbundleClass != null) {
                    context.getScopeData().put("rsbundleclass", rsbundleClass);
                }
            } else {
                context.getScopeData().put("rsbundleclass", "intentional-ignore");
            }
            context.registerChildVisitor(FeatureVisitor.FEATURE_ELEMENT, (ElementVisitor)this._featureVisitor);
            context.registerChildVisitor(FeatureCategoryVisitor.FEATURE_CATEGORY_ELEMENT, (ElementVisitor)this._featureCategoryVisitor);
            context.registerChildVisitor(FeatureMemberVisitor.FEATURE_MEMBER_ELEMENT, (ElementVisitor)this._featureMemberVisitor);
            context.registerChildVisitor(TriggerHooksVisitor.ELEMENT, (ElementVisitor)this._interruptVisitor);
            context.registerChildVisitor(BaseExtensionVisitor.HOOKS, (ElementVisitor)this._interruptVisitor);
        }
        return extension;
    }

    private static class InterruptVisitor
    extends ElementVisitor {
        private InterruptVisitor() {
        }

        public void start(ElementStartContext context) {
            context.getScopeData().put("oracle.ide.parse.interrupt", true);
        }

        public void end(ElementEndContext context) {
        }
    }
}

