/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import javax.ide.extension.Extension;
import oracle.ideimpl.extension.IDEExtension;

public final class AddinInfo
implements Comparable {
    private final ClassLoader _classLoader;
    private final String _className;
    private final String _loadSet;
    private long _timeToLoad;
    private int _manifestLineNumber;
    private boolean _loaded;
    private long _classesLoaded;
    private boolean _hasUI = true;
    private Extension _extension;
    private boolean _productSpecific = false;

    public AddinInfo(ClassLoader loader, String className) {
        this._classLoader = loader;
        this._className = className;
        this._loadSet = null;
    }

    public AddinInfo(ClassLoader loader, String className, String loadSet) {
        this(loader, className, loadSet, 0);
    }

    AddinInfo(ClassLoader loader, String className, String loadSet, int lineNumber) {
        this._classLoader = loader;
        this._className = className;
        this._loadSet = loadSet;
        this._manifestLineNumber = lineNumber;
        this._hasUI = true;
    }

    void setProductSpecific(boolean productSpecific) {
        this._productSpecific = productSpecific;
    }

    public boolean isProductSpecific() {
        return this._productSpecific;
    }

    void setExtension(Extension extension) {
        this._extension = extension;
    }

    public Extension getExtension() {
        return this._extension;
    }

    void setHasUI(boolean hasUI) {
        this._hasUI = hasUI;
    }

    public boolean hasUI() {
        return this._hasUI;
    }

    void setClassesLoaded(long classesLoaded) {
        this._classesLoaded = classesLoaded;
    }

    long getClassesLoaded() {
        return this._classesLoaded;
    }

    void setManifestLineNumber(int lineNumber) {
        this._manifestLineNumber = lineNumber;
    }

    public int getManifestLineNumber() {
        return this._manifestLineNumber;
    }

    void addTimeToLoad(long timeToLoad) {
        this._timeToLoad += timeToLoad;
        if (this._extension instanceof IDEExtension) {
            ((IDEExtension)this._extension).addInitTime(timeToLoad);
        }
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    long getTimeToLoad() {
        return this._timeToLoad;
    }

    public String getClassName() {
        return this._className;
    }

    public String getLoadSet() {
        return this._loadSet;
    }

    public int hashCode() {
        int code = 42;
        code = 37 * code + this._className.hashCode();
        if (this._loadSet != null) {
            code = 37 * code + this._loadSet.hashCode();
        }
        return code;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddinInfo)) {
            return false;
        }
        AddinInfo that = (AddinInfo)o;
        if (!that._className.equals(this._className)) {
            return false;
        }
        return (that._loadSet != null || this._loadSet == null) && (that._loadSet == null || that._loadSet.equals(this._loadSet));
    }

    public void setLoaded(boolean isLoaded) {
        this._loaded = isLoaded;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public String toString() {
        return AddinInfo.class.getName() + "[" + "_className=" + this._className + ", " + "_loadSet=" + String.valueOf(this._loadSet) + "]";
    }

    public int compareTo(Object o) {
        return this._className.compareTo(((AddinInfo)o)._className);
    }
}

