/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorsOptions;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.editor.RecentFile;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.DialogsArb;
import oracle.ide.util.Assert;
import oracle.ide.util.GhostPaletteUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ghost.GhostPalette;

public final class LastUsedFiles
extends JPanel
implements KeyListener,
ActionListener,
ListSelectionListener {
    private Set _duplicates;
    private RecentFile[] _recentFiles;
    private KeyNavigationManager _keyNavigationManager;
    private JCheckBox _showAll;
    private JList _lFiles;
    private GhostPalette _container;
    private static JList currentList;

    public static void runDialog(Frame frame, RecentFile[] recentFiles) {
        LastUsedFiles panel = new LastUsedFiles(recentFiles);
        currentList = panel._lFiles;
        HelpSystem hs = HelpSystem.getHelpSystem();
        JComponent owner = (JComponent)Ide.getMainWindow().getContentPane();
        String title = DialogsArb.getString(14);
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        final GhostPalette dialog = new GhostPalette(focusOwner instanceof JComponent ? (JComponent)focusOwner : owner);
        dialog.setTitle(title);
        dialog.add((Component)panel);
        if (hs != null) {
            hs.registerTopic((JComponent)dialog, "f1_idedrecentfiles_html");
        }
        panel.setContainer(dialog);
        dialog.setResizable(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GhostPaletteUtil.show(dialog, "recent files", true, 400, 300);
            }
        });
    }

    private LastUsedFiles(RecentFile[] recentFiles) {
        this._recentFiles = recentFiles;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        Dimension dimension = new Dimension(400, 400);
        this.setSize(dimension);
        JLabel lblWindows = new JLabel();
        DefaultListModel lm = new DefaultListModel();
        String helpText = "RECENT_FILES_BUTTON_TOOL_TIP";
        JButton helpButton = new JButton(OracleIcons.getIcon((String)"help.png"));
        helpButton.setToolTipText(StringUtils.stripMnemonic((String)"RECENT_FILES_BUTTON_TOOL_TIP"));
        helpButton.setActionCommand("HELP");
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpSystem.getHelpSystem().showHelp(LastUsedFiles.this);
            }
        });
        helpButton.setName("Help_Button");
        helpButton.setMargin(new Insets(1, 1, 0, 0));
        helpButton.setFocusable(false);
        final class MyList
        extends JList {
            public MyList(ListModel dataModel) {
                super(dataModel);
                this.enableEvents(8L);
            }

            @Override
            public void paint(Graphics g) {
                g.setColor(Color.WHITE);
                g.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
                super.paint(g);
            }

            @Override
            protected void processKeyEvent(KeyEvent e) {
                if (LastUsedFiles.this._keyNavigationManager != null) {
                    LastUsedFiles.this._keyNavigationManager.preProcessKeyEvent(e);
                }
                super.processKeyEvent(e);
                if (LastUsedFiles.this._keyNavigationManager != null) {
                    LastUsedFiles.this._keyNavigationManager.postProcessKeyEvent(e);
                }
                if (e.getID() == 401 && e.getKeyCode() == 10) {
                    LastUsedFiles.openEditor();
                    LastUsedFiles.this.getContainer().setVisible(false);
                }
            }
        }
        this._lFiles = new MyList(lm);
        this._lFiles.addListSelectionListener(this);
        this._lFiles.setCellRenderer(new DefaultListCellRenderer(){
            private MyModelElement _currentModelElement;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected && cellHasFocus) {
                    this.setOpaque(true);
                    this.setForeground(Color.WHITE);
                    this.setBackground(new Color(49, 108, 196));
                } else {
                    this.setOpaque(false);
                    this.setForeground(Color.BLACK);
                    this.setBackground(Color.BLUE);
                }
                this._currentModelElement = (MyModelElement)value;
                String text = this._currentModelElement.getText();
                this.setText(text);
                Node node = NodeFactory.find(this._currentModelElement._recentFile.getNodeURL());
                Icon icon = URLFileSystem.getDefaultIcon((URL)this._currentModelElement._recentFile.getNodeURL());
                if (node != null) {
                    icon = node.getIcon();
                }
                this.setIcon(icon);
                return this;
            }

            @Override
            public String getToolTipText() {
                String ret = this._currentModelElement != null ? URLFileSystem.getFileName((URL)this._currentModelElement._recentFile.getNodeURL()) : super.getToolTipText();
                return ret;
            }
        });
        this._lFiles.addKeyListener(this);
        this._keyNavigationManager = new KeyNavigationManager(new KeyNavigationManager.ListKeyAdapter(this._lFiles));
        EditorsOptions editorsOptions = EditorManagerImpl.getEditorsOptions();
        boolean recentFilesShowAll = editorsOptions.isRecentFilesShowAll();
        this._showAll = new JCheckBox();
        this._showAll.getModel().setSelected(recentFilesShowAll);
        this._showAll.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._showAll, (String)DialogsArb.getString(16));
        this.fillEditors();
        ResourceUtils.resLabel((JLabel)lblWindows, (Component)this._lFiles, (String)DialogsArb.getString(15));
        this._lFiles.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean clickOnAnItem;
                int index = LastUsedFiles.this._lFiles.locationToIndex(e.getPoint());
                Rectangle r = LastUsedFiles.this._lFiles.getCellBounds(index, index);
                boolean bl = clickOnAnItem = r != null ? r.contains(e.getPoint()) : false;
                if (e.getClickCount() == 2 && clickOnAnItem) {
                    LastUsedFiles.openEditor();
                    LastUsedFiles.this.getContainer().setVisible(false);
                }
            }
        });
        this._lFiles.setSelectionMode(2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        this.add((Component)lblWindows, gbc);
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 1;
        gbc.fill = 1;
        this.add((Component)new JScrollPane(this._lFiles), gbc);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)helpButton, "East");
        p.add((Component)this._showAll, "West");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        this.add((Component)p, gbc);
        this.whenSelectionChanges();
    }

    private void fillEditors() {
        ButtonModel model = this._showAll.getModel();
        boolean showAll = model.isSelected();
        RecentFile[] recentFiles = LastUsedFiles.getValidRecentFiles(this._recentFiles);
        RecentFile[] shownFiles = showAll ? recentFiles : LastUsedFiles.filterExplicits(recentFiles);
        this._duplicates = LastUsedFiles.getDuplicates(shownFiles);
        DefaultListModel lm = (DefaultListModel)this._lFiles.getModel();
        ListSelectionModel lsm = this._lFiles.getSelectionModel();
        List<Object> oldSel = Arrays.asList(this._lFiles.getSelectedValues());
        lm.clear();
        int n = shownFiles.length;
        lm.ensureCapacity(n);
        for (int i = 0; i < n; ++i) {
            RecentFile recentFile = shownFiles[i];
            MyModelElement myModelElement = new MyModelElement(recentFile);
            lm.addElement(myModelElement);
            if (!oldSel.contains(myModelElement)) continue;
            lsm.addSelectionInterval(i, i);
        }
    }

    private static RecentFile[] getValidRecentFiles(RecentFile[] recentFiles) {
        ArrayList<RecentFile> list = new ArrayList<RecentFile>(recentFiles.length);
        for (int i = 0; i < recentFiles.length; ++i) {
            RecentFile recentFile = recentFiles[i];
            if (recentFile == null) {
                Assert.println((String)("recentFile[" + i + "] is null"));
                continue;
            }
            if (!URLFileSystem.isLocal((URL)recentFile.getNodeURL())) {
                Assert.println((String)("recentFile[" + i + "] skipped, non-local url (" + recentFile.getNodeURL() + ")"));
                continue;
            }
            URL url = recentFile.getNodeURL();
            if (!URLFileSystem.exists((URL)url)) continue;
            String shortLabel = URLFileSystem.getFileName((URL)url);
            if (shortLabel != null) {
                String longLabel = URLFileSystem.getPath((URL)url);
                if (longLabel != null) {
                    list.add(recentFile);
                    continue;
                }
                Assert.println((String)("null loglabel for " + recentFile.getNodeURL()));
                continue;
            }
            Assert.println((String)("null shortlabel for " + recentFile.getNodeURL()));
        }
        return list.toArray(new RecentFile[list.size()]);
    }

    private static RecentFile[] filterExplicits(RecentFile[] recentFiles) {
        ArrayList<RecentFile> list = new ArrayList<RecentFile>(recentFiles.length);
        for (int i = 0; i < recentFiles.length; ++i) {
            RecentFile recentFile = recentFiles[i];
            if (!recentFile.isExplicit()) continue;
            list.add(recentFile);
        }
        return list.toArray(new RecentFile[list.size()]);
    }

    private static Set getDuplicates(RecentFile[] recentFiles) {
        int n = recentFiles.length;
        String[] shortLabels = new String[n];
        for (int i = 0; i < n; ++i) {
            shortLabels[i] = URLFileSystem.getFileName((URL)recentFiles[i].getNodeURL());
        }
        ArrayList<RecentFile> duplicateList = new ArrayList<RecentFile>();
        for (int i = 0; i < n; ++i) {
            boolean bDup = false;
            for (int j = i + 1; j < n; ++j) {
                if (!shortLabels[i].equals(shortLabels[j])) continue;
                duplicateList.add(recentFiles[j]);
                bDup = true;
            }
            if (!bDup) continue;
            duplicateList.add(recentFiles[i]);
        }
        return new HashSet(duplicateList);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        EditorsOptions editorsOptions = EditorManagerImpl.getEditorsOptions();
        ButtonModel model = this._showAll.getModel();
        boolean showAll = model.isSelected();
        editorsOptions.setRecentFilesShowAll(showAll);
        this.fillEditors();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.whenSelectionChanges();
    }

    private void whenSelectionChanges() {
        GhostPalette container = this.getContainer();
        if (container != null) {
            ListSelectionModel selectionModel = this._lFiles.getSelectionModel();
            boolean bl = selectionModel.isSelectionEmpty();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!e.isConsumed() && e.getKeyCode() == 10) {
            this.getContainer().setVisible(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private GhostPalette getContainer() {
        return this._container;
    }

    private void setContainer(GhostPalette container) {
        this._container = container;
        this.whenSelectionChanges();
    }

    private static void openEditor() {
        if (currentList == null) {
            return;
        }
        Object[] selectedValues = currentList.getSelectedValues();
        for (int i = 0; i < selectedValues.length; ++i) {
            Object[] sel = currentList.getSelectedValues();
            for (int selPos = 0; selPos < sel.length; ++selPos) {
                MyModelElement myModelElement = (MyModelElement)sel[selPos];
                Context context = myModelElement.getContext();
                EditorManager editorManager = EditorManager.getEditorManager();
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                openEditorOptions.setFlags(8, true);
                editorManager.openEditor(openEditorOptions);
            }
        }
        currentList = null;
    }

    private final class MyModelElement {
        private RecentFile _recentFile;

        public MyModelElement(RecentFile recentFile) {
            this._recentFile = recentFile;
        }

        public boolean equals(Object obj) {
            MyModelElement other = (MyModelElement)obj;
            return this._recentFile.equals(other);
        }

        public int hashCode() {
            return this._recentFile.hashCode();
        }

        public String toString() {
            return this.getText();
        }

        Context getContext() {
            return this._recentFile.getContext();
        }

        String getText() {
            String text = URLFileSystem.getFileName((URL)this._recentFile.getNodeURL());
            String longLabel = URLFileSystem.getPath((URL)this._recentFile.getNodeURL());
            if (LastUsedFiles.this._duplicates.contains((Object)this._recentFile)) {
                text = text + " (" + longLabel + ")";
            }
            return text;
        }
    }
}

