/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.RepaintManager;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeMainWindow;

public class FloatingFeedback {
    private static final Color OPAQUE_BLUE = new Color(199, 207, 255);
    private JComponent _lightWeightFeedback;
    private Window _heavyWeightFeedback;

    public void show(Rectangle screenBounds) {
        IdeMainWindow mainWindow = Ide.getMainWindow();
        JRootPane rootPane = mainWindow.getRootPane();
        Rectangle mainBounds = new Rectangle(rootPane.getLocationOnScreen(), rootPane.getSize());
        if (mainBounds.contains(screenBounds)) {
            this.showLightWeightFeedback(screenBounds);
        } else {
            this.showHeavyWeightFeedback(screenBounds);
        }
    }

    private void showLightWeightFeedback(Rectangle screenBounds) {
        if (this._heavyWeightFeedback != null && this._heavyWeightFeedback.isVisible()) {
            this._heavyWeightFeedback.setVisible(false);
        }
        JComponent lightWeightFeedback = this.getLightWeightFeedback();
        JLayeredPane layeredPane = FloatingFeedback.getLayeredPane();
        if (!lightWeightFeedback.isVisible()) {
            lightWeightFeedback.setVisible(true);
            layeredPane.invalidate();
            layeredPane.revalidate();
            layeredPane.repaint();
        }
        Point layeredPaneOnScreen = layeredPane.getLocationOnScreen();
        screenBounds = new Rectangle(screenBounds);
        screenBounds.translate(-layeredPaneOnScreen.x, -layeredPaneOnScreen.y);
        lightWeightFeedback.setBounds(screenBounds);
        RepaintManager repaintManager = RepaintManager.currentManager(lightWeightFeedback);
        repaintManager.setDoubleBufferingEnabled(false);
        Image image = lightWeightFeedback.createImage(screenBounds.width, screenBounds.height);
        Graphics g = image.getGraphics();
        lightWeightFeedback.paintAll(g);
        repaintManager.setDoubleBufferingEnabled(true);
        g.dispose();
    }

    private void showHeavyWeightFeedback(Rectangle screenBounds) {
        Window heavyWeightFeedback;
        if (this._lightWeightFeedback != null) {
            this._lightWeightFeedback.setVisible(false);
        }
        if (!(heavyWeightFeedback = this.getHeavyWeightFeedback()).isVisible()) {
            heavyWeightFeedback.setVisible(true);
        }
        heavyWeightFeedback.setBounds(screenBounds);
        heavyWeightFeedback.invalidate();
        heavyWeightFeedback.validate();
        heavyWeightFeedback.repaint();
    }

    public void hideFloatPanel() {
        if (this._lightWeightFeedback != null) {
            JLayeredPane layeredPane = FloatingFeedback.getLayeredPane();
            layeredPane.remove(this._lightWeightFeedback);
            this._lightWeightFeedback = null;
            layeredPane.repaint();
        }
        if (this._heavyWeightFeedback != null) {
            this._heavyWeightFeedback.setVisible(false);
            this._heavyWeightFeedback.dispose();
            this._heavyWeightFeedback = null;
        }
    }

    public JComponent getLightWeightFeedback() {
        if (this._lightWeightFeedback == null) {
            this._lightWeightFeedback = new JPanel(new GridBagLayout(), false);
            this._lightWeightFeedback.setOpaque(true);
            this._lightWeightFeedback.setBackground(IdeConstants.DRAG_FEEDBACK_BACKGROUND);
            this._lightWeightFeedback.setBorder(BorderFactory.createLineBorder(IdeConstants.DRAG_FEEDBACK_OUTLINE, 1));
            this._lightWeightFeedback.setCursor(Cursor.getPredefinedCursor(13));
            JLayeredPane layeredPane = FloatingFeedback.getLayeredPane();
            layeredPane.add((Component)this._lightWeightFeedback, JLayeredPane.DRAG_LAYER);
            layeredPane.invalidate();
            layeredPane.revalidate();
            layeredPane.repaint();
        }
        return this._lightWeightFeedback;
    }

    public Window getHeavyWeightFeedback() {
        if (this._heavyWeightFeedback == null) {
            this._heavyWeightFeedback = new JWindow();
            JPanel panel = new JPanel();
            panel.setBackground(OPAQUE_BLUE);
            panel.setBorder(BorderFactory.createLineBorder(IdeConstants.DRAG_FEEDBACK_OUTLINE, 1));
            panel.setCursor(Cursor.getPredefinedCursor(13));
            this._heavyWeightFeedback.add((Component)panel, "Center");
        }
        return this._heavyWeightFeedback;
    }

    private static JLayeredPane getLayeredPane() {
        IdeMainWindow mainWindow = Ide.getMainWindow();
        JRootPane rootPane = mainWindow.getRootPane();
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        return layeredPane;
    }
}

