/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import oracle.ide.Ide;
import oracle.ideimpl.controls.dockLayout.DockDivider;
import oracle.ideimpl.controls.dockLayout.DockLayout;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;
import oracle.ideimpl.docking.DividerControlledPanel;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.MoveFeedback;
import oracle.ideimpl.docking.TitledPanel;

final class SizeDock
extends MoveFeedback
implements ComponentListener,
WindowListener {
    private DockPanel _dp;
    private DockDivider _horzDd;
    private DockDivider _vertDd;
    private DividerControlledPanel _dcp;
    private DockLayoutInfo _dli;

    SizeDock(DockPanel dp, TitledPanel tp) {
        super(tp);
        Container c;
        this._dp = dp;
        dp.validate();
        DockLayout dl = (DockLayout)dp.getLayout();
        this._horzDd = dl.getDivider(tp, 0);
        this._vertDd = dl.getDivider(tp, 2);
        if ((this._horzDd == null || this._vertDd == null) && (c = dp.getParent()) instanceof DividerControlledPanel) {
            this._dcp = (DividerControlledPanel)c;
        }
        this._dli = dp.getLayoutInfo(tp);
        this._dp.addComponentListener(this);
        Ide.getMainWindow().addWindowListener(this);
        Ide.getMainWindow().addComponentListener(this);
        this._lbl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SizeDock.this.byebye();
            }
        });
        this.setText();
    }

    private void setText() {
        Dimension dReal = this._dli.getSize(1);
        this.setText(dReal);
    }

    @Override
    protected void moveBy(int x, int y) {
        String s;
        if (x != 0) {
            if (this._horzDd != null) {
                this._horzDd.moveBy(x, true);
            } else if (this._dcp != null && ((s = this._dcp.getOrientation()).equals("East") || s.equals("West"))) {
                this._dcp.moveBy(x);
            }
        }
        if (y != 0) {
            if (this._vertDd != null) {
                this._vertDd.moveBy(y, false);
            } else if (this._dcp != null && ((s = this._dcp.getOrientation()).equals("North") || s.equals("South"))) {
                this._dcp.moveBy(y);
            }
        }
        this._dp.validate();
        this.setText();
    }

    @Override
    public void dispose() {
        Ide.getMainWindow().removeWindowListener(this);
        Ide.getMainWindow().removeComponentListener(this);
        this._dp.removeComponentListener(this);
        super.dispose();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setText();
        this.adjustPosition();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.setText();
        this.adjustPosition();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.setVisible(true);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.setVisible(false);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.byebye();
    }

    @Override
    public void windowIconified(WindowEvent e) {
        this.setVisible(false);
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        this.setVisible(true);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.setVisible(true);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        this.setVisible(false);
    }
}

