/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.config;

import java.util.Collection;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class FileTypesPrefs
extends HashStructureAdapter {
    private static final String KEY_EXTENSIONS_TO_NODE_TYPES = "extensionsToNodeTypes";
    private static final String KEY_EXTENSIONS_TO_CONTENT_TYPES = "extensionsToContentTypes";

    private FileTypesPrefs(HashStructure hash) {
        super(hash);
    }

    public static final FileTypesPrefs getInstance(PropertyStorage prefs) {
        return new FileTypesPrefs(FileTypesPrefs.findOrCreate((PropertyStorage)prefs, (String)"oracle.ideimpl.config.FileTypesPrefs"));
    }

    public final Collection<String> getFileExtensions() {
        return this.getExtensionsToNodeTypes().keySet();
    }

    public final String getNodeType(String fileExtension) {
        return this.getExtensionsToNodeTypes().getString(fileExtension);
    }

    public final void setNodeType(String fileExtension, String nodeType) {
        this.getExtensionsToNodeTypes().putString(fileExtension, nodeType);
    }

    public final String getContentType(String fileExtension) {
        return this.getExtensionsToContentTypes().getString(fileExtension);
    }

    public final void setContentType(String fileExtension, String contentType) {
        this.getExtensionsToContentTypes().putString(fileExtension, contentType);
    }

    public final HashStructure getExtensionsToNodeTypes() {
        return this._hash.getOrCreateHashStructure(KEY_EXTENSIONS_TO_NODE_TYPES);
    }

    public final HashStructure getExtensionsToContentTypes() {
        return this._hash.getOrCreateHashStructure(KEY_EXTENSIONS_TO_CONTENT_TYPES);
    }
}

