/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.view;

import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockableView;
import oracle.ide.view.AbstractPinnable;
import oracle.ide.view.MultiManager;
import oracle.ide.view.Pinnable;
import oracle.ide.view.View;

public abstract class PinnableManager
extends MultiManager {
    private static final String PINNED_STATE = "PinnableManager.PINNED_STATE";

    @Override
    public DockableView showLastView(Context context) {
        if (context != null) {
            PinnableManager.setPinnedState(context, false);
        }
        return super.showLastView(context);
    }

    @Override
    public DockableView showView(Context context) {
        boolean pinnedState;
        DockableView view = super.showView(context);
        if (view instanceof Pinnable && (pinnedState = PinnableManager.getPinnedState(context))) {
            ((Pinnable)((Object)view)).setPinState(2);
        }
        return view;
    }

    private static boolean getPinnedState(Context context) {
        if (context != null) {
            return Boolean.TRUE.equals(context.getProperty(PINNED_STATE));
        }
        return false;
    }

    private static void setPinnedState(Context context, boolean pinnedState) {
        if (context != null) {
            context.setProperty(PINNED_STATE, pinnedState);
        }
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        int id;
        if (action != null && (id = action.getCommandId()) == 68) {
            View view = context.getView();
            if (view instanceof Pinnable) {
                action.setEnabled(true);
                Pinnable pinnable = (Pinnable)((Object)view);
                action.setState(pinnable.getPinState() != 0);
            } else {
                action.setEnabled(false);
                action.setState(false);
            }
            return true;
        }
        return super.update(action, context);
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        int id;
        int n = id = action != null ? action.getCommandId() : -1;
        if (id == 68) {
            View view = context.getView();
            if (view instanceof Pinnable) {
                Pinnable pinnable = (Pinnable)((Object)view);
                int state = pinnable.getPinState() == 2 ? 0 : 2;
                pinnable.setPinState(state);
                boolean actionState = state == 1 || state == 2;
                action.setState(actionState);
                view.updateTitle(context);
            }
            return true;
        }
        return super.handleEvent(action, context);
    }

    @Override
    protected synchronized DockableView getDefaultView(Context context) {
        DockableView defaultView = super.getDefaultView(context);
        if (defaultView instanceof AbstractPinnable) {
            ((AbstractPinnable)defaultView).setContext(context);
        }
        return defaultView;
    }
}

