/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vcs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingWorker;
import oracle.ide.vcs.VCSManager;

public abstract class VCSTask
extends SwingWorker<Boolean, String> {
    private final URL[] _urls;
    private Map _properties;

    protected VCSTask(URL[] urls) {
        this._urls = urls;
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("external-progress".equals(evt.getPropertyName())) {
                    VCSTask.this.setProgress((Integer)evt.getNewValue());
                }
            }
        });
    }

    public final URL[] getURLs() {
        return this._urls;
    }

    final Map getProperties() {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        return this._properties;
    }

    @Override
    protected final Boolean doInBackground() {
        if (!this.getProperties().containsKey("operation")) {
            throw new IllegalStateException("Task not executed through the VCSManager");
        }
        return VCSManager.getVCSManager().executeTaskImpl(this);
    }
}

