/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vcs;

import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFilter;
import oracle.ide.model.SingletonProvider;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.ide.vcs.VCSListener;
import oracle.ide.vcs.VCSTask;
import oracle.ideimpl.vcs.NullVCSManager;
import oracle.ideimpl.vcs.VCSUtil;
import oracle.javatools.jndi.Names;

public abstract class VCSManager {
    private static Collection<String> _workspaceArtifacts;
    private static Collection<NodeFilter> _checkOutFilters;
    private Map<VCSListener, URLFilter> _vcsListeners;
    private static final String VCS_MANAGER_NAME = "ide/vcs-manager";

    public static VCSManager getVCSManager() {
        VCSManager vcsMgr = (VCSManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)VCS_MANAGER_NAME);
        if (vcsMgr == null && (vcsMgr = SingletonProvider.find(VCSManager.class)) != null) {
            VCSManager.setVCSManager(vcsMgr);
        }
        return vcsMgr != null ? vcsMgr : NullVCSManager.getInstance();
    }

    public static void setVCSManager(VCSManager vcsManager) {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)VCS_MANAGER_NAME, (Object)vcsManager);
    }

    public abstract Future<Boolean> checkOutUsingUI(VCSTask var1);

    public abstract boolean checkOut(URL[] var1);

    public abstract boolean isVersioned(URL var1);

    @Deprecated
    public abstract boolean isAutoCheckOutEnabled(URL var1);

    public abstract boolean canCheckOut(URL var1);

    @Deprecated
    public abstract boolean setReadWrite(URL[] var1);

    @Deprecated
    public abstract boolean checkOutNode(Node var1);

    @Deprecated
    public abstract boolean checkOutNode(Node var1, CommandProcessor var2);

    @Deprecated
    public abstract String getCheckOutCommand(Node var1);

    public abstract MetaClass getMetaCheckOutCommand(Node var1);

    public abstract void validateStatus(URL var1);

    @Deprecated
    public abstract void validateStatus(URLFilter var1);

    public abstract void validateStatus(URL[] var1);

    public final void addVCSListener(VCSListener listener, URLFilter filter) {
        this._getVCSListeners().put(listener, filter);
    }

    public final void removeVCSListener(VCSListener listener) {
        this._getVCSListeners().remove(listener);
    }

    protected final Map<VCSListener, URLFilter> getVCSListeners() {
        return Collections.unmodifiableMap(this._getVCSListeners());
    }

    private final Map<VCSListener, URLFilter> _getVCSListeners() {
        if (this._vcsListeners == null) {
            this._vcsListeners = Collections.synchronizedMap(new HashMap());
        }
        return this._vcsListeners;
    }

    public abstract String getVersionName(URL var1);

    @Deprecated
    public final void registerWorkspaceArtifact(String path) {
        VCSManager._getWorkspaceArtifacts().add(path);
    }

    @Deprecated
    public final void deregisterWorkspaceArtifact(String path) {
    }

    protected final Collection<String> getWorkspaceArtifacts() {
        return Collections.unmodifiableCollection(VCSManager._getWorkspaceArtifacts());
    }

    private static final Collection<String> _getWorkspaceArtifacts() {
        if (_workspaceArtifacts == null) {
            _workspaceArtifacts = new CopyOnWriteArraySet<String>();
        }
        return _workspaceArtifacts;
    }

    @Deprecated
    public final void registerCheckOutFilter(NodeFilter filter) {
        VCSManager._getCheckOutFilters().add(filter);
    }

    protected final Collection<NodeFilter> getCheckOutFilters() {
        return Collections.unmodifiableCollection(VCSManager._getCheckOutFilters());
    }

    private static final Collection<NodeFilter> _getCheckOutFilters() {
        if (_checkOutFilters == null) {
            _checkOutFilters = new CopyOnWriteArrayList<NodeFilter>();
        }
        return _checkOutFilters;
    }

    public abstract boolean containsConflicts(URL var1);

    public abstract InputStream openConflictsStreamAsContributor(URL var1) throws IOException;

    public abstract ContextMenuListener[] getContextMenuListeners();

    public abstract Locatable[] getContextLocatables(Context var1);

    protected abstract boolean executeTaskImpl(VCSTask var1);

    public abstract String getRevisionIdentifier(URL var1) throws Exception;

    public abstract InputStream getRevisionContent(URL var1, String var2) throws IOException;

    public abstract Collection<URL> getAllModifiedFiles(URL var1) throws Exception;

    protected final Map getTaskProperties(VCSTask task) {
        return task.getProperties();
    }

    public final void deleteRecursively(URL url) throws IOException, InterruptedException {
        this.deleteRecursively(url, null, false);
    }

    public final void deleteRecursively(URL url, URLFilter filter, boolean tolerant) throws IOException, InterruptedException {
        this.deleteRecursively(url, filter, tolerant, null);
    }

    public void deleteRecursively(URL url, URLFilter filter, boolean tolerant, Collection<URL> nonDeletedUrls) throws IOException, InterruptedException {
        if (EventQueue.isDispatchThread()) {
            Assert.printStackTrace((Throwable)new IllegalStateException("deleteRecursively() called from AWT event thread"));
        }
        this._deleteRecursively(url, filter, tolerant, true, new boolean[1], nonDeletedUrls);
    }

    public final void deleteRecursively(URL[] urls, URLFilter filter, boolean tolerant) throws IOException, InterruptedException {
        this.deleteRecursively(urls, filter, tolerant, null);
    }

    public final void deleteRecursively(URL[] urls, URLFilter filter, boolean tolerant, Collection<URL> nonDeletedUrls) throws IOException, InterruptedException {
        for (URL url : VCSUtil.coalesceURLs(urls)) {
            this.deleteRecursively(url, filter, tolerant, nonDeletedUrls);
        }
    }

    private final boolean _deleteRecursively(URL url, URLFilter filter, boolean tolerant, boolean success, boolean[] var_filtered, Collection<URL> nonDeletedUrls) throws IOException, InterruptedException {
        URLFileSystem.FileInfo[] children;
        if (filter != null && !filter.accept(url)) {
            var_filtered[0] = true;
            return success;
        }
        boolean[] filtered = new boolean[1];
        if (URLFileSystem.isDirectory((URL)url) && (children = URLFileSystem.ls((URL)url)) != null) {
            for (URLFileSystem.FileInfo child : children) {
                boolean bl = success = this._deleteRecursively(child.getURL(), filter, tolerant, success, filtered, nonDeletedUrls) && success;
                if (success || tolerant) continue;
                return false;
            }
            if (children.length > 0 && Thread.interrupted()) {
                throw new InterruptedException();
            }
        }
        if (filtered[0]) {
            var_filtered[0] = true;
            return success;
        }
        if (success) {
            try {
                URLFileSystem.deleteEx((URL)url);
                return true;
            }
            catch (IOException ioe) {
                if (nonDeletedUrls != null) {
                    nonDeletedUrls.add(url);
                }
                if (tolerant) {
                    return false;
                }
                throw ioe;
            }
        }
        throw new IOException("Unable to delete " + URLFileSystem.getPath((URL)url));
    }
}

