/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class IteratorFilter
implements Iterator {
    private Iterator _baseIterator;
    private boolean _bNextIsFetched;
    private Object _next;

    public IteratorFilter(Iterator baseIterator) {
        this._baseIterator = baseIterator;
    }

    protected abstract boolean isValid(Object var1);

    @Override
    public boolean hasNext() {
        return this._bNextIsFetched || this.fetchNext();
    }

    public Object next() {
        if (!this._bNextIsFetched && !this.fetchNext()) {
            throw new NoSuchElementException();
        }
        Object ret = this._next;
        this._next = null;
        this._bNextIsFetched = false;
        return ret;
    }

    @Override
    public void remove() {
        if (this._bNextIsFetched) {
            throw new IllegalStateException();
        }
        this._baseIterator.remove();
    }

    private boolean fetchNext() {
        boolean bRet = false;
        while (!bRet && this._baseIterator.hasNext()) {
            Object o = this._baseIterator.next();
            if (!this.isValid(o)) continue;
            this._bNextIsFetched = true;
            this._next = o;
            bRet = true;
        }
        return bRet;
    }
}

