/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.task.ui;

public class TaskManagerDialogConfiguration {
    private final String m_title;
    private final String m_message;
    private final String m_detailedMessage;
    private final int m_maxSteps;

    private TaskManagerDialogConfiguration(String title, String message, String detailedMessage, int maxSteps) {
        this.m_title = title;
        this.m_message = message;
        this.m_detailedMessage = detailedMessage;
        this.m_maxSteps = maxSteps;
    }

    public String getTitle() {
        return this.m_title;
    }

    public String getMessage() {
        return this.m_message;
    }

    public String getDetailedMessage() {
        return this.m_detailedMessage;
    }

    public Boolean isDeterminate() {
        return this.m_maxSteps > 0;
    }

    public Integer getMaxSteps() {
        return this.m_maxSteps;
    }

    public static class Builder {
        private String m_title;
        private String m_message;
        private String m_detailedMessage;
        private int m_maxSteps = 0;

        public Builder title(String title) {
            this.m_title = title;
            return this;
        }

        public Builder message(String message) {
            this.m_message = message;
            return this;
        }

        public Builder detailedMessage(String details) {
            this.m_detailedMessage = details;
            return this;
        }

        public Builder maxSteps(int steps) {
            this.m_maxSteps = steps;
            return this;
        }

        public TaskManagerDialogConfiguration build() {
            return new TaskManagerDialogConfiguration(this.m_title, this.m_message, this.m_detailedMessage, this.m_maxSteps);
        }
    }
}

