/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.task;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import oracle.ide.task.Task;
import oracle.ide.task.TaskID;
import oracle.ide.task.TaskMonitor;
import oracle.ide.task.TaskRunnable;
import oracle.ide.task.TaskState;
import oracle.ide.task.event.ProgressEvent;
import oracle.ide.task.event.TaskEvent;
import oracle.ide.task.event.TaskException;
import oracle.ide.task.event.TaskListener;
import oracle.ide.task.event.UpdateEvent;
import oracle.ide.task.locking.TaskLockRequest;

@Deprecated
public class TaskManager {
    private static final TaskManager singletonTaskManager = new TaskManager();
    private final LinkedHashMap<TaskID, Task> taskQueue;
    private final TaskManagerTaskListener internalListener = new TaskManagerTaskListener();
    private static final HashMap<String, TaskMonitor> tcsMap = new HashMap();
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();

    private TaskManager() {
        this.taskQueue = new LinkedHashMap();
    }

    protected static TaskID generateID() {
        String id = "task_" + UUID.randomUUID() + "_" + System.currentTimeMillis();
        return new TaskID(id);
    }

    public static TaskManager getInstance() {
        return singletonTaskManager;
    }

    public TaskID startTask(Task task) throws TaskException {
        if (task == null) {
            throw new TaskException("Task cannot be null ");
        }
        if (this.taskQueue.containsValue(task.getID())) {
            throw new TaskException(" Task already Listed!");
        }
        this.taskQueue.put(task.getID(), task);
        if (task.getState() != TaskState.CREATED) {
            throw new TaskException("Task " + task.getID() + " already started");
        }
        task.addTaskListener(this.internalListener);
        Thread t = new Thread(new TaskRunnable(task));
        t.start();
        return task.getID();
    }

    public Future<?> enqueueTask(Task task) {
        if (!this.taskQueue.containsValue(task.getID())) {
            this.taskQueue.put(task.getID(), task);
        }
        task.addTaskListener(this.internalListener);
        return EXECUTOR.submit(new TaskRunnable(task));
    }

    public void startTaskOnThisThread(Task task) throws TaskException {
        if (task == null) {
            throw new TaskException("Task cannot be null ");
        }
        if (task.getState() != TaskState.CREATED) {
            throw new TaskException("Task " + task.getID() + " already started");
        }
        task.addTaskListener(this.internalListener);
        TaskRunnable tr = new TaskRunnable(task);
        tr.run();
    }

    public TaskID scheduleTask(Task task, TaskLockRequest lock) throws TaskException {
        throw new TaskException("NOT IMPLEMENTED");
    }

    public static TaskMonitor getTaskMonitor(String key) {
        return tcsMap.get(key);
    }

    protected static void setTaskMonitor(String key, TaskMonitor value) {
        tcsMap.put(key, value);
    }

    protected static void unsetTaskMonitor(String key) {
        try {
            tcsMap.remove(key);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class TaskManagerTaskListener
    implements TaskListener {
        private TaskManagerTaskListener() {
        }

        @Override
        public void taskProgress(ProgressEvent e) {
        }

        @Override
        public void taskUpdate(UpdateEvent e) {
        }

        @Override
        public void taskCancelled(TaskEvent e) {
            TaskManager.this.taskQueue.remove(e.getSource().getID());
        }

        @Override
        public void taskException(TaskEvent e, Exception ex) {
            TaskManager.this.taskQueue.remove(e.getSource().getID());
        }

        @Override
        public void taskStarted(TaskEvent e) {
        }

        @Override
        public void taskComplete(TaskEvent e) {
            TaskManager.this.taskQueue.remove(e.getSource().getID());
        }

        @Override
        public void taskPaused(TaskEvent e) {
        }
    }
}

