/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.refactoring.ActionHandlerUtil;
import oracle.ide.refactoring.SimpleMoveActionHandler;
import oracle.ide.resource.MoveDialogArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.IconicButtonUI;

public abstract class MoveElementActionHandler<T extends Element>
extends SimpleMoveActionHandler<T> {
    private URLTextField destinationTextField;

    public MoveElementActionHandler(Context context) {
        super(context);
    }

    protected String getDestination() {
        return this.destinationTextField != null ? this.destinationTextField.getText() : null;
    }

    @Override
    protected final boolean doMove() {
        List elements = this.getElements();
        String destination = this.getDestination();
        ArrayList<URL> nonmoved = new ArrayList<URL>();
        boolean ret = true;
        for (Element element : elements) {
            if (this.move(element, destination)) continue;
            ret = false;
            if (!(element instanceof Node)) continue;
            nonmoved.add(((Node)element).getURL());
        }
        ActionHandlerUtil.reportNonMovedURLs(nonmoved, false);
        return ret;
    }

    protected boolean move(T element, String destination) {
        if (element instanceof Node) {
            return MoveElementActionHandler.moveNode((Node)element, destination);
        }
        return false;
    }

    @Override
    protected Component createDialogContent() {
        List elements = this.getElements();
        boolean nodes = elements.size() > 0;
        for (Element element : elements) {
            if (element instanceof Node) continue;
            nodes = false;
            break;
        }
        if (!nodes) {
            return null;
        }
        final URL sourceURL = URLFileSystem.getParent((URL)((Node)elements.get(0)).getURL());
        final JLabel messageLabel = new JLabel();
        this.destinationTextField = new URLTextField(sourceURL, true, false){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (null == this.getURL()) {
                    this.setURL(sourceURL);
                }
                super.actionPerformed(e);
            }
        };
        messageLabel.setPreferredSize(this.destinationTextField.getPreferredSize());
        this.destinationTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkValid();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkValid();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkValid();
            }

            private void checkValid() {
                boolean valid;
                URL newURL = MoveElementActionHandler.this.destinationTextField.getURL();
                boolean bl = valid = newURL != null && !URLFileSystem.equals((URL)newURL, (URL)sourceURL) && (!URLFileSystem.exists((URL)newURL) || URLFileSystem.isDirectory((URL)newURL));
                if (!valid) {
                    messageLabel.setText(MoveDialogArb.getString(8));
                    messageLabel.setIcon(OracleIcons.getIcon((String)"error.png"));
                } else {
                    messageLabel.setText("");
                    messageLabel.setIcon(null);
                }
                MoveElementActionHandler.this.setOKButtonEnabled(valid);
            }
        });
        JLabel dirLabel = new JLabel();
        String pkgText = MoveDialogArb.getString(0);
        ResourceUtils.resLabel((JLabel)dirLabel, (Component)((Object)this.destinationTextField), (String)pkgText);
        JButton browseButton = new JButton();
        browseButton.setIcon(OracleIcons.getIcon((String)"lov.png"));
        browseButton.setToolTipText(MoveDialogArb.getString(7));
        browseButton.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        IconicButtonUI.install((AbstractButton)browseButton);
        browseButton.addActionListener(this.destinationTextField);
        JPanel panel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        panel.add((Component)dirLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        panel.add((Component)((Object)this.destinationTextField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        panel.add((Component)browseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        panel.add((Component)messageLabel, new GridBagConstraints(0, 10, 10, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
        return panel;
    }
}

