/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.paths;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;

public final class PathInfo
extends ExtensionHook {
    public static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "path-infos");
    private static PathInfo s_PathInfo;
    private final HashMap<String, String> m_Paths = new HashMap();
    private final HashMap<String, URL> m_PathUrls = new HashMap();
    private final PathInfoElementVisitor m_PathInfoVisitor = new PathInfoElementVisitor();
    public static final ElementName PATH_INFO_ELEMENT;

    public static PathInfo getInstance() {
        if (s_PathInfo == null) {
            s_PathInfo = (PathInfo)ExtensionRegistry.getExtensionRegistry().getHook(HOOK_NAME);
        }
        return s_PathInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getUrl(String pathInfoId) throws IllegalArgumentException {
        HashMap<String, String> hashMap = this.m_Paths;
        synchronized (hashMap) {
            URL pathUrl = this.m_PathUrls.get(pathInfoId);
            if (pathUrl == null) {
                String path = this.getPath(pathInfoId);
                int relativeIndex = path.indexOf("../");
                if (relativeIndex > 0) {
                    String basePath = path.substring(0, relativeIndex);
                    String relPath = path.substring(relativeIndex);
                    pathUrl = URLFactory.newFileURL((String)basePath);
                    pathUrl = URLFactory.newURL((URL)pathUrl, (String)relPath);
                } else {
                    pathUrl = URLFactory.newFileURL((String)path);
                }
                if (JarUtil.isArchive((String)path)) {
                    pathUrl = URLFactory.newJarURL((URL)pathUrl, null);
                }
                this.m_PathUrls.put(path, pathUrl);
            }
            return pathUrl;
        }
    }

    public String getPath(String pathInfoId) throws IllegalArgumentException {
        String path = this.m_Paths.get(pathInfoId);
        if (path == null) {
            throw new IllegalArgumentException(pathInfoId);
        }
        return path;
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(PATH_INFO_ELEMENT, (ElementVisitor)this.m_PathInfoVisitor);
    }

    static {
        PATH_INFO_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "path-info");
    }

    private final class PathInfoElementVisitor
    extends ElementVisitor {
        private static final String _PATH_INFO_ID_KEY = "key-path-info-id";

        private PathInfoElementVisitor() {
        }

        public void start(ElementStartContext context) {
            String pathInfoId = this.getAttributeHelper(context, "id", true, true);
            context.getScopeData().put(_PATH_INFO_ID_KEY, pathInfoId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end(ElementEndContext context) {
            String pathInfoId;
            String path = this.getTextHelper(context, true, true);
            if (path != null && (pathInfoId = (String)context.getScopeData().get(_PATH_INFO_ID_KEY)) != null) {
                HashMap hashMap = PathInfo.this.m_Paths;
                synchronized (hashMap) {
                    if (PathInfo.this.m_Paths.containsKey(pathInfoId)) {
                        this.log((ElementContext)context, Level.SEVERE, "Duplicate definition of path-info, id: '" + pathInfoId + "'");
                    } else {
                        PathInfo.this.m_Paths.put(pathInfoId, path);
                        if (path.startsWith(".")) {
                            try {
                                URI pathURI = PathInfo.this.resolvePath((ElementContext)context, path);
                                if (pathURI != null) {
                                    URL pathUrl = pathURI.toURL();
                                    PathInfo.this.m_PathUrls.put(pathInfoId, pathUrl);
                                }
                            }
                            catch (MalformedURLException mue) {
                                this.log((ElementContext)context, Level.SEVERE, "Unable to resolve path-info, id: '" + pathInfoId + "', path: " + path + ".  " + mue.getMessage());
                            }
                        }
                    }
                }
            }
        }
    }
}

