/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import oracle.ide.net.URLChooser;
import oracle.ide.resource.NetArb;
import oracle.javatools.icons.OracleIcons;

final class CommandBar
extends JToolBar
implements ActionListener {
    private JButton _btnBack;
    private JButton _btnFwd;
    private JButton _btnChdirToParent;
    private JButton _btnNewDir;
    private JToggleButton _btnListView;
    private JToggleButton _btnDetailsView;
    private URLChooser _urlChooser;

    public CommandBar(URLChooser urlChooser) {
        this._urlChooser = urlChooser;
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setFloatable(false);
        this.setRollover(true);
        this.createButtons();
    }

    public void enableBackButton(boolean enabled) {
        if (this._btnBack != null) {
            this._btnBack.setEnabled(enabled);
        }
    }

    public void enableForwardButton(boolean enabled) {
        if (this._btnFwd != null) {
            this._btnFwd.setEnabled(enabled);
        }
    }

    public void enableUpDirButton(boolean enabled) {
        if (this._btnChdirToParent != null) {
            this._btnChdirToParent.setEnabled(enabled);
        }
    }

    public void enableNewDirButton(boolean enabled) {
        if (this._btnNewDir != null) {
            this._btnNewDir.setEnabled(enabled);
        }
    }

    public void setDetailsView(boolean detailsView) {
        if (this._btnListView != null && this._btnDetailsView != null) {
            this._urlChooser.setDetailsView(detailsView);
            this._btnListView.setSelected(!detailsView);
            this._btnDetailsView.setSelected(detailsView);
        }
    }

    public void setSelectionScope(int selectionScope) {
        this.removeAll();
        if (selectionScope == 1) {
            if (this._btnNewDir != null) {
                this.add(this._btnNewDir);
            }
        } else {
            if (this._btnBack != null) {
                this.add(this._btnBack);
            }
            if (this._btnFwd != null) {
                this.add(this._btnFwd);
            }
            if (this._btnChdirToParent != null) {
                this.add(this._btnChdirToParent);
            }
            if (this._btnNewDir != null) {
                this.add(this._btnNewDir);
            }
            if (this._btnListView != null && this._btnDetailsView != null) {
                if (this.getComponentCount() > 0) {
                    this.add(Box.createHorizontalStrut(5));
                }
                this.add(this._btnListView);
                this.add(this._btnDetailsView);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._urlChooser.isChooserEnabled()) {
            Object source = e.getSource();
            if (source == null) {
                return;
            }
            if (source == this._btnBack) {
                this._urlChooser.runNow(20);
            } else if (source == this._btnFwd) {
                this._urlChooser.runNow(24);
            } else if (source == this._btnChdirToParent) {
                this._urlChooser.runNow(1);
            } else if (source == this._btnNewDir) {
                this._urlChooser.runNow(18);
            } else if (source == this._btnListView) {
                this.setDetailsView(false);
            } else if (source == this._btnDetailsView) {
                this.setDetailsView(true);
            }
        }
    }

    private JButton createButton(Icon icon, String tooltip) {
        JButton button = new JButton(icon);
        this.initButton(button, tooltip);
        return button;
    }

    private JToggleButton createToggleButton(Icon icon, String tooltip) {
        JToggleButton button = new JToggleButton(icon);
        this.initButton(button, tooltip);
        return button;
    }

    private void initButton(AbstractButton button, String tooltip) {
        button.setMargin(new Insets(1, 1, 1, 1));
        button.addActionListener(this);
        if (tooltip != null) {
            button.setToolTipText(tooltip);
        }
    }

    private void createButtons() {
        Icon backIcon = OracleIcons.getIcon((String)"navigateBack.png");
        if (backIcon != null) {
            this._btnBack = this.createButton(backIcon, NetArb.getString((int)5));
            this._btnBack.setEnabled(false);
        } else {
            this._btnBack = null;
        }
        Icon fwdIcon = OracleIcons.getIcon((String)"navigateForward.png");
        if (fwdIcon != null) {
            this._btnFwd = this.createButton(fwdIcon, NetArb.getString((int)41));
            this._btnFwd.setEnabled(false);
        } else {
            this._btnFwd = null;
        }
        Icon upDirIcon = OracleIcons.getIcon((String)"upFolder.png");
        this._btnChdirToParent = upDirIcon != null ? this.createButton(upDirIcon, NetArb.getString((int)6)) : null;
        Icon newDirIcon = OracleIcons.getIcon((String)"folderNew.png");
        this._btnNewDir = newDirIcon != null ? this.createButton(newDirIcon, NetArb.getString((int)7)) : null;
        Icon listViewIcon = OracleIcons.getIcon((String)"bullist.png");
        Icon detailsViewIcon = OracleIcons.getIcon((String)"table.png");
        if (listViewIcon != null && detailsViewIcon != null) {
            this._btnListView = this.createToggleButton(listViewIcon, NetArb.getString((int)8));
            this._btnDetailsView = this.createToggleButton(detailsViewIcon, NetArb.getString((int)9));
            ButtonGroup group = new ButtonGroup();
            group.add(this._btnListView);
            group.add(this._btnDetailsView);
        } else {
            this._btnDetailsView = null;
            this._btnListView = null;
        }
    }
}

