/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.natives.accessibility;

import oracle.ide.natives.NativeHandler;
import oracle.javatools.util.PlatformUtils;

public final class HighContrast {
    private static final String PROPERTY = "oracle.ide.accessibility.HighContrast";
    private static HighContrast INSTANCE = new HighContrast();
    private boolean _initialized;
    private boolean _isEnabled;

    protected HighContrast() {
    }

    public static boolean isHighContrastModeEnabled() {
        return INSTANCE.getHighContrastModeEnabled();
    }

    private static native boolean getOSHighContrastEnabledFlag();

    private synchronized boolean getHighContrastModeEnabled() {
        if (!this._initialized) {
            this._isEnabled = Boolean.parseBoolean(System.getProperty(PROPERTY, Boolean.toString(this.getDefaultSetting())));
            this._initialized = true;
        }
        return this._isEnabled;
    }

    private boolean getDefaultSetting() {
        if (PlatformUtils.isWindows() && NativeHandler.isLoaded()) {
            try {
                return HighContrast.getOSHighContrastEnabledFlag();
            }
            catch (UnsatisfiedLinkError ule) {
                ule.printStackTrace();
                return false;
            }
        }
        return false;
    }
}

