/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashSet;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.Project;
import oracle.ide.model.SharedPropertiesManager;
import oracle.ide.model.Workspace;
import oracle.ide.model.panels.HSAdapterDelegateComponent;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public abstract class ProjectSettingsTraversablePanel
extends DefaultTraversablePanel {
    private boolean _entered;
    private JPanel _content;
    private transient HSAdapterDelegateComponent _decoratedComp;
    private PersistenceLocation _location;
    private Boolean _wsPropertiesAreSupported;
    private static final String INTERNAL_KEY = ".ProjectSettingsTraversablePanel.internal-key";
    private static final String PROJECT_INTERNAL_KEY = "Project.ProjectSettingsTraversablePanel.internal-key";
    private static final String WORKSPACE_INTERNAL_KEY = "Application.ProjectSettingsTraversablePanel.internal-key";
    private static final String UNDEFINED_PROPERTY_DATA_KEY = "undefinedKey";
    private String _propertyDataKeyRoot = "undefinedKey";
    private int _propertiesAreOverridden = -1;
    private static final int OVERRIDDEN = 1;
    private static final int NOT_OVERRIDDEN = 0;
    private static final String EDITING_DEFAULT_PROJECT = "IsDefaultProject";
    private static final String PROPERTIES_DATA = "PropertyData";
    private static final String CHAINED_PROPERTY_DATA = "ChainedPropertyData";
    private static final String USER_ONLY_PROPERTY_DATA = "UserOnlyPropertyData";
    private static final String WORKSPACE_LEVEL_PROPERTY_DATA = "WorkspaceLevelPropertyData";
    private static final String PERSISTENCE_LOCATION = "PropertiesDataPersistenceLocation";
    private static final String PROJECT_OWNED_BY_WORKSPACE = "ProjectOwnedByWorkspace";
    @Deprecated
    public static final String DEFAULT_PROJECT_KEY = "IsDefaultProject";
    @Deprecated
    public static final String EDITING_CUSTOM_PROPERTIES_KEY = "IsUserPropertyData_Deprecated";
    @Deprecated
    public static final String PROPERTY_DATA_KEY = "PropertyData";
    @Deprecated
    public static final String CHAINED_PROPERTY_DATA_KEY = "ChainedPropertyData";
    @Deprecated
    public static final String USER_ONLY_PROPERTY_DATA_KEY = "UserOnlyPropertyData";

    public void onEntry(TraversableContext traversableContext) {
        if (traversableContext.contains("ChainedPropertyData") && this._location == null) {
            this._location = this.isUserOnly() ? PersistenceLocation.USER : (this.supportsWorkspaceSharedProperties() && SharedPropertiesManager.get().isUsingSharedProperties(ProjectSettingsTraversablePanel.getProject((Namespace)traversableContext), this.rootPropertiesHashKey()) ? PersistenceLocation.PARENT : (this.projectPropertiesAreOverriden(traversableContext) ? PersistenceLocation.USER : PersistenceLocation.BASE));
        }
        this.ensureInitialized(traversableContext);
        String hashAdapterDelegateKey = this.getHashAdapterDelegateKey();
        if (!this._entered && hashAdapterDelegateKey != null) {
            this._entered = true;
            HSAdapterDelegateComponent.Scope scope = null;
            HashStructureNode node = ProjectSettingsTraversablePanel.nodeWithoutAnySessionEdits((Namespace)traversableContext);
            if (node instanceof Project) {
                scope = HSAdapterDelegateComponent.Scope.PROJECT;
            } else if (node instanceof Workspace) {
                scope = HSAdapterDelegateComponent.Scope.WORKSPACE;
            }
            if (node != null && scope != null && HSAdapterDelegateComponent.propertiesAreDelegated(hashAdapterDelegateKey, scope, (HashStructureNode)node.copyTo(null))) {
                this._decoratedComp.configureComponent(hashAdapterDelegateKey, scope, node);
            }
        }
        this.onProjectPanelEntry(traversableContext);
    }

    public abstract void onProjectPanelEntry(TraversableContext var1);

    public abstract String getDataKey();

    public abstract String[] getPropertyKeys();

    protected String getHashAdapterDelegateKey() {
        return null;
    }

    protected static Workspace getProjectsOwningWorkspace(Namespace data) {
        return (Workspace)data.find(PROJECT_OWNED_BY_WORKSPACE);
    }

    protected static Project getProject(Namespace data) {
        return ProjectSettingsTraversablePanel.getProject(data, false);
    }

    protected static Project getProject(Namespace data, boolean projectCopy) {
        if (projectCopy) {
            Project project = (Project)ProjectSettingsTraversablePanel.nodeWithoutAnySessionEdits(data);
            return project != null ? (Project)project.copyTo(null) : null;
        }
        return (Project)data.find("Project");
    }

    protected static PropertyStorage getPropertyData(Namespace data) {
        PersistenceLocation location = ProjectSettingsTraversablePanel.getPersistenceLocation(data);
        HashStructure properties = location == PersistenceLocation.PARENT ? (HashStructure)data.find(WORKSPACE_LEVEL_PROPERTY_DATA) : (HashStructure)data.find("PropertyData");
        return new PropertyData(properties);
    }

    protected boolean editsSharedProperties() {
        return false;
    }

    public static boolean isEditingSharedProperties(Namespace data) {
        PersistenceLocation location = (PersistenceLocation)((Object)data.find(PERSISTENCE_LOCATION));
        return location != null && PersistenceLocation.PARENT == location;
    }

    public final boolean supportsSharedProperties() {
        return this.editsSharedProperties() && SharedPropertiesManager.get().propertiesAreShareable(this.rootPropertiesHashKey());
    }

    public boolean isUserOnly() {
        return false;
    }

    public static final boolean isDefaultProject(Namespace data) {
        return Boolean.TRUE.equals(data.find("IsDefaultProject"));
    }

    public static final boolean editingUserProperties(Namespace data) {
        PersistenceLocation location = (PersistenceLocation)((Object)data.find(PERSISTENCE_LOCATION));
        return Boolean.TRUE.equals(PersistenceLocation.USER == location);
    }

    public final void activateProperties(TraversableContext tc, boolean useCustom) {
        HashStructure allUserProperties = (HashStructure)tc.get("UserOnlyPropertyData");
        HashStructure user = this.getPanelProperties(allUserProperties);
        String[] propertyKeys = this.getPropertyKeys();
        if (useCustom) {
            user.recoverValues(propertyKeys);
        } else {
            user.hideValues(propertyKeys);
        }
    }

    @Deprecated
    public boolean arePropertiesOverridden() {
        return 1 == this._propertiesAreOverridden;
    }

    public void setLayout(LayoutManager mgr) {
        if (mgr instanceof BoxLayout) {
            BoxLayout boxLayout = new BoxLayout(this.getHostedPanel(), ((BoxLayout)mgr).getAxis());
            this.getHostedPanel().setLayout(boxLayout);
            return;
        }
        this.getHostedPanel().setLayout(mgr);
    }

    public Component add(Component comp) {
        return this.getHostedPanel().add(comp);
    }

    public Component add(Component comp, int index) {
        return this.getHostedPanel().add(comp, index);
    }

    public void add(Component comp, Object constraints) {
        this.getHostedPanel().add(comp, constraints);
    }

    public void add(Component comp, Object constraints, int index) {
        this.getHostedPanel().add(comp, constraints, index);
    }

    public void remove(Component comp) {
        this.getHostedPanel().remove(comp);
    }

    public void remove(int index) {
        this.getHostedPanel().remove(index);
    }

    public void removeAll() {
        this.getHostedPanel().removeAll();
    }

    public LayoutManager getLayout() {
        return this.getHostedPanel().getLayout();
    }

    final boolean supportsWorkspaceSharedProperties() {
        if (this._wsPropertiesAreSupported == null) {
            String propertyDataKey = this.rootPropertiesHashKey();
            if (propertyDataKey == null) {
                this._wsPropertiesAreSupported = Boolean.FALSE;
            } else {
                boolean shareable = SharedPropertiesManager.get().propertiesAreShareable(propertyDataKey);
                this._wsPropertiesAreSupported = shareable;
            }
        }
        return this._wsPropertiesAreSupported;
    }

    final String rootPropertiesHashKey() {
        if (!UNDEFINED_PROPERTY_DATA_KEY.equals(this._propertyDataKeyRoot)) {
            return this._propertyDataKeyRoot;
        }
        this._propertyDataKeyRoot = this.getDataKey();
        String propertyDataKey = this._propertyDataKeyRoot;
        if (propertyDataKey == null) {
            String[] keys = this.getPropertyKeys();
            HashSet<String> set = new HashSet<String>();
            for (String key : keys) {
                int index = key.indexOf(47);
                if (index < 0 || index >= key.length()) {
                    set.add(key);
                    continue;
                }
                set.add(key.substring(0, index));
            }
            if (set.size() == 1) {
                propertyDataKey = (String)set.iterator().next();
            }
        }
        this._propertyDataKeyRoot = propertyDataKey;
        return this._propertyDataKeyRoot;
    }

    final PersistenceLocation getPersistenceLocation() {
        return this._location;
    }

    static final void storeSharedProperties(Namespace data, HashStructure sharedPropertiesHash) {
        data.put("PropertyData", (Object)sharedPropertiesHash);
    }

    static final void storeIsDefaultProject(Namespace data, Boolean isDefault) {
        data.put("IsDefaultProject", (Object)isDefault);
    }

    static final void storeChainedPropertiesData(Namespace data, HashStructure chainedPropertiesHash) {
        data.put("ChainedPropertyData", (Object)chainedPropertiesHash);
    }

    static final void storeUserPrivatePropertiesData(Namespace data, HashStructure userPropertiesHash) {
        data.put("UserOnlyPropertyData", (Object)userPropertiesHash);
    }

    static final void storeWorkspaceLevelProperties(Namespace data, HashStructure hashStructure) {
        data.put(WORKSPACE_LEVEL_PROPERTY_DATA, (Object)hashStructure);
    }

    static final void storePersistenceLocation(Namespace data, PersistenceLocation target) {
        data.put(PERSISTENCE_LOCATION, (Object)target);
    }

    static final PersistenceLocation getPersistenceLocation(Namespace data) {
        return (PersistenceLocation)((Object)data.get(PERSISTENCE_LOCATION));
    }

    static final void storeProjectsOwningWorkspace(Namespace data, Workspace workspace) {
        data.put(PROJECT_OWNED_BY_WORKSPACE, (Object)workspace);
    }

    private boolean projectPropertiesAreOverriden(TraversableContext traversableContext) {
        String[] propertyKeys = this.getPropertyKeys();
        if (this._propertiesAreOverridden < 0) {
            HashStructure allChainedProperties = (HashStructure)traversableContext.find("ChainedPropertyData");
            HashStructure chained = this.getPanelProperties(allChainedProperties);
            this._propertiesAreOverridden = chained.isAnyValueOverridden(propertyKeys) ? 1 : 0;
        }
        return 1 == this._propertiesAreOverridden;
    }

    private HashStructure getPanelProperties(HashStructure hash) {
        String dataKey = this.getDataKey();
        if (dataKey != null) {
            return hash.getOrCreateHashStructure(dataKey);
        }
        return hash;
    }

    private void ensureInitialized(TraversableContext traversableContext) {
        this.getHostedPanel();
        ProjectSettingsTraversablePanel.nodeWithoutAnySessionEdits((Namespace)traversableContext);
    }

    private static final HashStructureNode nodeWithoutAnySessionEdits(Namespace traversableContext) {
        HashStructureNode node;
        HashStructureNode nodeUnderEdit = null;
        if (!traversableContext.contains(PROJECT_INTERNAL_KEY)) {
            node = null;
            if (traversableContext.get("Project") instanceof Project) {
                HashStructureNode project = (HashStructureNode)traversableContext.get("Project");
                nodeUnderEdit = node = (HashStructureNode)project.copyTo(null);
            }
            traversableContext.put(PROJECT_INTERNAL_KEY, node);
        } else if (traversableContext.get(PROJECT_INTERNAL_KEY) != null) {
            nodeUnderEdit = (HashStructureNode)traversableContext.get(PROJECT_INTERNAL_KEY);
        }
        if (!traversableContext.contains(WORKSPACE_INTERNAL_KEY)) {
            node = null;
            if (traversableContext.get("Application") instanceof Workspace) {
                HashStructureNode workspace = (HashStructureNode)traversableContext.get("Application");
                node = (HashStructureNode)workspace.copyTo(null);
                if (nodeUnderEdit == null) {
                    nodeUnderEdit = node;
                }
            }
            traversableContext.put(WORKSPACE_INTERNAL_KEY, (Object)node);
        } else if (nodeUnderEdit == null && traversableContext.get(WORKSPACE_INTERNAL_KEY) != null) {
            nodeUnderEdit = (HashStructureNode)traversableContext.get(WORKSPACE_INTERNAL_KEY);
        }
        return nodeUnderEdit;
    }

    private final JPanel getHostedPanel() {
        if (this._content == null) {
            this._content = new JPanel();
            this._decoratedComp = new HSAdapterDelegateComponent(this._content);
            super.setLayout((LayoutManager)new BorderLayout());
            super.add((Component)this._decoratedComp.getComponent(), (Object)"Center");
        }
        return this._content;
    }

    static enum PersistenceLocation {
        USER,
        BASE,
        PARENT;

    }

    private static class PropertyData
    implements PropertyStorage {
        private HashStructure propertyData;

        public PropertyData(HashStructure hash) {
            if (hash == null) {
                throw new IllegalArgumentException("The HashStructure cannot be null.");
            }
            this.propertyData = hash;
        }

        public HashStructure getProperties() {
            return this.propertyData;
        }
    }
}

