/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.panels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.config.SettingsUIRegistry;
import oracle.ide.model.ContentLevel;
import oracle.ide.model.ContentSetProviderReference;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.panels.ContentSetProviderNavigable;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.ApplyNotifier;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.NavigableContext;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.PanelsArb;
import oracle.ide.util.Namespace;
import oracle.javatools.data.ListStructure;

public abstract class ProjectContentNavigable
extends Navigable {
    private static String _defaultContentSetKey;
    private transient Navigable _navigable;
    public static final String PROPERTIES_NODE_LABEL;

    public ProjectContentNavigable() {
        super(PROPERTIES_NODE_LABEL);
        this.setChildComparator(ContentLevel.getContentSetDisplayableComparator());
    }

    public static void setDefaultContentSet(String contentSetKey) {
        if (_defaultContentSetKey != null) {
            System.err.println("*** Warning: Replacing previously registered default content set '" + _defaultContentSetKey + "' with '" + contentSetKey + "'.");
        }
        _defaultContentSetKey = contentSetKey;
    }

    protected abstract Navigable getGenericNavigable(String var1, String var2);

    public Traversable newTraversable(ApplyNotifier applyNotifier) {
        return this.getNavigableImpl().newTraversable(applyNotifier);
    }

    public Class getTraversableClass() {
        return this.getNavigableImpl().getTraversableClass();
    }

    public boolean isUsingTraversableDefaultConstructor() {
        return this.getNavigableImpl().isUsingTraversableDefaultConstructor();
    }

    protected boolean mayHaveChildren(NavigableContext nc) {
        Namespace scope = nc.getScope();
        Project project = (Project)scope.find("Project");
        if (project != null) {
            boolean isDefaultProject = ProjectSettingsTraversablePanel.isDefaultProject(scope);
            if (isDefaultProject) {
                ContentSetProviderReference[] providerReferences = ProjectContent.getContentSetProviderReferences();
                if (providerReferences.length > 1) {
                    return true;
                }
                if (providerReferences.length == 1) {
                    if (_defaultContentSetKey != null) {
                        return !_defaultContentSetKey.equals(providerReferences[0].key());
                    }
                    return true;
                }
                return false;
            }
            ListStructure list = ProjectContent.getInstance(project).getContentSetList();
            for (Object keyObj : list) {
                String key;
                if (keyObj == null || (key = keyObj.toString()).equals(_defaultContentSetKey)) continue;
                return true;
            }
        }
        return false;
    }

    protected void appendChildNavigables(DefaultMutableTreeNode parent, NavigableContext nc) {
        Navigable[] childNavigables;
        ArrayList<Navigable> childNavsList = new ArrayList<Navigable>();
        Namespace scope = nc.getScope();
        Project project = (Project)scope.find("Project");
        boolean isDefaultProject = ProjectSettingsTraversablePanel.isDefaultProject(scope);
        if (project != null) {
            Iterator keyIter;
            ContentSetProviderReference[] providerReferences = ProjectContent.getContentSetProviderReferences();
            int numProviders = providerReferences.length;
            if (isDefaultProject) {
                ArrayList<String> keys = new ArrayList<String>();
                for (int i = 0; i < numProviders; ++i) {
                    ContentSetProviderReference providerReference = providerReferences[i];
                    String key = providerReference.key();
                    if (key == null) continue;
                    keys.add(key);
                }
                keyIter = keys.iterator();
            } else {
                keyIter = ProjectContent.getInstance(project).getContentSetList().iterator();
            }
            Collection<String> hiddenPages = SettingsUIRegistry.getCustomizations().getHiddenPages();
            block1: while (keyIter.hasNext()) {
                String leafName;
                String key;
                Object keyObj = keyIter.next();
                if (keyObj == null || (key = keyObj.toString()).equals(_defaultContentSetKey) || !hiddenPages.isEmpty() && hiddenPages.contains(ProjectContentNavigable.pageId(key))) continue;
                for (int i = 0; i < numProviders; ++i) {
                    ContentSetProviderReference providerReference = providerReferences[i];
                    if (!key.equals(providerReference.key())) continue;
                    if (!providerReference.hasNavigable()) continue block1;
                    ContentSetProviderNavigable nav = new ContentSetProviderNavigable(providerReference);
                    childNavsList.add(nav);
                    continue block1;
                }
                int lastSlash = key.lastIndexOf(47);
                int afterLastSlash = lastSlash + 1;
                String string = leafName = afterLastSlash < key.length() ? key.substring(afterLastSlash) : key.substring(0, lastSlash);
                String label = "<" + leafName + ">";
                Navigable nav = this.getGenericNavigable(label, key);
                if (nav == null) continue;
                childNavsList.add(nav);
            }
        }
        if (!isDefaultProject && (childNavigables = this.getChildNavigables()) != null) {
            childNavsList.addAll(Arrays.asList(childNavigables));
        }
        Navigable[] childNavs = childNavsList.toArray(new Navigable[childNavsList.size()]);
        this.appendChildNodes(parent, childNavs, nc);
    }

    private static Navigable emptyPanel() {
        return new Navigable(PROPERTIES_NODE_LABEL, NullContentPanel.class);
    }

    private Navigable getNavigableImpl() {
        if (this._navigable == null) {
            if (_defaultContentSetKey == null) {
                this._navigable = ProjectContentNavigable.emptyPanel();
            } else {
                ContentSetProviderReference[] providerReferences;
                Collection<String> hiddenPages = SettingsUIRegistry.getCustomizations().getHiddenPages();
                for (ContentSetProviderReference provider : providerReferences = ProjectContent.getContentSetProviderReferences()) {
                    if (!_defaultContentSetKey.equals(provider.key())) continue;
                    if (hiddenPages.isEmpty() || !hiddenPages.contains(ProjectContentNavigable.pageId(provider.key()))) {
                        this._navigable = provider.contentSetProvider().getNavigable();
                    }
                    if (this._navigable != null) break;
                    this._navigable = ProjectContentNavigable.emptyPanel();
                    break;
                }
            }
        }
        return this._navigable;
    }

    private static String pageId(String key) {
        return "/Project/project-content/" + key;
    }

    static {
        PROPERTIES_NODE_LABEL = PanelsArb.getString(11);
    }

    private static final class NullContentPanel
    extends ProjectSettingsTraversablePanel {
        private NullContentPanel() {
        }

        @Override
        public void onProjectPanelEntry(TraversableContext traversableContext) {
        }

        @Override
        public String getDataKey() {
            return null;
        }

        @Override
        public String[] getPropertyKeys() {
            return new String[0];
        }
    }
}

