/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.XMLDataNode;
import oracle.ide.util.Assert;

public class XMLDataContainer
extends XMLDataNode
implements Folder {
    static final String ROOT_ELEMENT_NAME = "XMLDataContainer";

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    public boolean canAdd(Element element) {
        if (element == null) {
            return false;
        }
        Folder folder = this.getDataFolder();
        if (folder == null) {
            return false;
        }
        return folder.canAdd(element);
    }

    @Override
    public boolean add(Element element) {
        return this.add(element, false);
    }

    @Override
    public boolean canRemove(Element element) {
        if (element == null) {
            return false;
        }
        Folder folder = this.getDataFolder();
        if (folder == null) {
            return false;
        }
        return folder.canRemove(element);
    }

    @Override
    public boolean remove(Element element) {
        return this.remove(element, false);
    }

    @Override
    public boolean containsChild(Element child) {
        Folder folder = this.getDataFolder();
        return folder.containsChild(child);
    }

    @Override
    public int size() {
        Folder folder = this.getDataFolder();
        return folder.size();
    }

    @Override
    public void removeAll() {
        this.removeAll(false);
    }

    public boolean add(Element element, boolean notify) {
        Folder folder = this.getDataFolder();
        boolean addOk = false;
        if (folder.containsChild(element)) {
            Assert.println((String)("Element '" + element.getShortLabel() + "' already exists in '" + folder.getLongLabel() + "'!"));
        } else {
            addOk = folder.add(element);
            if (addOk && notify) {
                UpdateMessage.fireChildAdded(this, element);
            }
        }
        return addOk;
    }

    public boolean remove(Element element, boolean notify) {
        Folder folder = this.getDataFolder();
        boolean removeOk = false;
        if (!folder.containsChild(element)) {
            return false;
        }
        removeOk = folder.remove(element);
        if (removeOk && notify) {
            UpdateMessage.fireChildRemoved(this, element);
        }
        return removeOk;
    }

    public void removeAll(boolean notify) {
        Folder folder = this.getDataFolder();
        ArrayList childrenRemoved = new ArrayList();
        Iterator childrenIter = folder.getChildren();
        while (childrenIter.hasNext()) {
            childrenRemoved.add(childrenIter.next());
        }
        folder.removeAll();
        if (notify && childrenRemoved.size() > 0) {
            UpdateMessage.fireChildrenRemoved(this, childrenRemoved);
        }
    }

    protected final Folder getDataFolder() throws IllegalStateException {
        try {
            this.open();
            XMLDataNode.DataCastPacket data = this.getDataCastPacketDirectly();
            if (data == null || data.folder == null) {
                throw new IllegalStateException();
            }
            return data.folder;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

