/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.util.Collection;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.marshal.xml.ListStructureIO;
import oracle.ide.migration.Migrator;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.Assert;
import oracle.ide.util.FileCopyUtil2;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;

public final class UserPropertiesMigrator
implements Migrator {
    private static final int MY_CATEGORY = 0;
    private static final String APPLICATION_MIGRATION_PROP = "application.migration";

    @Override
    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    @Override
    public String getDescription(int category) {
        return "Custom Project Properties";
    }

    @Override
    public boolean canMigrate(int category, File sourceDir) {
        return category == 0;
    }

    @Override
    public void setSelected(int category, boolean selected) {
    }

    @Override
    public boolean isSelected(int category) {
        return category == 0;
    }

    @Override
    public String[] migrate(File srcDir, File dstDir) {
        URL dstProjectsDirURL;
        URL srcProjectsURL;
        boolean migrateApp;
        String migrateAppProperty = System.getProperty(APPLICATION_MIGRATION_PROP);
        boolean bl = migrateApp = migrateAppProperty == null || migrateAppProperty != null && Boolean.getBoolean(APPLICATION_MIGRATION_PROP);
        if (migrateApp && srcDir != null && srcDir.exists() && srcDir.getParent() != null) {
            UserPropertiesMigrator.findAndCopy(srcDir.getParentFile().toPath(), dstDir.getParentFile().toPath(), "applications.xml");
        }
        if (URLFileSystem.exists((URL)(srcProjectsURL = UserPropertiesMigrator.getProjectsURL(srcDir))) && !this.maybeMigrateIndexXml(srcProjectsURL, dstProjectsDirURL = UserPropertiesMigrator.getProjectsURL(dstDir))) {
            this.maybeMigrateIndex2Xml(srcProjectsURL, dstProjectsDirURL);
        }
        return null;
    }

    private boolean maybeMigrateIndexXml(URL fromSourceDir, URL toTargetDir) {
        ListStructure index = null;
        URL srcIndexURL = UserPropertiesMigrator.getIndexURL(fromSourceDir);
        if (!URLFileSystem.exists((URL)srcIndexURL)) {
            return false;
        }
        ListStructureIO io = new ListStructureIO(null, "index");
        try {
            index = (ListStructure)io.load(srcIndexURL);
            if (index != null) {
                URL dstIndexURL = UserPropertiesMigrator.getIndexURL(toTargetDir);
                io.save(dstIndexURL, (Object)index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (index != null) {
            for (Object obj : index) {
                if (!(obj instanceof HashStructure)) continue;
                this.copyUserPropertiesFile(fromSourceDir, toTargetDir, (HashStructure)obj);
            }
        }
        return true;
    }

    private void maybeMigrateIndex2Xml(URL sourceFolder, URL targetFolder) {
        HashStructure index = null;
        URL srcIndexURL = UserPropertiesMigrator.getIndex2URL(sourceFolder);
        HashStructureIO io = new HashStructureIO(null, "index");
        try {
            index = (HashStructure)io.load(srcIndexURL);
            if (index != null) {
                URL dstIndexURL = UserPropertiesMigrator.getIndex2URL(targetFolder);
                io.save(dstIndexURL, (Object)index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (index != null) {
            for (String key : index.keySet()) {
                HashStructure userPropertiesHash = index.getHashStructure(key);
                this.copyUserPropertiesFile(sourceFolder, targetFolder, userPropertiesHash);
            }
        }
    }

    private void copyUserPropertiesFile(URL fromDir, URL toDir, HashStructure hash) {
        URL srcUserFileURL;
        String userFileName = hash.getString("user");
        if (userFileName != null && URLFileSystem.exists((URL)(srcUserFileURL = URLFactory.newURL((URL)fromDir, (String)userFileName)))) {
            URL dstUserFileURL = URLFactory.newURL((URL)toDir, (String)userFileName);
            try {
                HashStructureIO io = new HashStructureIO("http://xmlns.oracle.com/ide/project", "jpr:project");
                HashStructure jprHash = (HashStructure)io.load(srcUserFileURL);
                if (jprHash != null) {
                    io.save(dstUserFileURL, (Object)jprHash);
                    this.maybeMigrateWorkingSets(hash, srcUserFileURL);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void maybeMigrateWorkingSets(HashStructure hash, URL userPropertiesFileURL) throws IllegalAccessException, InstantiationException {
        if (".jws".equals(URLFileSystem.getSuffix((URL)userPropertiesFileURL))) {
            Node node;
            long time = System.nanoTime();
            String workspaceKey = URLDecoder.decode(hash.getStructName());
            URL workspaceURL = URLFactory.newURL((String)workspaceKey);
            if (URLFileSystem.exists((URL)workspaceURL) && (node = NodeFactory.findOrCreate(workspaceURL)) instanceof Workspace) {
                Workspace workspace = (Workspace)node;
                WorkingSets.migrateExcludeListToIncludeList(workspace);
                PerformanceLogger.get().log("UserPropertiesMigrator.maybeMigrateWorkingSets", "Migrating working sets for " + node.getLongLabel(), System.nanoTime() - time);
                try {
                    workspace.saveUserProperties();
                }
                catch (IOException ioe) {
                    Assert.printStackTrace((Throwable)ioe);
                }
            }
        }
    }

    private static URL getProjectsURL(File dir) {
        return URLFactory.newDirURL((File)new File(dir, "projects"));
    }

    private static URL getIndexURL(URL projectsDir) {
        return URLFactory.newURL((URL)projectsDir, (String)"index.xml");
    }

    private static URL getIndex2URL(URL projectsDir) {
        return URLFactory.newURL((URL)projectsDir, (String)"index2.xml");
    }

    public static void findAndCopy(Path basePathFrom, Path basePathTo, String fileName) {
        Collection<File> allFrom = FileCopyUtil2.findFilesOrDirectories(basePathFrom.toFile(), fileName, true);
        Collection<File> allTo = FileCopyUtil2.findFilesOrDirectories(basePathTo.toFile(), fileName, true);
        if (allFrom.isEmpty() || allTo.isEmpty()) {
            return;
        }
        File from = allFrom.iterator().next();
        File to = allTo.iterator().next();
        if (from != null && to != null) {
            FileCopyUtil2.copyFiles(from.getPath(), to.getPath());
        }
    }

    public static void findAndCopy(Path basePathFrom, Path basePathTo, String fileName, String fromContainChild, String allMustContainParent) {
        Collection<File> allFrom = FileCopyUtil2.findFilesOrDirectories(basePathFrom.toFile(), fileName, false);
        Collection<File> allTo = FileCopyUtil2.findFilesOrDirectories(basePathTo.toFile(), fileName, false);
        if (allFrom.isEmpty() || allTo.isEmpty()) {
            return;
        }
        File fileFrom = null;
        File fileTo = null;
        for (File ff : allFrom) {
            if (!ff.getPath().contains(allMustContainParent) || FileCopyUtil2.findFilesOrDirectories(ff, fromContainChild, false).isEmpty()) continue;
            fileFrom = ff;
            break;
        }
        for (File ft : allTo) {
            if (!ft.getPath().contains(allMustContainParent)) continue;
            fileTo = ft;
            break;
        }
        if (fileFrom != null && fileTo != null) {
            FileCopyUtil2.copyFiles(fileFrom.getPath(), fileTo.getPath());
        }
    }
}

