/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;

public final class Reference {
    private transient Node _node;
    private URL _url;
    private Class _nodeClass;

    public Reference() {
    }

    Reference(URL url, String nodeClass) throws ClassNotFoundException {
        this._url = url;
        if (nodeClass != null && nodeClass.length() > 0) {
            this._nodeClass = Class.forName(nodeClass);
        }
    }

    public Reference(Node node) {
        this._node = node;
        this._nodeClass = node.getClass();
    }

    public Node getData() {
        if (this._node == null) {
            try {
                if (this._nodeClass != null) {
                    this._node = NodeFactory.findOrCreate(this._nodeClass, this._url);
                } else {
                    this._node = NodeFactory.findOrCreate(this._url);
                    if (this._node != null) {
                        this._nodeClass = this._node.getClass();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this._node;
    }

    public URL getURL() {
        if (this._node == null) {
            this.getData();
        }
        return this._node != null ? this._node.getURL() : null;
    }

    public void setURL(URL url) {
        if (this._node == null) {
            this._url = url;
        }
    }

    public Class getNodeClass() {
        return this._nodeClass;
    }

    public void setNodeClass(Class nodeClass) {
        this._nodeClass = nodeClass;
    }

    public String toString() {
        return this._node != null ? this._node.toString() : super.toString();
    }

    public int hashCode() {
        return this._node != null ? this._node.hashCode() : super.hashCode();
    }

    public boolean equals(Object obj) {
        return this._node != null ? this._node.equals(obj) : super.equals(obj);
    }
}

