/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.migration.NodeMigratorHelperReference;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class ProjectVersion
extends HashStructureAdapter {
    public static final String PROJECT_KEY = "oracle.ide.model.Project";
    public static final String COMPONENT_VERSIONS_KEY = "component-versions";

    public ProjectVersion(PropertyStorage project) {
        this(project.getProperties());
    }

    public ProjectVersion(HashStructure projectHash) {
        super(projectHash.getOrCreateHashStructure(COMPONENT_VERSIONS_KEY));
    }

    public static void initializeVersions(PropertyStorage project, String nodeMigratorKey) {
        NodeMigratorHelperReference[] helpers;
        NodeMigrator nodeMigrator = NodeMigrator.getNodeMigrator(nodeMigratorKey);
        if (nodeMigrator != null && (helpers = nodeMigrator.getHelperReferences()) != null) {
            ProjectVersion projectVersion = new ProjectVersion(project);
            for (NodeMigratorHelperReference helper : helpers) {
                String key = helper.key();
                if (key == null) continue;
                String versionStr = helper.version();
                projectVersion.addVersion(key, new VersionNumber(versionStr));
            }
        }
    }

    public VersionNumber getCurrentVersion() {
        return this.getCurrentVersion(PROJECT_KEY);
    }

    public VersionNumber[] getVersionHistory() {
        return this.getVersionHistory(PROJECT_KEY);
    }

    public VersionNumber getCurrentVersion(String componentName) {
        VersionNumber[] versionNumbers = this.getVersionHistory(componentName);
        int n = versionNumbers.length;
        return n > 0 ? versionNumbers[n - 1] : null;
    }

    public VersionNumber[] getVersionHistory(String componentName) {
        String str = this._hash.getString(componentName);
        Object[] vns = ProjectVersion.convertStringToVersionNumbers(str);
        Arrays.sort(vns);
        return vns;
    }

    public void setVersionHistory(String componentName, VersionNumber[] versionHistory) {
        String str = ProjectVersion.convertVersionNumbersToString(versionHistory);
        this._hash.putString(componentName, str);
    }

    public void addVersion(String componentName, VersionNumber version) {
        VersionNumber[] currentHistory;
        VersionNumber[] newVersions;
        if (version != null && (newVersions = ProjectVersion.addVersionImpl(currentHistory = this.getVersionHistory(componentName), version)) != currentHistory) {
            this.setVersionHistory(componentName, newVersions);
        }
    }

    public void removeVersion(String componentName, VersionNumber version) {
        VersionNumber[] currentHistory;
        VersionNumber[] newVersions;
        if (version != null && (newVersions = ProjectVersion.removeVersionImpl(currentHistory = this.getVersionHistory(componentName), version)) != currentHistory) {
            this.setVersionHistory(componentName, newVersions);
        }
    }

    static VersionNumber[] convertStringToVersionNumbers(String raw) {
        ArrayList<VersionNumber> versionNumbers = new ArrayList<VersionNumber>();
        if (raw != null) {
            StringTokenizer stok = new StringTokenizer(raw, ";");
            while (stok.hasMoreTokens()) {
                String tok = stok.nextToken();
                VersionNumber ver = new VersionNumber(tok);
                versionNumbers.add(ver);
            }
        }
        return versionNumbers.toArray(new VersionNumber[versionNumbers.size()]);
    }

    static String convertVersionNumbersToString(VersionNumber[] vns) {
        StringBuffer buf = new StringBuffer();
        if (vns != null) {
            int n = vns.length;
            int count = 0;
            for (int i = 0; i < n; ++i) {
                String str;
                VersionNumber vn = vns[i];
                if (vn == null || (str = vn.toString()).length() <= 0) continue;
                buf.append(str);
                buf.append(';');
                ++count;
            }
            if (count > 0) {
                buf.setLength(buf.length() - 1);
            }
        }
        return buf.toString();
    }

    static VersionNumber[] addVersionImpl(VersionNumber[] history, VersionNumber version) {
        if (history != null && history.length > 0) {
            int loc = Arrays.binarySearch(history, version);
            if (loc < 0) {
                int n = history.length;
                VersionNumber[] newVersions = new VersionNumber[n + 1];
                int insertionPoint = -loc - 1;
                System.arraycopy(history, 0, newVersions, 0, insertionPoint);
                newVersions[insertionPoint] = version;
                System.arraycopy(history, insertionPoint, newVersions, insertionPoint + 1, n - insertionPoint);
                return newVersions;
            }
            return history;
        }
        return new VersionNumber[]{version};
    }

    static VersionNumber[] removeVersionImpl(VersionNumber[] history, VersionNumber version) {
        if (history != null) {
            int loc;
            int n = history.length;
            if (n > 0 && (loc = Arrays.binarySearch(history, version)) >= 0) {
                VersionNumber[] newVersions = new VersionNumber[n - 1];
                System.arraycopy(history, 0, newVersions, 0, loc);
                System.arraycopy(history, loc + 1, newVersions, loc, n - loc - 1);
                return newVersions;
            }
            return history;
        }
        return new VersionNumber[0];
    }
}

